/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.listener;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.plugin.flink.FlinkOperation;
import org.apache.inlong.manager.plugin.flink.FlinkService;
import org.apache.inlong.manager.plugin.flink.dto.FlinkInfo;
import org.apache.inlong.manager.plugin.util.FlinkUtils;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteSortListener
implements SortOperateListener {
    private static final Logger log = LoggerFactory.getLogger(DeleteSortListener.class);

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            log.info("not add delete group listener, not GroupResourceProcessForm for groupId={}", (Object)groupId);
            return false;
        }
        GroupResourceProcessForm groupProcessForm = (GroupResourceProcessForm)processForm;
        if (groupProcessForm.getGroupOperateType() != GroupOperateType.DELETE) {
            log.info("not add delete group listener, as the operate was not DELETE for groupId={}", (Object)groupId);
            return false;
        }
        log.info("add delete group listener for groupId={}", (Object)groupId);
        return true;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        String jobId;
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            String message = String.format("process form was not GroupResourceProcessForm for groupId=%s", groupId);
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        GroupResourceProcessForm groupResourceProcessForm = (GroupResourceProcessForm)processForm;
        InlongGroupInfo inlongGroupInfo = groupResourceProcessForm.getGroupInfo();
        List extList = inlongGroupInfo.getExtList();
        log.info("inlong group ext info: {}", (Object)extList);
        HashMap kvConf = new HashMap();
        extList.forEach(groupExtInfo -> kvConf.put(groupExtInfo.getKeyName(), groupExtInfo.getKeyValue()));
        String sortExt = (String)kvConf.get("sort.properties");
        if (StringUtils.isNotEmpty((CharSequence)sortExt)) {
            Map result = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)JsonUtils.OBJECT_MAPPER.readTree(sortExt), (TypeReference)new TypeReference<Map<String, String>>(){});
            kvConf.putAll(result);
        }
        if (StringUtils.isBlank((CharSequence)(jobId = (String)kvConf.get("sort.job.id")))) {
            String message = String.format("sort job id is empty for groupId=%s", groupId);
            return ListenerResult.fail((String)message);
        }
        FlinkInfo flinkInfo = new FlinkInfo();
        flinkInfo.setJobId(jobId);
        String sortUrl = (String)kvConf.get("sort.url");
        flinkInfo.setEndpoint(sortUrl);
        FlinkService flinkService = new FlinkService(flinkInfo.getEndpoint());
        FlinkOperation flinkOperation = new FlinkOperation(flinkService);
        try {
            flinkOperation.delete(flinkInfo);
            log.info("job delete success for jobId={}", (Object)jobId);
            return ListenerResult.success();
        }
        catch (Exception e) {
            flinkInfo.setException(true);
            flinkInfo.setExceptionMsg(FlinkUtils.getExceptionStackMsg(e));
            flinkOperation.pollJobStatus(flinkInfo);
            String message = String.format("delete sort failed for groupId=%s", groupId);
            log.error(message, (Throwable)e);
            return ListenerResult.fail((String)(message + ": " + e.getMessage()));
        }
    }
}

