/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.InlongClient;
import org.apache.inlong.manager.client.api.InlongCluster;
import org.apache.inlong.manager.client.api.InlongGroup;
import org.apache.inlong.manager.client.api.impl.BlankInlongGroup;
import org.apache.inlong.manager.client.api.impl.InlongClusterImpl;
import org.apache.inlong.manager.client.api.impl.InlongGroupImpl;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.inner.client.InlongGroupClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;
import org.apache.inlong.manager.common.enums.SimpleSourceStatus;
import org.apache.inlong.manager.common.enums.SortStatus;
import org.apache.inlong.manager.common.util.HttpUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.cluster.BindTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagResponse;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.group.InlongGroupBriefInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupStatusInfo;
import org.apache.inlong.manager.pojo.sort.SortStatusInfo;
import org.apache.inlong.manager.pojo.sort.SortStatusRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlongClientImpl
implements InlongClient {
    private static final Logger log = LoggerFactory.getLogger(InlongClientImpl.class);
    private static final String URL_SPLITTER = ",";
    private static final String HOST_SPLITTER = ":";
    private final ClientConfiguration configuration;
    private final InlongGroupClient groupClient;
    private final InlongClusterClient clusterClient;

    public InlongClientImpl(String serviceUrl, ClientConfiguration configuration) {
        Map hostPorts = Splitter.on((String)URL_SPLITTER).withKeyValueSeparator(HOST_SPLITTER).split((CharSequence)serviceUrl);
        if (MapUtils.isEmpty((Map)hostPorts)) {
            throw new IllegalArgumentException(String.format("Unsupported serviceUrl: %s", serviceUrl));
        }
        configuration.setServiceUrl(serviceUrl);
        boolean isConnective = false;
        for (Map.Entry hostPort : hostPorts.entrySet()) {
            int port;
            String host = (String)hostPort.getKey();
            if (!HttpUtils.checkConnectivity((String)host, (int)(port = Integer.parseInt((String)hostPort.getValue())), (int)configuration.getReadTimeout(), (TimeUnit)configuration.getTimeUnit())) continue;
            configuration.setBindHost(host);
            configuration.setBindPort(port);
            isConnective = true;
            break;
        }
        if (!isConnective) {
            throw new RuntimeException(String.format("%s is not connective", serviceUrl));
        }
        this.configuration = configuration;
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.groupClient = clientFactory.getGroupClient();
        this.clusterClient = clientFactory.getClusterClient();
    }

    @Override
    public InlongCluster cluster() throws Exception {
        return new InlongClusterImpl(this);
    }

    @Override
    public InlongGroup forGroup(InlongGroupInfo groupInfo) {
        return new InlongGroupImpl(groupInfo, this.configuration);
    }

    @Override
    public List<InlongGroup> listGroup(String expr, int status, int pageNum, int pageSize) {
        PageResult<InlongGroupBriefInfo> pageInfo = this.groupClient.listGroups(expr, status, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return Lists.newArrayList();
        }
        return pageInfo.getList().stream().map(info -> {
            String groupId = info.getInlongGroupId();
            InlongGroupInfo groupInfo = this.groupClient.getGroupInfo(groupId);
            return new InlongGroupImpl(groupInfo, this.configuration);
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, InlongGroupStatusInfo> listGroupStatus(List<String> groupIds) {
        InlongGroupPageRequest request = new InlongGroupPageRequest();
        request.setGroupIdList(groupIds);
        request.setListSources(true);
        PageResult<InlongGroupBriefInfo> pageInfo = this.groupClient.listGroups(request);
        List briefInfos = pageInfo.getList();
        HashMap groupStatusMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)briefInfos)) {
            briefInfos.forEach(briefInfo -> {
                String groupId = briefInfo.getInlongGroupId();
                SimpleGroupStatus groupStatus = SimpleGroupStatus.parseStatusByCode((int)briefInfo.getStatus());
                List sources = briefInfo.getStreamSources();
                groupStatus = this.recheckGroupStatus(groupStatus, sources);
                InlongGroupStatusInfo statusInfo = InlongGroupStatusInfo.builder().inlongGroupId(briefInfo.getInlongGroupId()).originalStatus(briefInfo.getStatus()).simpleGroupStatus(groupStatus).streamSources(sources).build();
                groupStatusMap.put(groupId, statusInfo);
            });
        }
        return groupStatusMap;
    }

    @Override
    public Map<String, InlongGroupStatusInfo> listGroupStatus(List<String> groupIds, String credentials) {
        Map<String, InlongGroupStatusInfo> groupStatusMap = this.listGroupStatus(groupIds);
        SortStatusRequest statusRequest = new SortStatusRequest();
        statusRequest.setInlongGroupIds(groupIds);
        statusRequest.setCredentials(credentials);
        List<SortStatusInfo> sortStatusInfos = this.groupClient.listSortStatus(statusRequest);
        if (CollectionUtils.isNotEmpty(sortStatusInfos)) {
            Map sortStatusInfoMap = sortStatusInfos.stream().collect(Collectors.toMap(SortStatusInfo::getInlongGroupId, Function.identity()));
            groupStatusMap.forEach((groupId, groupStatusInfo) -> {
                groupStatusInfo.setSortStatus(SortStatus.NOT_EXISTS);
                SortStatusInfo sortStatusInfo = (SortStatusInfo)sortStatusInfoMap.get(groupId);
                if (sortStatusInfo != null) {
                    groupStatusInfo.getProperties().put("sort.properties", sortStatusInfo.getProperties());
                    groupStatusInfo.setSortStatus(sortStatusInfo.getSortStatus());
                }
            });
        }
        return groupStatusMap;
    }

    @Override
    public InlongGroup getGroup(String groupId) {
        InlongGroupInfo groupInfo = this.groupClient.getGroupInfo(groupId);
        if (groupInfo == null) {
            return new BlankInlongGroup();
        }
        return new InlongGroupImpl(groupInfo, this.configuration);
    }

    @Override
    public Integer saveTag(ClusterTagRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster request cannot be empty");
        Preconditions.expectNotBlank((String)request.getClusterTag(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster tag cannot be empty");
        return this.clusterClient.saveTag(request);
    }

    @Override
    public ClusterTagResponse getTag(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"inlong cluster tag id cannot be empty");
        return this.clusterClient.getTag(id);
    }

    @Override
    public PageResult<ClusterTagResponse> listTag(ClusterTagPageRequest request) {
        return this.clusterClient.listTag(request);
    }

    @Override
    public Boolean updateTag(ClusterTagRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster request cannot be empty");
        Preconditions.expectNotBlank((String)request.getClusterTag(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong cluster tag cannot be empty");
        Preconditions.expectNotNull((Object)request.getId(), (String)"cluster tag id cannot be empty");
        return this.clusterClient.updateTag(request);
    }

    @Override
    public Boolean deleteTag(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster tag id cannot be empty");
        return this.clusterClient.deleteTag(id);
    }

    @Override
    public Integer saveCluster(ClusterRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster request cannot be empty");
        return this.clusterClient.saveCluster(request);
    }

    @Override
    public ClusterInfo get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"inlong cluster id cannot be empty");
        return this.clusterClient.get(id);
    }

    @Override
    public PageResult<ClusterInfo> list(ClusterPageRequest request) {
        return this.clusterClient.list(request);
    }

    @Override
    public Boolean update(ClusterRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster info cannot be empty");
        Preconditions.expectNotNull((Object)request.getId(), (String)"inlong cluster id cannot be empty");
        return this.clusterClient.update(request);
    }

    @Override
    public Boolean bindTag(BindTagRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster info cannot be empty");
        Preconditions.expectNotBlank((String)request.getClusterTag(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster tag cannot be empty");
        return this.clusterClient.bindTag(request);
    }

    @Override
    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster id cannot be empty");
        return this.clusterClient.delete(id);
    }

    @Override
    public Integer saveNode(ClusterNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"cluster node info cannot be empty");
        return this.clusterClient.saveNode(request);
    }

    @Override
    public ClusterNodeResponse getNode(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster node id cannot be empty");
        return this.clusterClient.getNode(id);
    }

    @Override
    public PageResult<ClusterNodeResponse> listNode(ClusterPageRequest request) {
        Preconditions.expectNotNull((Object)request.getParentId(), (String)"parentId cannot be empty");
        return this.clusterClient.listNode(request);
    }

    @Override
    public List<ClusterNodeResponse> listNode(String inlongGroupId, String clusterType, String protocolType) {
        Preconditions.expectNotBlank((String)inlongGroupId, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlongGroupId cannot be empty");
        Preconditions.expectNotBlank((String)clusterType, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"clusterType cannot be empty");
        return this.clusterClient.listNode(inlongGroupId, clusterType, protocolType);
    }

    @Override
    public Boolean updateNode(ClusterNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster node cannot be empty");
        Preconditions.expectNotNull((Object)request.getId(), (String)"cluster node id cannot be empty");
        return this.clusterClient.updateNode(request);
    }

    @Override
    public Boolean deleteNode(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"cluster node id cannot be empty");
        return this.clusterClient.deleteNode(id);
    }

    private SimpleGroupStatus recheckGroupStatus(SimpleGroupStatus groupStatus, List<StreamSource> sources) {
        HashMap statusListMap = Maps.newHashMap();
        sources.forEach(source -> {
            SimpleSourceStatus status = SimpleSourceStatus.parseByStatus((int)source.getStatus());
            statusListMap.computeIfAbsent(status, k -> Lists.newArrayList()).add(source);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)statusListMap.get(SimpleSourceStatus.FAILED)))) {
            return SimpleGroupStatus.FAILED;
        }
        switch (groupStatus) {
            case STARTED: {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)statusListMap.get(SimpleSourceStatus.INIT)))) {
                    return SimpleGroupStatus.INITIALIZING;
                }
                return groupStatus;
            }
            case STOPPED: {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)statusListMap.get(SimpleSourceStatus.FREEZING)))) {
                    return SimpleGroupStatus.OPERATING;
                }
                return groupStatus;
            }
            case DELETED: {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)statusListMap.get(SimpleSourceStatus.DELETING)))) {
                    return SimpleGroupStatus.OPERATING;
                }
                return groupStatus;
            }
        }
        return groupStatus;
    }

    public ClientConfiguration getConfiguration() {
        return this.configuration;
    }
}

