/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.admin;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.inlong.dataproxy.admin.ProxyServiceMBean;
import org.apache.inlong.sdk.commons.admin.AbstractAdminEventHandler;

public class ProxyServiceAdminEventHandler
extends AbstractAdminEventHandler {
    public void configure(Context context) {
    }

    public void process(String cmd, Event event, HttpServletResponse response) {
        String sourceName = (String)event.getHeaders().get("sourceName");
        LOG.info("start to process admin task:{},sourceName:{}", (Object)cmd, (Object)sourceName);
        switch (cmd) {
            case "stopService": 
            case "recoverService": {
                if (sourceName == null) break;
                if (StringUtils.equals((CharSequence)sourceName, (CharSequence)"*")) {
                    this.processAll(cmd, event, response);
                    break;
                }
                this.processOne(cmd, sourceName, response);
                break;
            }
        }
        LOG.info("end to process admin task:{},sourceName:{}", (Object)cmd, (Object)sourceName);
    }

    private void processOne(String cmd, String sourceName, HttpServletResponse response) {
        LOG.info("start to processOne admin task:{},sort task:{}", (Object)cmd, (Object)sourceName);
        StringBuilder result = new StringBuilder();
        try {
            String beanName = "org.apache.inlong:type=ProxyService,name=" + sourceName;
            ObjectName objName = new ObjectName(beanName);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectInstance mbean = mbs.getObjectInstance(objName);
            LOG.info("getObjectInstance for type:{},name:{},result:{}", new Object[]{"ProxyService", sourceName, mbean});
            String className = mbean.getClassName();
            Class clazz = ClassUtils.getClass((String)className);
            if (ClassUtils.isAssignable((Class)clazz, ProxyServiceMBean.class)) {
                mbs.invoke(mbean.getObjectName(), cmd, null, null);
                result.append(String.format("Execute command:%s success in bean:%s\n", cmd, mbean.getObjectName().toString()));
            }
            this.outputResponse(response, result.toString());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.outputResponse(response, result.toString());
        }
        LOG.info("end to processOne admin task:{},sort task:{}", (Object)cmd, (Object)sourceName);
    }

    private void processAll(String cmd, Event event, HttpServletResponse response) {
        LOG.info("start to processAll admin task:{}", (Object)cmd);
        StringBuilder result = new StringBuilder();
        try {
            String beanName = "org.apache.inlong:type=ProxyService,*";
            ObjectName objName = new ObjectName(beanName.toString());
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectInstance> mbeans = mbs.queryMBeans(objName, null);
            LOG.info("queryMBeans for type:{},result:{}", (Object)"ProxyService", mbeans);
            for (ObjectInstance mbean : mbeans) {
                ObjectName beanObjectName = mbean.getObjectName();
                String className = mbean.getClassName();
                Class clazz = ClassUtils.getClass((String)className);
                if (!ClassUtils.isAssignable((Class)clazz, ProxyServiceMBean.class)) continue;
                mbs.invoke(mbean.getObjectName(), cmd, null, null);
                result.append(String.format("Execute command:%s success in bean:%s\n", cmd, beanObjectName.toString()));
            }
            this.outputResponse(response, result.toString());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.outputResponse(response, result.toString());
        }
        LOG.info("end to processAll admin task:{}", (Object)cmd);
    }
}

