/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.holder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.heartbeat.AddressInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceReportConfigHolder {
    public static final Logger LOG = LoggerFactory.getLogger(SourceReportConfigHolder.class);
    private final Map<String, AddressInfo> srcAddressMap = new ConcurrentHashMap<String, AddressInfo>();

    public void addSourceInfo(String sourceIp, String sourcePort, String rptSrcType, String protocolType) {
        if (StringUtils.isEmpty((CharSequence)sourceIp) || StringUtils.isEmpty((CharSequence)sourcePort) || StringUtils.isEmpty((CharSequence)rptSrcType) || StringUtils.isEmpty((CharSequence)protocolType)) {
            LOG.warn("[Source Report Holder] found empty parameter!, add values is {}, {}, {}, {}", new Object[]{sourceIp, sourcePort, rptSrcType, protocolType});
            return;
        }
        String recordKey = sourceIp + "#" + sourcePort + "#" + protocolType;
        this.srcAddressMap.put(recordKey, new AddressInfo(sourceIp, sourcePort, rptSrcType, protocolType));
    }

    public Map<String, AddressInfo> getSrcAddressInfos() {
        return this.srcAddressMap;
    }
}

