/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.base;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final AtomicInteger mThreadNum = new AtomicInteger(1);
    private final String threadType;

    public NamedThreadFactory(String threadType) {
        this.threadType = threadType;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.threadType + "-running-thread-" + this.mThreadNum.getAndIncrement());
        LOGGER.debug("{} created", (Object)t.getName());
        return t;
    }
}

