/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.holder;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.dataproxy.config.holder.PropertiesHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightConfigHolder
extends PropertiesHolder {
    private static final String weightConfigFileName = "weight.properties";
    private static final Logger LOG = LoggerFactory.getLogger(WeightConfigHolder.class);
    private static final String KEY_WEIGHT_CPU = "cpuWeight";
    private static final double VAL_DEF_WEIGHT_CPU = 1.0;
    private static final String KEY_WEIGHT_NET_IN = "netinWeight";
    private static final double VAL_DEF_WEIGHT_NET_IN = 0.5;
    private static final String KEY_WEIGHT_NET_OUT = "netoutWeight";
    private static final double VAL_DEF_WEIGHT_NET_OUT = 0.5;
    private static final String KEY_WEIGHT_TCP = "tcpWeight";
    private static final double VAL_DEF_WEIGHT_TCP = 0.0;
    private static final String KEY_WEIGHT_CPU_THRESHOLD = "cpuThreshold";
    private static final double VAL_DEF_WEIGHT_CPU_THRESHOLD = 85.0;
    private final AtomicDouble cachedCpuWeight = new AtomicDouble(1.0);
    private final AtomicDouble cachedNetInWeight = new AtomicDouble(0.5);
    private final AtomicDouble cachedNetOutWeight = new AtomicDouble(0.5);
    private final AtomicDouble cachedTcpWeight = new AtomicDouble(0.0);
    private final AtomicDouble cachedCpuThreshold = new AtomicDouble(85.0);

    public WeightConfigHolder() {
        super(weightConfigFileName);
    }

    public double getCachedCpuWeight() {
        return this.cachedCpuWeight.get();
    }

    public double getCachedNetInWeight() {
        return this.cachedNetInWeight.get();
    }

    public double getCachedNetOutWeight() {
        return this.cachedNetOutWeight.get();
    }

    public double getCachedTcpWeight() {
        return this.cachedTcpWeight.get();
    }

    public double getCachedCpuThreshold() {
        return this.cachedCpuThreshold.get();
    }

    @Override
    protected Map<String, String> filterInValidRecords(Map<String, String> configMap) {
        HashMap<String, String> filteredMap = new HashMap<String, String>(configMap.size());
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            if (entry == null || StringUtils.isBlank((CharSequence)entry.getKey()) || StringUtils.isBlank((CharSequence)entry.getValue())) continue;
            try {
                Double.parseDouble(entry.getValue());
            }
            catch (Throwable e) {
                continue;
            }
            filteredMap.put(entry.getKey().trim(), entry.getValue().trim());
        }
        return filteredMap;
    }

    @Override
    protected boolean updateCacheData() {
        double newVal = 1.0;
        String tmpStrVal = (String)this.confHolder.get(KEY_WEIGHT_CPU);
        if (StringUtils.isNotBlank((CharSequence)tmpStrVal)) {
            try {
                newVal = Double.parseDouble(tmpStrVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.cachedCpuWeight.set(newVal);
        newVal = 0.5;
        tmpStrVal = (String)this.confHolder.get(KEY_WEIGHT_NET_IN);
        if (StringUtils.isNotBlank((CharSequence)tmpStrVal)) {
            try {
                newVal = Double.parseDouble(tmpStrVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.cachedNetInWeight.set(newVal);
        newVal = 0.5;
        tmpStrVal = (String)this.confHolder.get(KEY_WEIGHT_NET_OUT);
        if (StringUtils.isNotBlank((CharSequence)tmpStrVal)) {
            try {
                newVal = Double.parseDouble(tmpStrVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.cachedNetOutWeight.set(newVal);
        newVal = 0.0;
        tmpStrVal = (String)this.confHolder.get(KEY_WEIGHT_TCP);
        if (StringUtils.isNotBlank((CharSequence)tmpStrVal)) {
            try {
                newVal = Double.parseDouble(tmpStrVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.cachedTcpWeight.set(newVal);
        newVal = 85.0;
        tmpStrVal = (String)this.confHolder.get(KEY_WEIGHT_CPU_THRESHOLD);
        if (StringUtils.isNotBlank((CharSequence)tmpStrVal)) {
            try {
                newVal = Double.parseDouble(tmpStrVal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.cachedCpuThreshold.set(newVal);
        return true;
    }
}

