/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Context;
import org.apache.inlong.common.enums.InlongCompressType;
import org.apache.inlong.dataproxy.sink.common.DefaultEventHandler;
import org.apache.inlong.dataproxy.sink.mq.AllCacheClusterSelector;
import org.apache.inlong.dataproxy.utils.AddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfigHolder {
    private static final Logger LOG = LoggerFactory.getLogger(CommonConfigHolder.class);
    private static final String COMMON_CONFIG_FILE_NAME = "common.properties";
    private static final String VAL_CONFIG_ITEMS_SEPARATOR = ",|\\s+";
    @Deprecated
    private static final String KEY_PROXY_NODE_ID = "nodeId";
    private static final String KEY_PROXY_NODE_IDV2 = "proxy.node.id";
    private static final String VAL_DEF_PROXY_NODE_ID = "127.0.0.1";
    private static final String KEY_PROXY_CLUSTER_TAG = "proxy.cluster.tag";
    private static final String VAL_DEF_CLUSTER_TAG = "default_cluster";
    private static final String KEY_PROXY_CLUSTER_NAME = "proxy.cluster.name";
    private static final String VAL_DEF_CLUSTER_NAME = "default_dataproxy";
    @Deprecated
    private static final String KEY_PROXY_CLUSTER_INCHARGES = "proxy.cluster.inCharges";
    private static final String KEY_PROXY_CLUSTER_INCHARGESV2 = "proxy.cluster.incharges";
    private static final String VAL_DEF_CLUSTER_INCHARGES = "admin";
    @Deprecated
    private static final String KEY_PROXY_CLUSTER_EXT_TAG = "proxy.cluster.extTag";
    private static final String KEY_PROXY_CLUSTER_EXT_TAGV2 = "proxy.cluster.ext.tag";
    private static final String VAL_DEF_CLUSTER_EXT_TAG = "default=true";
    private static final String KEY_MANAGER_HOSTS = "manager.hosts";
    private static final String KEY_MANAGER_HOST_PORT_SEPARATOR = ":";
    @Deprecated
    private static final String KEY_MANAGER_AUTH_SECRET_ID = "manager.auth.secretId";
    private static final String KEY_MANAGER_AUTH_SECRET_IDV2 = "manager.auth.secret.id";
    @Deprecated
    private static final String KEY_MANAGER_AUTH_SECRET_KEY = "manager.auth.secretKey";
    private static final String KEY_MANAGER_AUTH_SECRET_KEYV2 = "manager.auth.secret.key";
    @Deprecated
    private static final String KEY_CONFIG_CHECK_INTERVAL_MS = "configCheckInterval";
    private static final String KEY_META_CONFIG_SYNC_INTERVAL_MS = "meta.config.sync.interval.ms";
    private static final long VAL_DEF_CONFIG_SYNC_INTERVAL_MS = 60000L;
    private static final long VAL_MIN_CONFIG_SYNC_INTERVAL_MS = 10000L;
    private static final String KEY_META_CONFIG_SYNC_WAST_ALARM_MS = "meta.config.sync.wast.alarm.ms";
    private static final long VAL_DEF_META_CONFIG_SYNC_WAST_ALARM_MS = 40000L;
    @Deprecated
    private static final String KEY_ENABLE_STARTUP_USING_LOCAL_META_FILE = "startup.using.local.meta.file.enable";
    private static final String KEY_ENABLE_STARTUP_USING_LOCAL_META_FILEV2 = "meta.config.startup.using.local.file.enable";
    private static final boolean VAL_DEF_ENABLE_STARTUP_USING_LOCAL_META_FILE = false;
    private static final String KEY_ENABLE_FILE_METRIC = "file.metric.enable";
    private static final boolean VAL_DEF_ENABLE_FILE_METRIC = true;
    private static final String KEY_FILE_METRIC_STAT_INTERVAL_SEC = "file.metric.stat.interval.sec";
    private static final int VAL_DEF_FILE_METRIC_STAT_INVL_SEC = 60;
    private static final int VAL_MIN_FILE_METRIC_STAT_INVL_SEC = 0;
    private static final String KEY_FILE_METRIC_MAX_CACHE_CNT = "file.metric.max.cache.cnt";
    private static final int VAL_DEF_FILE_METRIC_MAX_CACHE_CNT = 1000000;
    private static final int VAL_MIN_FILE_METRIC_MAX_CACHE_CNT = 0;
    private static final String KEY_FILE_METRIC_SOURCE_OUTPUT_NAME = "file.metric.source.output.name";
    private static final String VAL_DEF_FILE_METRIC_SOURCE_OUTPUT_NAME = "Source";
    private static final String KEY_FILE_METRIC_SINK_OUTPUT_NAME = "file.metric.sink.output.name";
    private static final String VAL_DEF_FILE_METRIC_SINK_OUTPUT_NAME = "Sink";
    private static final String KEY_FILE_METRIC_EVENT_OUTPUT_NAME = "file.metric.event.output.name";
    private static final String VAL_DEF_FILE_METRIC_EVENT_OUTPUT_NAME = "Stats";
    @Deprecated
    private static final String KEY_PROMETHEUS_HTTP_PORT = "prometheusHttpPort";
    private static final String KEY_PROMETHEUS_HTTP_PORTV2 = "online.metric.prometheus.http.port";
    private static final int VAL_DEF_PROMETHEUS_HTTP_PORT = 8080;
    private static final String KEY_ENABLE_AUDIT = "audit.enable";
    private static final boolean VAL_DEF_ENABLE_AUDIT = true;
    private static final String KEY_AUDIT_PROXYS_DISCOVERY_MANAGER_ENABLE = "audit.proxys.discovery.manager.enable";
    private static final boolean VAL_DEF_AUDIT_PROXYS_DISCOVERY_MANAGER_ENABLE = false;
    private static final String KEY_AUDIT_PROXYS = "audit.proxys";
    @Deprecated
    private static final String KEY_AUDIT_FILE_PATH = "audit.filePath";
    private static final String KEY_AUDIT_FILE_PATHV2 = "audit.file.path";
    private static final String VAL_DEF_AUDIT_FILE_PATH = "/data/inlong/audit/";
    @Deprecated
    private static final String KEY_AUDIT_MAX_CACHE_ROWS = "audit.maxCacheRows";
    private static final String KEY_AUDIT_MAX_CACHE_ROWSV2 = "audit.max.cache.rows";
    private static final int VAL_DEF_AUDIT_MAX_CACHE_ROWS = 2000000;
    @Deprecated
    private static final String KEY_AUDIT_FORMAT_INTERVAL_MS = "auditFormatInterval";
    private static final String KEY_AUDIT_TIME_FORMAT_INTERVAL = "audit.time.format.intvl.ms";
    private static final long VAL_DEF_AUDIT_FORMAT_INTERVAL_MS = 60000L;
    private static final String KEY_V1MSG_RESPONSE_BY_SINK = "isResponseAfterSave";
    private static final String KEY_V1MSG_RESPONSE_BY_SINKV2 = "proxy.v1msg.response.by.sink.enable";
    private static final boolean VAL_DEF_V1MSG_RESPONSE_BY_SINK = false;
    @Deprecated
    private static final String KEY_V1MSG_SENT_COMPRESS_TYPE = "compressType";
    private static final String KEY_V1MSG_SENT_COMPRESS_TYPEV2 = "proxy.v1msg.compress.type";
    private static final InlongCompressType VAL_DEF_V1MSG_COMPRESS_TYPE = InlongCompressType.INLONG_SNAPPY;
    private static final String KEY_MAX_RAS_TIMEOUT_MS = "maxRASTimeoutMs";
    private static final long VAL_DEF_MAX_RAS_TIMEOUT_MS = 10000L;
    @Deprecated
    private static final String KEY_DEF_BUFFERQUEUE_SIZE_KB = "maxBufferQueueSizeKb";
    private static final String KEY_DEF_BUFFERQUEUE_SIZE_KBV2 = "proxy.def.buffer.queue.size.KB";
    private static final int VAL_DEF_BUFFERQUEUE_SIZE_KB = 131072;
    @Deprecated
    private static final String KEY_ENABLE_SEND_RETRY_AFTER_FAILURE = "send.retry.after.failure";
    private static final String KEY_ENABLE_SEND_RETRY_AFTER_FAILUREV2 = "msg.send.failure.retry.enable";
    private static final boolean VAL_DEF_ENABLE_SEND_RETRY_AFTER_FAILURE = true;
    private static final String KEY_MAX_RETRIES_AFTER_FAILURE = "max.retries.after.failure";
    private static final String KEY_MAX_RETRIES_AFTER_FAILUREV2 = "msg.max.retries";
    private static final int VAL_DEF_MAX_RETRIES_AFTER_FAILURE = -1;
    private static final String KEY_ENABLE_UNCONFIGURED_TOPIC_ACCEPT = "id2topic.unconfigured.accept.enable";
    private static final boolean VAL_DEF_ENABLE_UNCONFIGURED_TOPIC_ACCEPT = false;
    private static final String KEY_UNCONFIGURED_TOPIC_DEFAULT_TOPICS = "id2topic.unconfigured.default.topics";
    @Deprecated
    private static final String KEY_ENABLE_WHITELIST = "proxy.enable.whitelist";
    private static final String KEY_ENABLE_WHITELISTV2 = "proxy.visit.whitelist.enable";
    private static final boolean VAL_DEF_ENABLE_WHITELIST = false;
    private static final String KEY_EVENT_HANDLER = "eventHandler";
    private static final String VAL_DEF_EVENT_HANDLER = DefaultEventHandler.class.getName();
    @Deprecated
    private static final String KEY_CACHE_CLUSTER_SELECTOR = "cacheClusterSelector";
    private static final String KEY_CACHE_CLUSTER_SELECTORV2 = "proxy.mq.cluster.selector";
    private static final String VAL_DEF_CACHE_CLUSTER_SELECTOR = AllCacheClusterSelector.class.getName();
    private static CommonConfigHolder instance = null;
    private static volatile boolean isInit = false;
    private Map<String, String> props;
    private String clusterTag = "default_cluster";
    private String clusterName = "default_dataproxy";
    private String clusterIncharges = "admin";
    private String clusterExtTag = "default=true";
    private final List<String> managerIpList = new ArrayList<String>();
    private String managerAuthSecretId = "";
    private String managerAuthSecretKey = "";
    private boolean enableStartupUsingLocalMetaFile = false;
    private long metaConfigSyncInvlMs = 60000L;
    private long metaConfigWastAlarmMs = 40000L;
    private boolean enableAudit = true;
    private boolean enableAuditProxysDiscoveryFromManager = false;
    private final HashSet<String> auditProxys = new HashSet();
    private String auditFilePath = "/data/inlong/audit/";
    private int auditMaxCacheRows = 2000000;
    private long auditFormatInvlMs = 60000L;
    private boolean enableUnConfigTopicAccept = false;
    private final List<String> defaultTopics = new ArrayList<String>();
    private boolean enableFileMetric = true;
    private int fileMetricStatInvlSec = 60;
    private int fileMetricStatCacheCnt = 1000000;
    private String fileMetricSourceOutName = "Source";
    private String fileMetricSinkOutName = "Sink";
    private String fileMetricEventOutName = "Stats";
    private InlongCompressType defV1MsgCompressType = VAL_DEF_V1MSG_COMPRESS_TYPE;
    private boolean defV1MsgResponseBySink = false;
    private long maxResAfterSaveTimeout = 10000L;
    private boolean enableWhiteList = false;
    private int defBufferQueueSizeKB = 131072;
    private String eventHandler = VAL_DEF_EVENT_HANDLER;
    private String cacheClusterSelector = VAL_DEF_CACHE_CLUSTER_SELECTOR;
    private String proxyNodeId = "127.0.0.1";
    private int prometheusHttpPort = 8080;
    private boolean sendRetryAfterFailure = true;
    private int maxRetriesAfterFailure = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonConfigHolder getInstance() {
        if (isInit && instance != null) {
            return instance;
        }
        Class<CommonConfigHolder> clazz = CommonConfigHolder.class;
        synchronized (CommonConfigHolder.class) {
            if (!isInit) {
                instance = new CommonConfigHolder();
                if (instance.loadConfigFile()) {
                    instance.preReadFields();
                    LOG.info("{} load and read result is: {}", (Object)COMMON_CONFIG_FILE_NAME, (Object)instance.toString());
                }
                isInit = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public static String getStringFromContext(Context context, String key, String defaultValue) {
        String value = context.getString(key);
        value = value != null ? value : CommonConfigHolder.getInstance().getProperties().getOrDefault(key, defaultValue);
        return value;
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterIncharges() {
        return this.clusterIncharges;
    }

    public String getClusterExtTag() {
        return this.clusterExtTag;
    }

    public long getMetaConfigSyncInvlMs() {
        return this.metaConfigSyncInvlMs;
    }

    public long getMetaConfigWastAlarmMs() {
        return this.metaConfigWastAlarmMs;
    }

    public boolean isEnableUnConfigTopicAccept() {
        return this.enableUnConfigTopicAccept;
    }

    public List<String> getDefTopics() {
        return this.defaultTopics;
    }

    public String getRandDefTopics() {
        if (this.defaultTopics.isEmpty()) {
            return null;
        }
        SecureRandom rand = new SecureRandom();
        return this.defaultTopics.get(rand.nextInt(this.defaultTopics.size()));
    }

    public boolean isEnableWhiteList() {
        return this.enableWhiteList;
    }

    public List<String> getManagerHosts() {
        return this.managerIpList;
    }

    public String getManagerAuthSecretId() {
        return this.managerAuthSecretId;
    }

    public String getManagerAuthSecretKey() {
        return this.managerAuthSecretKey;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public boolean isEnableAuditProxysDiscoveryFromManager() {
        return this.enableAuditProxysDiscoveryFromManager;
    }

    public boolean isEnableFileMetric() {
        return this.enableFileMetric;
    }

    public int getFileMetricStatInvlSec() {
        return this.fileMetricStatInvlSec;
    }

    public int getFileMetricStatCacheCnt() {
        return this.fileMetricStatCacheCnt;
    }

    public HashSet<String> getAuditProxys() {
        return this.auditProxys;
    }

    public String getAuditFilePath() {
        return this.auditFilePath;
    }

    public int getAuditMaxCacheRows() {
        return this.auditMaxCacheRows;
    }

    public long getAuditFormatInvlMs() {
        return this.auditFormatInvlMs;
    }

    public boolean isDefV1MsgResponseBySink() {
        return this.defV1MsgResponseBySink;
    }

    public long getMaxResAfterSaveTimeout() {
        return this.maxResAfterSaveTimeout;
    }

    public int getDefBufferQueueSizeKB() {
        return this.defBufferQueueSizeKB;
    }

    public boolean isEnableStartupUsingLocalMetaFile() {
        return this.enableStartupUsingLocalMetaFile;
    }

    public String getEventHandler() {
        return this.eventHandler;
    }

    public String getCacheClusterSelector() {
        return this.cacheClusterSelector;
    }

    public int getPrometheusHttpPort() {
        return this.prometheusHttpPort;
    }

    public String getProxyNodeId() {
        return this.proxyNodeId;
    }

    public InlongCompressType getDefV1MsgCompressType() {
        return this.defV1MsgCompressType;
    }

    public String getFileMetricSourceOutName() {
        return this.fileMetricSourceOutName;
    }

    public String getFileMetricSinkOutName() {
        return this.fileMetricSinkOutName;
    }

    public String getFileMetricEventOutName() {
        return this.fileMetricEventOutName;
    }

    public boolean isSendRetryAfterFailure() {
        return this.sendRetryAfterFailure;
    }

    public int getMaxRetriesAfterFailure() {
        return this.maxRetriesAfterFailure;
    }

    private void preReadFields() {
        int retries;
        String tmpValue = this.props.get(KEY_PROXY_CLUSTER_TAG);
        if (StringUtils.isNotBlank((CharSequence)tmpValue)) {
            this.clusterTag = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_PROXY_CLUSTER_NAME)))) {
            this.clusterName = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_PROXY_CLUSTER_INCHARGESV2, KEY_PROXY_CLUSTER_INCHARGES)))) {
            this.clusterIncharges = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_PROXY_CLUSTER_EXT_TAGV2, KEY_PROXY_CLUSTER_EXT_TAG)))) {
            this.clusterExtTag = tmpValue.trim();
        }
        this.preReadManagerSetting();
        this.preReadDefTopicSetting();
        tmpValue = this.compatGetValue(this.props, KEY_ENABLE_WHITELISTV2, KEY_ENABLE_WHITELIST);
        if (StringUtils.isNotBlank((CharSequence)tmpValue)) {
            this.enableWhiteList = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_MAX_RAS_TIMEOUT_MS)))) {
            this.maxResAfterSaveTimeout = NumberUtils.toLong((String)tmpValue.trim(), (long)10000L);
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_DEF_BUFFERQUEUE_SIZE_KBV2, KEY_DEF_BUFFERQUEUE_SIZE_KB)))) {
            this.defBufferQueueSizeKB = NumberUtils.toInt((String)tmpValue.trim(), (int)131072);
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_CACHE_CLUSTER_SELECTORV2, KEY_CACHE_CLUSTER_SELECTOR)))) {
            this.cacheClusterSelector = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_EVENT_HANDLER)))) {
            this.eventHandler = tmpValue.trim();
        }
        this.proxyNodeId = StringUtils.isBlank((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_PROXY_NODE_IDV2, KEY_PROXY_NODE_ID))) ? AddressUtils.getSelfHost() : tmpValue.trim();
        tmpValue = this.compatGetValue(this.props, KEY_PROMETHEUS_HTTP_PORTV2, KEY_PROMETHEUS_HTTP_PORT);
        if (StringUtils.isNotBlank((CharSequence)tmpValue)) {
            this.prometheusHttpPort = NumberUtils.toInt((String)tmpValue.trim(), (int)8080);
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_ENABLE_SEND_RETRY_AFTER_FAILUREV2, KEY_ENABLE_SEND_RETRY_AFTER_FAILURE)))) {
            this.sendRetryAfterFailure = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_MAX_RETRIES_AFTER_FAILUREV2, KEY_MAX_RETRIES_AFTER_FAILURE))) && (retries = NumberUtils.toInt((String)tmpValue.trim(), (int)-1)) >= 0) {
            this.maxRetriesAfterFailure = retries;
        }
        this.preReadAuditSetting();
        this.preReadMetricSetting();
        this.preReadV1MsgSetting();
    }

    private void preReadManagerSetting() {
        long tmpSyncInvMs;
        String tmpValue;
        String[] hostPortList;
        String managerHosts = this.props.get(KEY_MANAGER_HOSTS);
        if (StringUtils.isBlank((CharSequence)managerHosts)) {
            LOG.error("Value of {} is required in {}, exit!", (Object)KEY_MANAGER_HOSTS, (Object)COMMON_CONFIG_FILE_NAME);
            System.exit(2);
        }
        managerHosts = managerHosts.trim();
        for (String tmpItem : hostPortList = managerHosts.split(VAL_CONFIG_ITEMS_SEPARATOR)) {
            String[] hostPort;
            if (StringUtils.isBlank((CharSequence)tmpItem) || (hostPort = tmpItem.split(KEY_MANAGER_HOST_PORT_SEPARATOR)).length != 2 || StringUtils.isBlank((CharSequence)hostPort[0]) || StringUtils.isBlank((CharSequence)hostPort[1])) continue;
            this.managerIpList.add(hostPort[0].trim() + KEY_MANAGER_HOST_PORT_SEPARATOR + hostPort[1].trim());
        }
        if (this.managerIpList.isEmpty()) {
            LOG.error("Invalid value {} in configure item {}, exit!", (Object)managerHosts, (Object)KEY_MANAGER_HOSTS);
            System.exit(2);
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_MANAGER_AUTH_SECRET_IDV2, KEY_MANAGER_AUTH_SECRET_ID)))) {
            this.managerAuthSecretId = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_MANAGER_AUTH_SECRET_KEYV2, KEY_MANAGER_AUTH_SECRET_KEY)))) {
            this.managerAuthSecretKey = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_ENABLE_STARTUP_USING_LOCAL_META_FILEV2, KEY_ENABLE_STARTUP_USING_LOCAL_META_FILE)))) {
            this.enableStartupUsingLocalMetaFile = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_META_CONFIG_SYNC_INTERVAL_MS, KEY_CONFIG_CHECK_INTERVAL_MS))) && (tmpSyncInvMs = NumberUtils.toLong((String)tmpValue.trim(), (long)60000L)) >= 10000L) {
            this.metaConfigSyncInvlMs = tmpSyncInvMs;
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_META_CONFIG_SYNC_WAST_ALARM_MS)))) {
            this.metaConfigWastAlarmMs = NumberUtils.toLong((String)tmpValue.trim(), (long)40000L);
        }
    }

    private void preReadDefTopicSetting() {
        String tmpValue = this.props.get(KEY_ENABLE_UNCONFIGURED_TOPIC_ACCEPT);
        if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
            this.enableUnConfigTopicAccept = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_UNCONFIGURED_TOPIC_DEFAULT_TOPICS)))) {
            String[] topicItems;
            for (String item : topicItems = tmpValue.split(VAL_CONFIG_ITEMS_SEPARATOR)) {
                if (StringUtils.isBlank((CharSequence)item)) continue;
                this.defaultTopics.add(item.trim());
            }
            LOG.info("Configured {}, size is {}, value is {}", new Object[]{KEY_UNCONFIGURED_TOPIC_DEFAULT_TOPICS, this.defaultTopics.size(), this.defaultTopics});
        }
        if (this.enableUnConfigTopicAccept && this.defaultTopics.isEmpty()) {
            LOG.error("Required {} field value is blank in {} for {} is true, exit!", new Object[]{KEY_UNCONFIGURED_TOPIC_DEFAULT_TOPICS, COMMON_CONFIG_FILE_NAME, KEY_ENABLE_UNCONFIGURED_TOPIC_ACCEPT});
            System.exit(2);
        }
    }

    private void preReadMetricSetting() {
        int maxCacheCnt;
        int statInvl;
        String tmpValue = this.props.get(KEY_ENABLE_FILE_METRIC);
        if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
            this.enableFileMetric = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_STAT_INTERVAL_SEC))) && (statInvl = NumberUtils.toInt((String)tmpValue.trim(), (int)60)) >= 0) {
            this.fileMetricStatInvlSec = statInvl;
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_MAX_CACHE_CNT))) && (maxCacheCnt = NumberUtils.toInt((String)tmpValue.trim(), (int)1000000)) >= 0) {
            this.fileMetricStatCacheCnt = maxCacheCnt;
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_SOURCE_OUTPUT_NAME)))) {
            this.fileMetricSourceOutName = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_SINK_OUTPUT_NAME)))) {
            this.fileMetricSinkOutName = tmpValue.trim();
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_FILE_METRIC_EVENT_OUTPUT_NAME)))) {
            this.fileMetricEventOutName = tmpValue.trim();
        }
    }

    private void preReadAuditSetting() {
        String tmpValue = this.props.get(KEY_ENABLE_AUDIT);
        if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
            this.enableAudit = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.props.get(KEY_AUDIT_PROXYS_DISCOVERY_MANAGER_ENABLE)))) {
            this.enableAuditProxysDiscoveryFromManager = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.props.get(KEY_AUDIT_PROXYS)))) {
            String[] ipPorts;
            for (String tmpIPPort : ipPorts = tmpValue.split(VAL_CONFIG_ITEMS_SEPARATOR)) {
                if (StringUtils.isBlank((CharSequence)tmpIPPort)) continue;
                this.auditProxys.add(tmpIPPort.trim());
            }
        }
        if (this.enableAudit && !this.enableAuditProxysDiscoveryFromManager && this.auditProxys.isEmpty()) {
            LOG.error("{}'s {} must be configured when {} is true and {} is false, exist!", new Object[]{COMMON_CONFIG_FILE_NAME, KEY_AUDIT_PROXYS, KEY_ENABLE_AUDIT, KEY_AUDIT_PROXYS_DISCOVERY_MANAGER_ENABLE});
            System.exit(2);
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_AUDIT_FILE_PATHV2, KEY_AUDIT_FILE_PATH)))) {
            this.auditFilePath = tmpValue.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_AUDIT_MAX_CACHE_ROWSV2, KEY_AUDIT_MAX_CACHE_ROWS)))) {
            this.auditMaxCacheRows = NumberUtils.toInt((String)tmpValue.trim(), (int)2000000);
        }
        if (StringUtils.isNotEmpty((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_AUDIT_TIME_FORMAT_INTERVAL, KEY_AUDIT_FORMAT_INTERVAL_MS)))) {
            this.auditFormatInvlMs = NumberUtils.toLong((String)tmpValue.trim(), (long)60000L);
        }
    }

    private void preReadV1MsgSetting() {
        String tmpValue = this.compatGetValue(this.props, KEY_V1MSG_RESPONSE_BY_SINKV2, KEY_V1MSG_RESPONSE_BY_SINK);
        if (StringUtils.isNotEmpty((CharSequence)tmpValue)) {
            this.defV1MsgResponseBySink = "TRUE".equalsIgnoreCase(tmpValue.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(tmpValue = this.compatGetValue(this.props, KEY_V1MSG_SENT_COMPRESS_TYPEV2, KEY_V1MSG_SENT_COMPRESS_TYPE)))) {
            InlongCompressType tmpCompType = InlongCompressType.forType((String)tmpValue.trim());
            if (tmpCompType == InlongCompressType.UNKNOWN) {
                LOG.error("{}'s {}({}) must be in allowed range [{}], exist!", new Object[]{COMMON_CONFIG_FILE_NAME, KEY_V1MSG_SENT_COMPRESS_TYPEV2, tmpValue, InlongCompressType.allowedCompressTypes});
                System.exit(2);
            }
            this.defV1MsgCompressType = tmpCompType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConfigFile() {
        InputStream inStream = null;
        try {
            URL url = this.getClass().getClassLoader().getResource(COMMON_CONFIG_FILE_NAME);
            InputStream inputStream = inStream = url != null ? url.openStream() : null;
            if (inStream == null) {
                LOG.error("Fail to open {} as the input stream is null, exit!", (Object)COMMON_CONFIG_FILE_NAME);
                System.exit(1);
                boolean bl = false;
                return bl;
            }
            Properties tmpProps = new Properties();
            tmpProps.load(inStream);
            this.props = new HashMap<String, String>(tmpProps.size());
            for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                String strKey = (String)entry.getKey();
                String strVal = (String)entry.getValue();
                if (StringUtils.isBlank((CharSequence)strKey) || StringUtils.isBlank((CharSequence)strVal)) continue;
                this.props.put(strKey.trim(), strVal.trim());
            }
            LOG.info("Read success from {}, content is {}", (Object)COMMON_CONFIG_FILE_NAME, this.props);
        }
        catch (Throwable e) {
            LOG.error("Fail to load properties from {}, exit!", (Object)COMMON_CONFIG_FILE_NAME, (Object)e);
            System.exit(1);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOG.error("Fail to InputStream.close() for file {}, exit!", (Object)COMMON_CONFIG_FILE_NAME, (Object)e);
                    System.exit(1);
                }
            }
        }
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("props", this.props).append("clusterTag", (Object)this.clusterTag).append("clusterName", (Object)this.clusterName).append("clusterIncharges", (Object)this.clusterIncharges).append("clusterExtTag", (Object)this.clusterExtTag).append("managerIpList", this.managerIpList).append("managerAuthSecretId", (Object)this.managerAuthSecretId).append("managerAuthSecretKey", (Object)this.managerAuthSecretKey).append("enableStartupUsingLocalMetaFile", this.enableStartupUsingLocalMetaFile).append("metaConfigSyncInvlMs", this.metaConfigSyncInvlMs).append("metaConfigWastAlarmMs", this.metaConfigWastAlarmMs).append("enableAudit", this.enableAudit).append("enableAuditProxysDiscoveryFromManager", this.enableAuditProxysDiscoveryFromManager).append("auditProxys", this.auditProxys).append("auditFilePath", (Object)this.auditFilePath).append("auditMaxCacheRows", this.auditMaxCacheRows).append("auditFormatInvlMs", this.auditFormatInvlMs).append("enableUnConfigTopicAccept", this.enableUnConfigTopicAccept).append("defaultTopics", this.defaultTopics).append("enableFileMetric", this.enableFileMetric).append("fileMetricStatInvlSec", this.fileMetricStatInvlSec).append("fileMetricStatCacheCnt", this.fileMetricStatCacheCnt).append("fileMetricSourceOutName", (Object)this.fileMetricSourceOutName).append("fileMetricSinkOutName", (Object)this.fileMetricSinkOutName).append("fileMetricEventOutName", (Object)this.fileMetricEventOutName).append("defV1MsgCompressType", (Object)this.defV1MsgCompressType).append("defV1MsgResponseBySink", this.defV1MsgResponseBySink).append("maxResAfterSaveTimeout", this.maxResAfterSaveTimeout).append("enableWhiteList", this.enableWhiteList).append("defBufferQueueSizeKB", this.defBufferQueueSizeKB).append(KEY_EVENT_HANDLER, (Object)this.eventHandler).append(KEY_CACHE_CLUSTER_SELECTOR, (Object)this.cacheClusterSelector).append("proxyNodeId", (Object)this.proxyNodeId).append(KEY_PROMETHEUS_HTTP_PORT, this.prometheusHttpPort).append("sendRetryAfterFailure", this.sendRetryAfterFailure).append("maxRetriesAfterFailure", this.maxRetriesAfterFailure).toString();
    }

    private String compatGetValue(Map<String, String> attrs, String newKey, String depKey) {
        String tmpValue = attrs.get(newKey);
        if (StringUtils.isBlank((CharSequence)tmpValue) && StringUtils.isNotEmpty((CharSequence)(tmpValue = attrs.get(depKey)))) {
            LOG.warn("** Deprecated configure key {}, replaced by {} **", (Object)depKey, (Object)newKey);
        }
        return tmpValue;
    }
}

