/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.source.v0msg;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Event;
import org.apache.flume.event.EventBuilder;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.common.msg.InLongMsg;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.base.SinkRspEvent;
import org.apache.inlong.dataproxy.config.ConfigManager;
import org.apache.inlong.dataproxy.source.BaseSource;
import org.apache.inlong.dataproxy.source.v0msg.AbsV0MsgCodec;

public class CodecBinMsg
extends AbsV0MsgCodec {
    private int groupIdNum;
    private int streamIdNum;
    private int extendField;
    private long dataTimeSec;
    private boolean num2name = false;
    private boolean transNum2Name = false;
    private boolean needTraceMsg = false;

    public CodecBinMsg(int totalDataLen, int msgTypeValue, long msgRcvTime, String strRemoteIP) {
        super(totalDataLen, msgTypeValue, msgRcvTime, strRemoteIP);
    }

    @Override
    public boolean descMsg(BaseSource source, ByteBuf cb) throws Exception {
        int msgHeadPos = cb.readerIndex() - 5;
        this.groupIdNum = cb.getUnsignedShort(5);
        this.streamIdNum = cb.getUnsignedShort(7);
        this.extendField = cb.getUnsignedShort(9);
        this.dataTimeSec = cb.getUnsignedInt(11);
        this.dataTimeMs = this.dataTimeSec * 1000L;
        this.msgCount = cb.getUnsignedShort(15);
        this.msgCount = this.msgCount != 0 ? this.msgCount : 1;
        this.uniq = cb.getUnsignedInt(17);
        int bodyLen = cb.getInt(msgHeadPos + 21);
        short attrLen = cb.getShort(msgHeadPos + 25 + bodyLen);
        int msgMagic = cb.getUnsignedShort(msgHeadPos + 25 + bodyLen + 2 + attrLen);
        if (bodyLen <= 0) {
            if (bodyLen == 0) {
                source.fileMetricIncSumStats("msg.body.zero");
                this.errCode = DataProxyErrCode.BODY_LENGTH_ZERO;
            } else {
                source.fileMetricIncSumStats("msg.body.negative");
                this.errCode = DataProxyErrCode.BODY_LENGTH_LESS_ZERO;
            }
            return false;
        }
        if (attrLen < 0) {
            source.fileMetricIncSumStats("msg.attr.negative");
            this.errCode = DataProxyErrCode.ATTR_LENGTH_LESS_ZERO;
            return false;
        }
        if (msgMagic != 60929) {
            source.fileMetricIncSumStats("msg.magic.unequal");
            this.errCode = DataProxyErrCode.FIELD_MAGIC_NOT_EQUAL;
            this.errMsg = String.format("magicInMsg(%d) != %d", msgMagic, 60929);
            return false;
        }
        if (this.totalDataLen + 4 < bodyLen + attrLen + 29) {
            source.fileMetricIncSumStats("msg.bin.len.malformed");
            this.errCode = DataProxyErrCode.FIELD_LENGTH_VALUE_NOT_EQUAL;
            this.errMsg = String.format("fixedLen(%d) + bodyLen(%d) + attrLen(%d) > totalDataLen(%d) + 4", 29, bodyLen, (int)attrLen, this.totalDataLen);
            return false;
        }
        if (!this.decAttrInfo(source, cb, attrLen, msgHeadPos + 25 + bodyLen + 2)) {
            return false;
        }
        this.bodyData = new byte[bodyLen];
        cb.getBytes(msgHeadPos + 25, this.bodyData, 0, bodyLen);
        if ((this.extendField & 8) == 8 || (this.extendField & 0x10) == 16) {
            this.indexMsg = true;
            boolean bl = this.fileCheckMsg = (this.extendField & 8) == 8;
        }
        if ((this.extendField & 2) >> 1 == 1) {
            this.needTraceMsg = true;
        }
        if ((this.extendField & 4) >> 2 == 0) {
            this.num2name = true;
        }
        return true;
    }

    @Override
    public boolean validAndFillFields(BaseSource source, StringBuilder strBuff) {
        if (this.indexMsg) {
            source.fileMetricIncSumStats("msg.index.illegal");
            this.errCode = DataProxyErrCode.UNSUPPORTED_EXTEND_FIELD_VALUE;
            return false;
        }
        if (!this.validAndFillTopic(source)) {
            return false;
        }
        this.msgSeqId = strBuff.append(this.groupId).append("&").append(this.streamId).append("&").append(this.strRemoteIP).append("#").append(this.dataTimeMs).append("#").append(this.uniq).toString();
        strBuff.delete(0, strBuff.length());
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.attrMap.get("rtms")))) {
            strBuff.append("rtms").append("=").append(this.msgRcvTime);
            this.attrMap.put("rtms", String.valueOf(this.msgRcvTime));
        }
        if (this.needTraceMsg) {
            if (strBuff.length() > 0) {
                strBuff.append("&");
            }
            strBuff.append("node2ip").append("=").append(source.getStrPort()).append("&").append("rtime2").append("=").append(this.msgRcvTime);
            this.attrMap.put("node2ip", source.getSrcHost());
            this.attrMap.put("rtime2", String.valueOf(this.msgRcvTime));
        }
        if (this.transNum2Name) {
            if (strBuff.length() > 0) {
                strBuff.append("&");
            }
            strBuff.append("groupId").append("=").append(this.groupId).append("&").append("streamId").append("=").append(this.streamId);
            for (Map.Entry entry : this.attrMap.entrySet()) {
                if ("groupId".equalsIgnoreCase((String)entry.getKey()) || "streamId".equalsIgnoreCase((String)entry.getKey())) continue;
                strBuff.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            this.groupIdNum = 0;
            this.streamIdNum = 0;
            this.num2name = false;
            this.extendField |= 4;
            this.attrMap.put("groupId", this.groupId);
            this.attrMap.put("streamId", this.streamId);
        }
        if (strBuff.length() > 0) {
            if (StringUtils.isNotBlank((CharSequence)this.origAttr)) {
                strBuff.append("&").append(this.origAttr);
            }
            this.totalDataLen += strBuff.length() - this.origAttr.length();
            this.origAttr = strBuff.toString();
            strBuff.delete(0, strBuff.length());
        }
        return true;
    }

    @Override
    public Event encEventPackage(BaseSource source, Channel channel) {
        int totalPkgLength = this.totalDataLen + 4;
        ByteBuffer dataBuf = ByteBuffer.allocate(totalPkgLength);
        dataBuf.putInt(0, this.totalDataLen);
        dataBuf.put(4, this.msgType);
        dataBuf.putShort(5, (short)this.groupIdNum);
        dataBuf.putShort(7, (short)this.streamIdNum);
        dataBuf.putShort(9, (short)this.extendField);
        dataBuf.putInt(11, (int)this.dataTimeSec);
        dataBuf.putShort(15, (short)this.msgCount);
        dataBuf.putInt(17, (int)this.uniq);
        dataBuf.putInt(21, this.bodyData.length);
        if (this.bodyData.length > 0) {
            System.arraycopy(this.bodyData, 0, dataBuf.array(), 25, this.bodyData.length);
        }
        dataBuf.putShort(totalPkgLength - 2 - 2 - this.origAttr.length(), (short)this.origAttr.length());
        if (this.origAttr.length() > 0) {
            System.arraycopy(this.origAttr.getBytes(StandardCharsets.UTF_8), 0, dataBuf.array(), totalPkgLength - 2 - this.origAttr.length(), this.origAttr.length());
        }
        dataBuf.putShort(totalPkgLength - 2, (short)-4607);
        InLongMsg inLongMsg = InLongMsg.newInLongMsg((boolean)source.isCompressed(), (int)4);
        inLongMsg.addMsg(dataBuf.array());
        byte[] inlongMsgData = inLongMsg.buildArray();
        this.msgPkgTime = inLongMsg.getCreatetime();
        Event event = EventBuilder.withBody((byte[])inlongMsgData, this.buildEventHeaders(source));
        if (this.isOrderOrProxy) {
            event = new SinkRspEvent(event, MsgType.MSG_BIN_MULTI_BODY, channel);
        }
        inLongMsg.reset();
        return event;
    }

    private boolean validAndFillTopic(BaseSource source) {
        ConfigManager configManager = ConfigManager.getInstance();
        this.groupId = (String)this.attrMap.get("groupId");
        this.streamId = (String)this.attrMap.get("streamId");
        if (this.num2name) {
            if (this.groupIdNum == 0) {
                source.fileMetricIncSumStats("msg.groupidnum.zero");
                this.errCode = DataProxyErrCode.MISS_REQUIRED_GROUPID_ARGUMENT;
                this.errMsg = "groupIdNum is 0 in message";
                return false;
            }
            String strGroupIdNum = String.valueOf(this.groupIdNum);
            String confGroupId = configManager.getGroupIdNameByNum(strGroupIdNum);
            if (StringUtils.isEmpty((CharSequence)confGroupId)) {
                if (configManager.isGroupIdNumConfigEmpty()) {
                    source.fileMetricIncSumStats("config.idnum.empty");
                    this.errCode = DataProxyErrCode.CONF_SERVICE_UNREADY;
                    this.errMsg = "GroupId-Mapping configuration is null";
                } else {
                    source.fileMetricIncSumStats("config.groupidnum.missing");
                    this.errCode = DataProxyErrCode.GROUPID_OR_STREAMID_NOT_CONFIGURE;
                    this.errMsg = String.format("Non-existing groupIdNum(%s) configuration", strGroupIdNum);
                }
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)this.groupId) && !this.groupId.equals(confGroupId)) {
                source.fileMetricIncSumStats("config.group.idnum.incons");
                this.errCode = DataProxyErrCode.GROUPID_OR_STREAMID_INCONSTANT;
                this.errMsg = String.format("Inconstant GroupId not equal, (%s) in attr but (%s) in configure by groupIdNum(%s)", this.groupId, confGroupId, strGroupIdNum);
                return false;
            }
            this.groupId = confGroupId;
            if (this.streamIdNum == 0) {
                if (StringUtils.isNotBlank((CharSequence)this.streamId)) {
                    source.fileMetricIncSumStats("msg.streamidnum.zero");
                    this.errCode = DataProxyErrCode.GROUPID_OR_STREAMID_INCONSTANT;
                    this.errMsg = String.format("Inconstant streamId(%s) in attr but streamIdNum=0", this.streamId);
                    return false;
                }
            } else {
                String strStreamIdNum = String.valueOf(this.streamIdNum);
                String confStreamId = configManager.getStreamIdNameByIdNum(strGroupIdNum, strStreamIdNum);
                if (StringUtils.isEmpty((CharSequence)confStreamId)) {
                    if (configManager.isStreamIdNumConfigEmpty()) {
                        source.fileMetricIncSumStats("config.idnum.empty");
                        this.errCode = DataProxyErrCode.CONF_SERVICE_UNREADY;
                        this.errMsg = "StreamId-Mapping configuration is null";
                    } else {
                        source.fileMetricIncSumStats("config.streamidnum.missing");
                        this.errCode = DataProxyErrCode.GROUPID_OR_STREAMID_NOT_CONFIGURE;
                        this.errMsg = String.format("Non-existing GroupId(%s)-StreamId(%s) configuration", strGroupIdNum, strStreamIdNum);
                    }
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)this.streamId) && !this.streamId.equals(confStreamId)) {
                    source.fileMetricIncSumStats("config.stream.idnum.incons");
                    this.errCode = DataProxyErrCode.GROUPID_OR_STREAMID_INCONSTANT;
                    this.errMsg = String.format("Inconstant StreamId, (%s) in attr but (%s) in configure by groupIdNum(%s), streamIdNum(%s)", this.streamId, confStreamId, strGroupIdNum, strStreamIdNum);
                    return false;
                }
                this.streamId = confStreamId;
            }
            if (configManager.isEnableNum2NameTrans(strGroupIdNum) && this.num2name) {
                this.transNum2Name = true;
            }
        } else if (StringUtils.isBlank((CharSequence)this.groupId)) {
            source.fileMetricIncSumStats("msg.groupid.missing");
            this.errCode = DataProxyErrCode.MISS_REQUIRED_GROUPID_ARGUMENT;
            return false;
        }
        this.topicName = configManager.getTopicName(this.groupId, this.streamId);
        if (StringUtils.isEmpty((CharSequence)this.topicName)) {
            source.fileMetricIncWithDetailStats("source.topic.missing", this.groupId);
            this.errCode = DataProxyErrCode.TOPIC_IS_BLANK;
            this.errMsg = String.format("Topic not configured for groupId=(%s), streamId=(%s)", this.groupId, this.streamId);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.streamId)) {
            this.streamId = "";
        }
        return true;
    }
}

