/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.sender;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.inlong.sdk.dataproxy.MsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.common.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.config.ConfigHolder;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigEntry;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigManager;
import org.apache.inlong.sdk.dataproxy.metric.MetricDataHolder;
import org.apache.inlong.sdk.dataproxy.network.ClientMgr;
import org.apache.inlong.sdk.dataproxy.network.PkgCacheQuota;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.apache.inlong.sdk.dataproxy.utils.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSender
implements ConfigHolder {
    private final int SENDER_STATUS_UNINITIALIZED = -2;
    private final int SENDER_STATUS_INITIALIZING = -1;
    private final int SENDER_STATUS_STARTED = 0;
    private final int SENDER_STATUS_CLOSED = 1;
    protected static final Logger logger = LoggerFactory.getLogger(BaseSender.class);
    protected static final LogCounter exceptCnt = new LogCounter(10L, 100000L, 60000L);
    private static final AtomicLong senderIdGen = new AtomicLong(0L);
    protected final AtomicInteger senderStatus = new AtomicInteger(-2);
    protected final MsgSenderFactory senderFactory;
    private final String factoryClusterIdKey;
    protected final String senderId;
    protected final ProxyClientConfig baseConfig;
    protected ClientMgr clientMgr;
    protected ProxyConfigManager configManager;
    private final ReentrantReadWriteLock fsLock = new ReentrantReadWriteLock(true);
    private final ConcurrentHashMap<String, HostInfo> proxyNodeInfos = new ConcurrentHashMap();
    private volatile int allowedPkgLength = -1;
    protected volatile boolean idTransNum = false;
    protected volatile int groupIdNum = 0;
    private Map<String, Integer> streamIdMap = new HashMap<String, Integer>();
    private final PkgCacheQuota globalCacheQuota;
    private final PkgCacheQuota sdkPkgCacheQuota;
    protected MetricDataHolder metricHolder;

    protected BaseSender(ProxyClientConfig configure, MsgSenderFactory senderFactory, String clusterIdKey) {
        if (configure == null) {
            throw new NullPointerException("configure is null");
        }
        this.baseConfig = configure.clone();
        this.senderFactory = senderFactory;
        this.factoryClusterIdKey = clusterIdKey;
        this.senderId = configure.getDataRptProtocol() + "-" + ProxyUtils.getProcessPid() + "-" + senderIdGen.incrementAndGet();
        this.configManager = new ProxyConfigManager(this.senderId, this.baseConfig, this);
        this.configManager.setDaemon(true);
        this.metricHolder = new MetricDataHolder(this);
        this.globalCacheQuota = this.senderFactory == null ? null : this.senderFactory.getFactoryPkgCacheQuota();
        this.sdkPkgCacheQuota = new PkgCacheQuota(false, this.senderId, configure.getMaxInFlightReqCnt(), configure.getMaxInFlightSizeKb(), configure.getPaddingSize());
    }

    public boolean start(ProcessResult procResult) {
        if (!this.senderStatus.compareAndSet(-2, -1)) {
            return procResult.setSuccess();
        }
        if (!this.metricHolder.start(procResult)) {
            return false;
        }
        if (!this.clientMgr.start(procResult)) {
            return false;
        }
        if (!this.configManager.doProxyEntryQueryWork(procResult)) {
            this.clientMgr.stop();
            String errInfo = "queryCode=" + procResult.getErrCode() + ", detail=" + procResult.getErrMsg();
            return procResult.setFailResult(ErrorCode.FETCH_PROXY_META_FAILURE, errInfo);
        }
        if (this.baseConfig.isEnableReportEncrypt() && !this.configManager.doEncryptConfigEntryQueryWork(procResult)) {
            this.clientMgr.stop();
            String errInfo = "queryCode=" + procResult.getErrCode() + ", detail=" + procResult.getErrMsg();
            return procResult.setFailResult(ErrorCode.FETCH_ENCRYPT_META_FAILURE, errInfo);
        }
        this.configManager.start();
        this.senderStatus.set(0);
        logger.info("Sender({}) instance started!", (Object)this.senderId);
        return procResult.setSuccess();
    }

    public void close() {
        int currentStatus = this.senderStatus.get();
        if (currentStatus == 1) {
            return;
        }
        if (!this.senderStatus.compareAndSet(currentStatus, 1)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        logger.info("Sender({}) instance is stopping...", (Object)this.senderId);
        this.configManager.shutDown();
        this.clientMgr.stop();
        this.metricHolder.close();
        if (this.senderFactory != null) {
            this.senderFactory.removeClient(this);
        }
        logger.info("Sender({}) instance stopped, cost {} ms!", (Object)this.senderId, (Object)(System.currentTimeMillis() - startTime));
    }

    @Override
    public void updateAllowedMaxPkgLength(int maxPkgLength) {
        this.allowedPkgLength = maxPkgLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProxyNodes(boolean nodeChanged, List<HostInfo> newProxyNodes) {
        if (this.senderStatus.get() == 1 || newProxyNodes == null || newProxyNodes.isEmpty()) {
            return;
        }
        this.fsLock.writeLock().lock();
        try {
            ArrayList<String> rmvNodes = new ArrayList<String>();
            for (String hostRefName : this.proxyNodeInfos.keySet()) {
                boolean found = false;
                for (HostInfo hostInfo : newProxyNodes) {
                    if (!hostRefName.equals(hostInfo.getReferenceName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                rmvNodes.add(hostRefName);
            }
            for (HostInfo hostInfo : newProxyNodes) {
                if (this.proxyNodeInfos.containsKey(hostInfo.getReferenceName())) continue;
                this.proxyNodeInfos.put(hostInfo.getReferenceName(), hostInfo);
            }
            for (String rmvNode : rmvNodes) {
                this.proxyNodeInfos.remove(rmvNode);
            }
            this.clientMgr.updateProxyInfoList(nodeChanged, this.proxyNodeInfos);
        }
        finally {
            this.fsLock.writeLock().unlock();
        }
    }

    @Override
    public MetricDataHolder getMetricHolder() {
        return this.metricHolder;
    }

    public boolean isStarted() {
        return this.senderStatus.get() == 0;
    }

    public boolean isGenByFactory() {
        return this.senderFactory != null;
    }

    public MsgSenderFactory getSenderFactory() {
        return this.senderFactory;
    }

    public String getFactoryClusterIdKey() {
        return this.factoryClusterIdKey;
    }

    public String getMetaConfigKey() {
        return this.baseConfig.getGroupMetaConfigKey();
    }

    public ProxyConfigEntry getProxyConfigEntry() {
        return this.configManager.getProxyConfigEntry();
    }

    public String getSenderId() {
        return this.senderId;
    }

    public ProxyClientConfig getConfigure() {
        return this.baseConfig;
    }

    public int getAllowedPkgLength() {
        return this.allowedPkgLength;
    }

    public String getGroupId() {
        return this.baseConfig.getInlongGroupId();
    }

    public boolean isMetaInfoUnReady() {
        return this.proxyNodeInfos.isEmpty();
    }

    public Map<String, HostInfo> getProxyNodeInfos() {
        return this.proxyNodeInfos;
    }

    public int getProxyNodeCnt() {
        return this.proxyNodeInfos.size();
    }

    public Tuple2<Integer, Integer> getFactoryAvailQuota() {
        if (this.senderFactory == null || this.globalCacheQuota == null) {
            return PkgCacheQuota.DISABLE_RET;
        }
        return this.globalCacheQuota.getPkgCacheAvailQuota();
    }

    public Tuple2<Integer, Integer> getSenderAvailQuota() {
        return this.sdkPkgCacheQuota.getPkgCacheAvailQuota();
    }

    public int getFactoryPkgCntPermits() {
        if (this.senderFactory == null || this.senderFactory.getFactoryPkgCacheQuota() == null) {
            return -1;
        }
        return this.senderFactory.getFactoryPkgCacheQuota().getPkgCntPermits();
    }

    public int getFactoryPkgSizeKbPermits() {
        if (this.senderFactory == null || this.senderFactory.getFactoryPkgCacheQuota() == null) {
            return -1;
        }
        return this.senderFactory.getFactoryPkgCacheQuota().getPkgSizeKbPermits();
    }

    public int getSenderPkgCntPermits() {
        return this.sdkPkgCacheQuota.getPkgCntPermits();
    }

    public int getSenderPkgSizeKbPermits() {
        return this.sdkPkgCacheQuota.getPkgSizeKbPermits();
    }

    public boolean tryAcquireCachePermits(int sizeInByte, ProcessResult procResult) {
        if (this.globalCacheQuota == null) {
            return this.sdkPkgCacheQuota.tryAcquire(sizeInByte, procResult);
        }
        if (this.globalCacheQuota.tryAcquire(sizeInByte, procResult)) {
            if (this.sdkPkgCacheQuota.tryAcquire(sizeInByte, procResult)) {
                return true;
            }
            this.globalCacheQuota.release(sizeInByte);
            return false;
        }
        return false;
    }

    public void releaseCachePermits(int sizeInByte) {
        if (this.globalCacheQuota == null) {
            this.sdkPkgCacheQuota.release(sizeInByte);
        } else {
            this.sdkPkgCacheQuota.release(sizeInByte);
            this.globalCacheQuota.release(sizeInByte);
        }
    }

    public abstract int getActiveNodeCnt();

    public abstract int getInflightMsgCnt();

    public void updateGroupIdAndStreamIdNumInfo(int groupIdNum, Map<String, Integer> streamIdMap) {
        this.groupIdNum = groupIdNum;
        this.streamIdMap = streamIdMap;
        if (groupIdNum != 0 && streamIdMap != null && !streamIdMap.isEmpty()) {
            this.idTransNum = true;
        }
    }

    protected int getStreamIdNum(String streamId) {
        Integer tmpNum;
        if (this.idTransNum && (tmpNum = this.streamIdMap.get(streamId)) != null) {
            return tmpNum;
        }
        return 0;
    }
}

