/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.store.route;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.entity.AuditRoute;
import org.apache.inlong.audit.file.ConfigManager;
import org.apache.inlong.audit.store.entities.ServiceResponse;
import org.apache.inlong.audit.utils.HttpUtils;
import org.apache.inlong.audit.utils.NamedThreadFactory;
import org.apache.inlong.audit.utils.RouteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditRouteManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditRouteManager.class);
    private static final int PERIOD_MS = 60000;
    private static final AuditRouteManager instance = new AuditRouteManager();
    private volatile List<AuditRoute> auditRoutes = new CopyOnWriteArrayList();
    private final ScheduledExecutorService timerExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("update-audit-route"));
    private final Gson gson = new Gson();
    private static final String REQUEST_PARAM_HOST = "host";

    private AuditRouteManager() {
    }

    public void init(String jdbcUrl) {
        String serviceAddr = ConfigManager.getInstance().getValue("audit.service.addr", "http://localhost:10080");
        String routeApi = ConfigManager.getInstance().getValue("audit.service.route.api", "/audit/query/getAuditRoute");
        int timeoutMs = ConfigManager.getInstance().getValue("audit.service.timeout.ms", 30000);
        String fullUrl = serviceAddr + routeApi;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(REQUEST_PARAM_HOST, RouteUtils.extractAddress((String)jdbcUrl));
        LOGGER.info("AuditRouteCache init, audit service url: {}, timeoutMs: {}, params: {}", new Object[]{fullUrl, timeoutMs, requestParams});
        this.timerExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.updateAuditRouteCache(fullUrl, timeoutMs, requestParams);
            }
            catch (Exception e) {
                LOGGER.error("Exception occurred during audit route cache update", (Throwable)e);
            }
        }, 0L, 60000L, TimeUnit.MILLISECONDS);
    }

    private void updateAuditRouteCache(String auditServiceUrl, int timeoutMs, Map<String, String> requestParams) {
        ServiceResponse response;
        String jsonResponse = null;
        try {
            jsonResponse = HttpUtils.httpGet((String)auditServiceUrl, requestParams, (int)timeoutMs);
        }
        catch (Exception e) {
            LOGGER.error("Http request error when updating audit routes. URL: {}, params: {}", new Object[]{auditServiceUrl, requestParams, e});
            return;
        }
        if (jsonResponse == null || jsonResponse.isEmpty()) {
            LOGGER.error("Empty HTTP response when updating audit routes. URL: {}, params: {}", (Object)auditServiceUrl, requestParams);
            return;
        }
        try {
            response = (ServiceResponse)this.gson.fromJson(jsonResponse, ServiceResponse.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Parse JSON error when updating audit routes. Response: {}", (Object)jsonResponse, (Object)e);
            return;
        }
        if (response == null || !response.isSuccess()) {
            LOGGER.error("AuditRoute update failed. Response success=false. URL: {}, response: {}", (Object)auditServiceUrl, (Object)jsonResponse);
            return;
        }
        if (response.getData() == null || response.getData().isEmpty()) {
            LOGGER.warn("AuditRoute update result is empty. URL: {}, response: {}", (Object)auditServiceUrl, (Object)jsonResponse);
            return;
        }
        this.auditRoutes = new CopyOnWriteArrayList(response.getData());
        LOGGER.info("AuditRoute updated successfully. Cache size={}, Response size={}", (Object)this.auditRoutes.size(), (Object)response.getData().size());
    }

    public void shutdown() {
        try {
            this.timerExecutor.shutdown();
            if (!this.timerExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.timerExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static AuditRouteManager getInstance() {
        return instance;
    }

    public List<AuditRoute> getAuditRoutes() {
        return this.auditRoutes;
    }
}

