/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.plugin.task.AbstractTask;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerTask.class);
    private boolean isAdded = false;
    private String dbName;
    private String schemaName;
    private String tableName;
    private String instanceId;
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHH");

    @Override
    protected int getInstanceLimit() {
        return 1;
    }

    @Override
    protected void initTask() {
        LOGGER.info("SQLServer commonInit: {}", (Object)this.taskProfile.toJsonStr());
        this.dbName = this.taskProfile.get("task.sqlserverTask.dbname");
        this.tableName = this.taskProfile.get("task.sqlserverTask.tableName");
        this.schemaName = this.taskProfile.get("task.sqlserverTask.schemaName");
        this.instanceId = this.dbName + "-" + this.tableName;
    }

    public boolean isProfileValid(TaskProfile profile) {
        if (!profile.allRequiredKeyExist()) {
            LOGGER.error("task profile needs all required key");
            return false;
        }
        if (!profile.hasKey("task.sqlserverTask.hostname")) {
            LOGGER.error("task profile needs hostname");
            return false;
        }
        if (!profile.hasKey("task.sqlserverTask.port")) {
            LOGGER.error("task profile needs port");
            return false;
        }
        if (!profile.hasKey("task.sqlserverTask.user")) {
            LOGGER.error("task profile needs username");
            return false;
        }
        if (!profile.hasKey("task.sqlserverTask.password")) {
            LOGGER.error("task profile needs password");
            return false;
        }
        if (!profile.hasKey("task.sqlserverTask.dbname")) {
            LOGGER.error("task profile needs DB name");
            return false;
        }
        if (!profile.hasKey("task.sqlserverTask.schemaName")) {
            LOGGER.error("task profile needs schema name");
            return false;
        }
        if (!profile.hasKey("task.sqlserverTask.tableName")) {
            LOGGER.error("task profile needs table name");
            return false;
        }
        return true;
    }

    @Override
    protected List<InstanceProfile> getNewInstanceList() {
        ArrayList<InstanceProfile> list = new ArrayList<InstanceProfile>();
        if (this.isAdded) {
            return list;
        }
        String dataTime = LocalDateTime.now().format(this.dateTimeFormatter);
        InstanceProfile instanceProfile = this.taskProfile.createInstanceProfile(this.instanceId, "H", dataTime, AgentUtils.getCurrentTime());
        list.add(instanceProfile);
        this.isAdded = true;
        return list;
    }
}

