/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.plugin.task.AbstractTask;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleTask.class);
    private AtomicBoolean isAdded = new AtomicBoolean(false);
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHH");
    private String dbName;
    private String tableName;
    private String instanceId;

    @Override
    protected int getInstanceLimit() {
        return 1;
    }

    public boolean isProfileValid(TaskProfile profile) {
        if (!profile.allRequiredKeyExist()) {
            LOGGER.error("task profile needs all required key");
            return false;
        }
        if (!profile.hasKey("task.oracleTask.hostname")) {
            LOGGER.error("task profile needs hostname");
            return false;
        }
        if (!profile.hasKey("task.oracleTask.port")) {
            LOGGER.error("task profile needs port");
            return false;
        }
        if (!profile.hasKey("task.oracleTask.user")) {
            LOGGER.error("task profile needs username");
            return false;
        }
        if (!profile.hasKey("task.oracleTask.password")) {
            LOGGER.error("task profile needs password");
            return false;
        }
        if (!profile.hasKey("task.oracleTask.dbname")) {
            LOGGER.error("task profile needs DB name");
            return false;
        }
        if (!profile.hasKey("task.oracleTask.schemaIncludeList")) {
            LOGGER.error("task profile needs schema name");
            return false;
        }
        if (!profile.hasKey("task.oracleTask.tableIncludeList")) {
            LOGGER.error("task profile needs table list");
            return false;
        }
        return true;
    }

    @Override
    protected void initTask() {
        LOGGER.info("oracle commonInit: {}", (Object)this.taskProfile.toJsonStr());
        this.dbName = this.taskProfile.get("task.oracleTask.dbname");
        this.tableName = this.taskProfile.get("task.oracleTask.tableIncludeList");
        this.instanceId = this.dbName + "-" + this.tableName;
    }

    @Override
    protected List<InstanceProfile> getNewInstanceList() {
        ArrayList<InstanceProfile> list = new ArrayList<InstanceProfile>();
        if (this.isAdded.get()) {
            return list;
        }
        String dataTime = LocalDateTime.now().format(this.dateTimeFormatter);
        InstanceProfile instanceProfile = this.taskProfile.createInstanceProfile(this.instanceId, "H", dataTime, AgentUtils.getCurrentTime());
        LOGGER.info("taskProfile.createInstanceProfile: {}", (Object)instanceProfile.toJsonStr());
        list.add(instanceProfile);
        this.isAdded.set(true);
        return list;
    }
}

