/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.installer;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.inlong.agent.conf.AbstractConfiguration;
import org.apache.inlong.agent.installer.Manager;
import org.apache.inlong.agent.installer.conf.InstallerConfiguration;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.common.metric.MetricObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    private static void help(Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("inlong-agent", opts);
        System.exit(0);
    }

    public static CommandLine initOptions(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("h", "help", false, "show help");
        try {
            return parser.parse(options, args);
        }
        catch (Exception ex) {
            Main.help(options);
            return null;
        }
    }

    public static void initAgentConf(CommandLine cl) {
        InstallerConfiguration conf = InstallerConfiguration.getInstallerConf();
        Iterator iterator = cl.iterator();
        while (iterator != null && iterator.hasNext()) {
            Option opt = (Option)iterator.next();
            if (opt == null || opt.getLongOpt() == null || opt.getValue() == null || !conf.hasKey(opt.getLongOpt())) continue;
            conf.set(opt.getLongOpt(), opt.getValue().trim());
        }
    }

    private static void stopInstallerIfKilled(Manager manager) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                LOGGER.info("stopping installer gracefully");
                manager.stop();
                AuditUtils.send();
            }
            catch (Exception ex) {
                LOGGER.error("stop installer manager error: ", (Throwable)ex);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Thread.currentThread().setName("main-thread");
        CommandLine cl = Main.initOptions(args);
        assert (cl != null);
        Main.initAgentConf(cl);
        AuditUtils.initAudit((AbstractConfiguration)InstallerConfiguration.getInstallerConf());
        Manager manager = new Manager();
        try {
            manager.start();
            Main.stopInstallerIfKilled(manager);
            MetricObserver.init((Map)InstallerConfiguration.getInstallerConf().getConfigProperties());
            manager.join();
        }
        catch (Exception ex) {
            LOGGER.error("installer running exception: ", (Throwable)ex);
        }
        finally {
            manager.stop();
        }
    }
}

