/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.installer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.ProfileFetcher;
import org.apache.inlong.agent.installer.Manager;
import org.apache.inlong.agent.installer.ManagerResultFormatter;
import org.apache.inlong.agent.installer.conf.InstallerConfiguration;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.HttpManager;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.pojo.agent.AgentResponseCode;
import org.apache.inlong.common.pojo.agent.installer.ConfigRequest;
import org.apache.inlong.common.pojo.agent.installer.ConfigResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerFetcher
extends AbstractDaemon
implements ProfileFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerFetcher.class);
    private static final GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Gson GSON = gsonBuilder.create();
    private final String baseManagerUrl;
    private final String staticConfigUrl;
    private final InstallerConfiguration conf;
    private final HttpManager httpManager;
    private final Manager manager;
    private String localIp;
    private String uuid;
    private String clusterTag;
    private String clusterName;

    public ManagerFetcher(Manager manager) {
        this.manager = manager;
        this.conf = InstallerConfiguration.getInstallerConf();
        this.httpManager = manager.getModuleManager().getHttpManager(this.conf);
        this.baseManagerUrl = this.httpManager.getBaseUrl();
        this.staticConfigUrl = this.buildStaticConfigUrl(this.baseManagerUrl);
        this.clusterTag = this.conf.get("agent.cluster.tag");
        this.clusterName = this.conf.get("agent.cluster.name");
    }

    private String buildStaticConfigUrl(String baseUrl) {
        return baseUrl + this.conf.get("installer.manager.config.http.path", "/installer/getConfig");
    }

    public ConfigResult getConfig() {
        LOGGER.info("getConfig start");
        String resultStr = this.httpManager.doSentPost(this.staticConfigUrl, (Object)this.getFetchRequest());
        LOGGER.info("ConfigUrl {}", (Object)this.staticConfigUrl);
        JsonObject resultData = ManagerResultFormatter.getResultData(resultStr);
        JsonElement dataElement = resultData.get("data");
        LOGGER.info("getConfig end");
        if (dataElement != null) {
            LOGGER.info("getConfig not null {}", (Object)resultData);
            return (ConfigResult)GSON.fromJson((JsonElement)dataElement.getAsJsonObject(), ConfigResult.class);
        }
        LOGGER.error("getConfig result does not contain the data field ");
        return null;
    }

    public ConfigRequest getFetchRequest() {
        ConfigRequest request = new ConfigRequest();
        request.setClusterTag(this.clusterTag);
        request.setClusterName(this.clusterName);
        request.setLocalIp(this.localIp);
        request.setMd5(this.manager.getModuleManager().getCurrentMd5());
        return request;
    }

    private Runnable configFetchThread() {
        return () -> {
            Thread.currentThread().setName("ManagerFetcher");
            while (this.isRunnable()) {
                try {
                    ConfigResult config = this.getConfig();
                    if (config == null || !config.getCode().equals((Object)AgentResponseCode.SUCCESS) || this.manager.getModuleManager().getCurrentVersion() >= config.getVersion()) continue;
                    this.manager.getModuleManager().submitConfig(config);
                }
                catch (Throwable ex) {
                    LOGGER.warn("exception caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
                finally {
                    AgentUtils.silenceSleepInSeconds((long)this.conf.getInt("agent.fetcher.interval", 60));
                }
            }
        };
    }

    public void start() throws Exception {
        this.localIp = this.conf.get("agent.local.ip");
        this.uuid = AgentUtils.fetchLocalUuid();
        this.submitWorker(this.configFetchThread());
    }

    public void stop() {
        this.waitForTerminate();
    }
}

