/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.installer;

import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.ProfileFetcher;
import org.apache.inlong.agent.installer.ManagerFetcher;
import org.apache.inlong.agent.installer.ModuleManager;
import org.apache.inlong.agent.installer.conf.InstallerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(Manager.class);
    private final ModuleManager moduleManager;
    private final ProfileFetcher fetcher;
    private final InstallerConfiguration conf = InstallerConfiguration.getInstallerConf();

    public Manager() {
        this.moduleManager = new ModuleManager();
        this.fetcher = this.initFetcher(this);
    }

    private ProfileFetcher initFetcher(Manager manager) {
        try {
            return new ManagerFetcher(manager);
        }
        catch (Exception ex) {
            LOGGER.warn("cannot find fetcher: ", (Throwable)ex);
            return null;
        }
    }

    public ProfileFetcher getFetcher() {
        return this.fetcher;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public void join() {
        super.join();
        this.moduleManager.join();
    }

    public void start() throws Exception {
        LOGGER.info("Start installer manager");
        this.moduleManager.start();
        LOGGER.info("Start installer manager end");
        LOGGER.info("Start fetcher");
        if (this.fetcher != null) {
            this.fetcher.start();
        }
        LOGGER.info("Start fetcher end");
    }

    public void stop() throws Exception {
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
        LOGGER.info("Stopping installer manager");
        this.moduleManager.stop();
    }
}

