/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.pojo;

import com.google.gson.Gson;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.pojo.BinlogTask;
import org.apache.inlong.agent.pojo.COSTask;
import org.apache.inlong.agent.pojo.FileTask;
import org.apache.inlong.agent.pojo.KafkaTask;
import org.apache.inlong.agent.pojo.MongoTask;
import org.apache.inlong.agent.pojo.MqttTask;
import org.apache.inlong.agent.pojo.OracleTask;
import org.apache.inlong.agent.pojo.PostgreSQLTask;
import org.apache.inlong.agent.pojo.PulsarTask;
import org.apache.inlong.agent.pojo.RedisTask;
import org.apache.inlong.agent.pojo.SQLTask;
import org.apache.inlong.agent.pojo.SqlServerTask;
import org.apache.inlong.common.enums.DataReportTypeEnum;
import org.apache.inlong.common.enums.TaskTypeEnum;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskProfileDto {
    private static final Logger logger = LoggerFactory.getLogger(TaskProfileDto.class);
    public static final String DEFAULT_CHANNEL = "org.apache.inlong.agent.plugin.channel.MemoryChannel";
    public static final String MANAGER_JOB = "MANAGER_JOB";
    public static final String DEFAULT_DATA_PROXY_SINK = "org.apache.inlong.agent.plugin.sinks.ProxySink";
    public static final String PULSAR_SINK = "org.apache.inlong.agent.plugin.sinks.PulsarSink";
    public static final String KAFKA_SINK = "org.apache.inlong.agent.plugin.sinks.KafkaSink";
    private static final Gson GSON = new Gson();
    public static final String deafult_time_offset = "0";
    private static final String DEFAULT_AUDIT_VERSION = "0";
    private Task task;
    private Proxy proxy;

    private static BinlogTask getBinlogTask(DataConfig dataConfigs) {
        BinlogTask.BinlogTaskConfig binlogTaskConfig = (BinlogTask.BinlogTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), BinlogTask.BinlogTaskConfig.class);
        BinlogTask binlogTask = new BinlogTask();
        binlogTask.setHostname(binlogTaskConfig.getHostname());
        binlogTask.setPassword(binlogTaskConfig.getPassword());
        binlogTask.setUser(binlogTaskConfig.getUser());
        binlogTask.setTableWhiteList(binlogTaskConfig.getTableWhiteList());
        binlogTask.setDatabaseWhiteList(binlogTaskConfig.getDatabaseWhiteList());
        binlogTask.setSchema(binlogTaskConfig.getIncludeSchema());
        binlogTask.setPort(binlogTaskConfig.getPort());
        binlogTask.setOffsets(dataConfigs.getSnapshot());
        binlogTask.setDdl(binlogTaskConfig.getMonitoredDdl());
        binlogTask.setServerTimezone(binlogTaskConfig.getServerTimezone());
        BinlogTask.Offset offset = new BinlogTask.Offset();
        offset.setIntervalMs(binlogTaskConfig.getIntervalMs());
        offset.setFilename(binlogTaskConfig.getOffsetFilename());
        offset.setSpecificOffsetFile(binlogTaskConfig.getSpecificOffsetFile());
        offset.setSpecificOffsetPos(binlogTaskConfig.getSpecificOffsetPos());
        binlogTask.setOffset(offset);
        BinlogTask.Snapshot snapshot = new BinlogTask.Snapshot();
        snapshot.setMode(binlogTaskConfig.getSnapshotMode());
        binlogTask.setSnapshot(snapshot);
        BinlogTask.History history = new BinlogTask.History();
        history.setFilename(binlogTaskConfig.getHistoryFilename());
        binlogTask.setHistory(history);
        return binlogTask;
    }

    private static FileTask getFileTask(DataConfig dataConfig) {
        FileTask fileTask = new FileTask();
        fileTask.setId(dataConfig.getTaskId());
        FileTask.FileTaskConfig taskConfig = (FileTask.FileTaskConfig)GSON.fromJson(dataConfig.getExtParams(), FileTask.FileTaskConfig.class);
        FileTask.Dir dir = new FileTask.Dir();
        dir.setPatterns(taskConfig.getPattern().trim());
        dir.setBlackList(taskConfig.getBlackList());
        fileTask.setDir(dir);
        fileTask.setCollectType(taskConfig.getCollectType());
        fileTask.setContentCollectType(taskConfig.getContentCollectType());
        fileTask.setDataContentStyle(taskConfig.getDataContentStyle());
        fileTask.setDataSeparator(taskConfig.getDataSeparator());
        fileTask.setMaxFileCount(taskConfig.getMaxFileCount());
        fileTask.setRetry(taskConfig.getRetry());
        fileTask.setCycleUnit(taskConfig.getCycleUnit());
        fileTask.setDataTimeFrom(taskConfig.getDataTimeFrom());
        fileTask.setDataTimeTo(taskConfig.getDataTimeTo());
        if (taskConfig.getFilterStreams() != null) {
            fileTask.setFilterStreams(GSON.toJson(taskConfig.getFilterStreams()));
        }
        if (taskConfig.getTimeOffset() != null) {
            fileTask.setTimeOffset(taskConfig.getTimeOffset());
        } else {
            fileTask.setTimeOffset("0" + fileTask.getCycleUnit());
        }
        if (taskConfig.getAdditionalAttr() != null) {
            fileTask.setAddictiveString(taskConfig.getAdditionalAttr());
        }
        if (null != taskConfig.getLineEndPattern()) {
            FileTask.Line line = new FileTask.Line();
            line.setEndPattern(taskConfig.getLineEndPattern());
            fileTask.setLine(line);
        }
        if (null != taskConfig.getMonitorInterval()) {
            fileTask.setMonitorInterval(taskConfig.getMonitorInterval());
        }
        if (null != taskConfig.getMonitorStatus()) {
            fileTask.setMonitorStatus(taskConfig.getMonitorStatus());
        }
        return fileTask;
    }

    private static COSTask getCOSTask(DataConfig dataConfig) {
        COSTask cosTask = new COSTask();
        cosTask.setId(dataConfig.getTaskId());
        COSTask.COSTaskConfig taskConfig = (COSTask.COSTaskConfig)GSON.fromJson(dataConfig.getExtParams(), COSTask.COSTaskConfig.class);
        cosTask.setPattern(taskConfig.getPattern().trim());
        cosTask.setCollectType(taskConfig.getCollectType());
        cosTask.setContentStyle(taskConfig.getContentStyle());
        cosTask.setDataSeparator(taskConfig.getDataSeparator());
        cosTask.setMaxFileCount(taskConfig.getMaxFileCount());
        cosTask.setRetry(taskConfig.getRetry());
        cosTask.setCycleUnit(taskConfig.getCycleUnit());
        cosTask.setDataTimeFrom(taskConfig.getDataTimeFrom());
        cosTask.setDataTimeTo(taskConfig.getDataTimeTo());
        cosTask.setBucketName(taskConfig.getBucketName());
        cosTask.setSecretId(taskConfig.getCredentialsId());
        cosTask.setSecretKey(taskConfig.getCredentialsKey());
        cosTask.setRegion(taskConfig.getRegion());
        if (taskConfig.getFilterStreams() != null) {
            cosTask.setFilterStreams(GSON.toJson(taskConfig.getFilterStreams()));
        }
        if (taskConfig.getTimeOffset() != null) {
            cosTask.setTimeOffset(taskConfig.getTimeOffset());
        } else {
            cosTask.setTimeOffset("0" + cosTask.getCycleUnit());
        }
        return cosTask;
    }

    private static SQLTask getSQLTask(DataConfig dataConfig) {
        SQLTask sqlTask = new SQLTask();
        sqlTask.setId(dataConfig.getTaskId());
        SQLTask.SQLTaskConfig taskConfig = (SQLTask.SQLTaskConfig)GSON.fromJson(dataConfig.getExtParams(), SQLTask.SQLTaskConfig.class);
        sqlTask.setSql(taskConfig.getSql());
        sqlTask.setMaxInstanceCount(taskConfig.getMaxInstanceCount());
        sqlTask.setRetry(taskConfig.getRetry());
        sqlTask.setCycleUnit(taskConfig.getCycleUnit());
        sqlTask.setDataTimeFrom(taskConfig.getDataTimeFrom());
        sqlTask.setDataTimeTo(taskConfig.getDataTimeTo());
        sqlTask.setUsername(taskConfig.getUsername());
        sqlTask.setJdbcPassword(taskConfig.getJdbcPassword());
        sqlTask.setDataSeparator(taskConfig.getDataSeparator());
        sqlTask.setFetchSize(taskConfig.getFetchSize());
        sqlTask.setJdbcUrl(taskConfig.getJdbcUrl());
        if (taskConfig.getTimeOffset() != null) {
            sqlTask.setTimeOffset(taskConfig.getTimeOffset());
        } else {
            sqlTask.setTimeOffset("0" + sqlTask.getCycleUnit());
        }
        return sqlTask;
    }

    private static KafkaTask getKafkaTask(DataConfig dataConfigs) {
        KafkaTask.KafkaTaskConfig kafkaTaskConfig = (KafkaTask.KafkaTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), KafkaTask.KafkaTaskConfig.class);
        KafkaTask kafkaTask = new KafkaTask();
        KafkaTask.Bootstrap bootstrap = new KafkaTask.Bootstrap();
        bootstrap.setServers(kafkaTaskConfig.getBootstrapServers());
        kafkaTask.setBootstrap(bootstrap);
        KafkaTask.Partition partition = new KafkaTask.Partition();
        partition.setOffset(kafkaTaskConfig.getPartitionOffsets());
        kafkaTask.setPartition(partition);
        KafkaTask.Group group = new KafkaTask.Group();
        group.setId(kafkaTaskConfig.getGroupId());
        kafkaTask.setGroup(group);
        KafkaTask.RecordSpeed recordSpeed = new KafkaTask.RecordSpeed();
        recordSpeed.setLimit(kafkaTaskConfig.getRecordSpeedLimit());
        kafkaTask.setRecordSpeed(recordSpeed);
        KafkaTask.ByteSpeed byteSpeed = new KafkaTask.ByteSpeed();
        byteSpeed.setLimit(kafkaTaskConfig.getByteSpeedLimit());
        kafkaTask.setByteSpeed(byteSpeed);
        kafkaTask.setAutoOffsetReset(kafkaTaskConfig.getAutoOffsetReset());
        kafkaTask.setTopic(kafkaTaskConfig.getTopic());
        return kafkaTask;
    }

    private static PulsarTask getPulsarTask(DataConfig dataConfig) {
        PulsarTask.PulsarTaskConfig pulsarTaskConfig = (PulsarTask.PulsarTaskConfig)GSON.fromJson(dataConfig.getExtParams(), PulsarTask.PulsarTaskConfig.class);
        PulsarTask pulsarTask = new PulsarTask();
        pulsarTask.setTenant(pulsarTaskConfig.getPulsarTenant());
        pulsarTask.setNamespace(pulsarTaskConfig.getNamespace());
        pulsarTask.setTopic(pulsarTaskConfig.getTopic());
        pulsarTask.setSubscription(pulsarTaskConfig.getSubscription());
        pulsarTask.setSubscriptionType(pulsarTaskConfig.getSubscriptionType());
        pulsarTask.setServiceUrl(pulsarTaskConfig.getServiceUrl());
        pulsarTask.setSubscriptionPosition(pulsarTaskConfig.getScanStartupMode());
        pulsarTask.setResetTime(pulsarTaskConfig.getResetTime());
        return pulsarTask;
    }

    private static PostgreSQLTask getPostgresTask(DataConfig dataConfigs) {
        PostgreSQLTask.PostgreSQLTaskConfig config = (PostgreSQLTask.PostgreSQLTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), PostgreSQLTask.PostgreSQLTaskConfig.class);
        PostgreSQLTask postgreSQLTask = new PostgreSQLTask();
        postgreSQLTask.setUser(config.getUsername());
        postgreSQLTask.setPassword(config.getPassword());
        postgreSQLTask.setHostname(config.getHostname());
        postgreSQLTask.setPort(config.getPort());
        postgreSQLTask.setDbname(config.getDatabase());
        postgreSQLTask.setSchemaIncludeList(config.getSchema());
        postgreSQLTask.setPluginName(config.getDecodingPluginName());
        postgreSQLTask.setTableIncludeList(config.getTableNameList().stream().map(tableName -> config.getSchema() + "." + tableName).collect(Collectors.joining(",")));
        postgreSQLTask.setServerTimeZone(config.getServerTimeZone());
        postgreSQLTask.setSnapshotMode(config.getScanStartupMode());
        postgreSQLTask.setPrimaryKey(config.getPrimaryKey());
        return postgreSQLTask;
    }

    private static RedisTask getRedisTask(DataConfig dataConfig) {
        RedisTask.RedisTaskConfig config = (RedisTask.RedisTaskConfig)GSON.fromJson(dataConfig.getExtParams(), RedisTask.RedisTaskConfig.class);
        RedisTask redisTask = new RedisTask();
        redisTask.setAuthUser(config.getUsername());
        redisTask.setAuthPassword(config.getPassword());
        redisTask.setHostname(config.getHostname());
        redisTask.setPort(config.getPort());
        redisTask.setSsl(config.getSsl());
        redisTask.setReadTimeout(config.getTimeout());
        redisTask.setReplId(config.getReplId());
        redisTask.setCommand(config.getCommand());
        redisTask.setDbName(config.getDbName());
        redisTask.setKeys(config.getKeys());
        redisTask.setFieldOrMember(config.getFieldOrMember());
        redisTask.setIsSubscribe(config.getIsSubscribe());
        redisTask.setSyncFreq(config.getSyncFreq());
        redisTask.setSubscriptionOperation(config.getSubscriptionOperation());
        return redisTask;
    }

    private static MongoTask getMongoTask(DataConfig dataConfigs) {
        MongoTask.MongoTaskConfig config = (MongoTask.MongoTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), MongoTask.MongoTaskConfig.class);
        MongoTask mongoTask = new MongoTask();
        mongoTask.setHosts(config.getHosts());
        mongoTask.setUser(config.getUsername());
        mongoTask.setPassword(config.getPassword());
        mongoTask.setDatabaseIncludeList(config.getDatabase());
        mongoTask.setCollectionIncludeList(config.getCollection());
        mongoTask.setSnapshotMode(config.getSnapshotMode());
        MongoTask.Offset offset = new MongoTask.Offset();
        offset.setFilename(config.getOffsetFilename());
        offset.setSpecificOffsetFile(config.getSpecificOffsetFile());
        offset.setSpecificOffsetPos(config.getSpecificOffsetPos());
        mongoTask.setOffset(offset);
        MongoTask.Snapshot snapshot = new MongoTask.Snapshot();
        snapshot.setMode(config.getSnapshotMode());
        mongoTask.setSnapshot(snapshot);
        MongoTask.History history = new MongoTask.History();
        history.setFilename(config.getHistoryFilename());
        mongoTask.setHistory(history);
        return mongoTask;
    }

    private static OracleTask getOracleTask(DataConfig dataConfigs) {
        OracleTask.OracleTaskConfig config = (OracleTask.OracleTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), OracleTask.OracleTaskConfig.class);
        OracleTask oracleTask = new OracleTask();
        oracleTask.setHostname(config.getHostname());
        oracleTask.setPort(config.getPort());
        oracleTask.setUser(config.getUsername());
        oracleTask.setPassword(config.getPassword());
        oracleTask.setSchemaIncludeList(config.getSchemaName());
        oracleTask.setDbname(config.getDatabase());
        oracleTask.setTableIncludeList(config.getTableName());
        OracleTask.Offset offset = new OracleTask.Offset();
        offset.setFilename(config.getOffsetFilename());
        offset.setSpecificOffsetFile(config.getSpecificOffsetFile());
        offset.setSpecificOffsetPos(config.getSpecificOffsetPos());
        oracleTask.setOffset(offset);
        OracleTask.Snapshot snapshot = new OracleTask.Snapshot();
        snapshot.setMode(config.getScanStartupMode());
        oracleTask.setSnapshot(snapshot);
        OracleTask.History history = new OracleTask.History();
        history.setFilename(config.getHistoryFilename());
        oracleTask.setHistory(history);
        return oracleTask;
    }

    private static SqlServerTask getSqlServerTask(DataConfig dataConfigs) {
        SqlServerTask.SqlserverTaskConfig config = (SqlServerTask.SqlserverTaskConfig)GSON.fromJson(dataConfigs.getExtParams(), SqlServerTask.SqlserverTaskConfig.class);
        SqlServerTask sqlServerTask = new SqlServerTask();
        sqlServerTask.setUser(config.getUsername());
        sqlServerTask.setHostname(config.getHostname());
        sqlServerTask.setPassword(config.getPassword());
        sqlServerTask.setPort(config.getPort());
        sqlServerTask.setServerName(config.getSchemaName());
        sqlServerTask.setDbname(config.getDatabase());
        sqlServerTask.setSchemaName(config.getSchemaName());
        sqlServerTask.setTableName(config.getSchemaName() + "." + config.getTableName());
        sqlServerTask.setServerTimezone(config.getServerTimezone());
        sqlServerTask.setUnixTimestampFormatEnable(config.getUnixTimestampFormatEnable());
        SqlServerTask.Offset offset = new SqlServerTask.Offset();
        offset.setFilename(config.getOffsetFilename());
        offset.setSpecificOffsetFile(config.getSpecificOffsetFile());
        offset.setSpecificOffsetPos(config.getSpecificOffsetPos());
        sqlServerTask.setOffset(offset);
        SqlServerTask.Snapshot snapshot = new SqlServerTask.Snapshot();
        snapshot.setMode(config.getSnapshotMode());
        sqlServerTask.setSnapshot(snapshot);
        SqlServerTask.History history = new SqlServerTask.History();
        history.setFilename(config.getHistoryFilename());
        sqlServerTask.setHistory(history);
        return sqlServerTask;
    }

    public static MqttTask getMqttTask(DataConfig dataConfigs) {
        MqttTask.MqttConfig config = (MqttTask.MqttConfig)GSON.fromJson(dataConfigs.getExtParams(), MqttTask.MqttConfig.class);
        MqttTask mqttTask = new MqttTask();
        mqttTask.setServerURI(config.getServerURI());
        mqttTask.setUserName(config.getUsername());
        mqttTask.setPassword(config.getPassword());
        mqttTask.setTopic(config.getTopic());
        mqttTask.setConnectionTimeOut(config.getConnectionTimeOut());
        mqttTask.setKeepAliveInterval(config.getKeepAliveInterval());
        mqttTask.setQos(config.getQos());
        mqttTask.setCleanSession(config.getCleanSession());
        mqttTask.setClientIdPrefix(config.getClientId());
        mqttTask.setQueueSize(config.getQueueSize());
        mqttTask.setAutomaticReconnect(config.getAutomaticReconnect());
        mqttTask.setMqttVersion(config.getMqttVersion());
        return mqttTask;
    }

    private static Proxy getProxy(DataConfig dataConfigs) {
        Proxy proxy = new Proxy();
        Manager manager = new Manager();
        AgentConfiguration agentConf = AgentConfiguration.getAgentConf();
        manager.setAddr(agentConf.get("agent.manager.addr"));
        proxy.setInlongGroupId(dataConfigs.getInlongGroupId());
        proxy.setInlongStreamId(dataConfigs.getInlongStreamId());
        proxy.setManager(manager);
        if (null != dataConfigs.getSyncSend()) {
            proxy.setSync(dataConfigs.getSyncSend() == 1);
        }
        if (null != dataConfigs.getSyncPartitionKey()) {
            proxy.setPartitionKey(dataConfigs.getSyncPartitionKey());
        }
        return proxy;
    }

    public static TaskProfile convertToTaskProfile(DataConfig dataConfig) {
        if (!dataConfig.isValid()) {
            throw new IllegalArgumentException("input dataConfig" + dataConfig + "is invalid please check");
        }
        TaskProfileDto profileDto = new TaskProfileDto();
        Proxy proxy = TaskProfileDto.getProxy(dataConfig);
        profileDto.setProxy(proxy);
        Task task = new Task();
        task.setId(String.valueOf(dataConfig.getTaskId()));
        task.setTaskType(dataConfig.getTaskType());
        task.setGroupId(dataConfig.getInlongGroupId());
        task.setStreamId(dataConfig.getInlongStreamId());
        task.setChannel(DEFAULT_CHANNEL);
        task.setIp(dataConfig.getIp());
        task.setOp(dataConfig.getOp());
        task.setDeliveryTime(dataConfig.getDeliveryTime());
        task.setUuid(dataConfig.getUuid());
        task.setVersion(dataConfig.getVersion());
        task.setState(dataConfig.getState());
        task.setPredefinedFields(dataConfig.getPredefinedFields());
        task.setCycleUnit("R");
        task.setTimeZone(dataConfig.getTimeZone());
        if (dataConfig.getAuditVersion() == null) {
            task.setAuditVersion("0");
        } else {
            task.setAuditVersion(dataConfig.getAuditVersion());
        }
        if (dataConfig.getDataReportType().intValue() == DataReportTypeEnum.NORMAL_SEND_TO_DATAPROXY.ordinal()) {
            task.setSink(DEFAULT_DATA_PROXY_SINK);
            task.setProxySend(false);
        } else if (dataConfig.getDataReportType() == 1) {
            task.setSink(DEFAULT_DATA_PROXY_SINK);
            task.setProxySend(true);
        } else {
            String mqType = ((MQClusterInfo)dataConfig.getMqClusters().get(0)).getMqType();
            task.setMqClusters(GSON.toJson((Object)dataConfig.getMqClusters()));
            task.setTopicInfo(GSON.toJson((Object)dataConfig.getTopicInfo()));
            if (mqType.equals("PULSAR")) {
                task.setSink(PULSAR_SINK);
            } else if (mqType.equals("KAFKA")) {
                task.setSink(KAFKA_SINK);
            } else {
                throw new IllegalArgumentException("invalid mq type " + mqType + " please check");
            }
        }
        task.setRetry(false);
        TaskTypeEnum taskType = TaskTypeEnum.getTaskType((int)dataConfig.getTaskType());
        switch (Objects.requireNonNull(taskType)) {
            case SQL: {
                SQLTask sqlTask = TaskProfileDto.getSQLTask(dataConfig);
                task.setCycleUnit(sqlTask.getCycleUnit());
                task.setSqlTask(sqlTask);
                task.setRetry(sqlTask.getRetry());
                profileDto.setTask(task);
                break;
            }
            case BINLOG: {
                BinlogTask binlogTask = TaskProfileDto.getBinlogTask(dataConfig);
                task.setBinlogTask(binlogTask);
                profileDto.setTask(task);
                break;
            }
            case FILE: {
                FileTask fileTask = TaskProfileDto.getFileTask(dataConfig);
                task.setCycleUnit(fileTask.getCycleUnit());
                task.setFileTask(fileTask);
                task.setRetry(fileTask.getRetry());
                profileDto.setTask(task);
                break;
            }
            case KAFKA: {
                KafkaTask kafkaTask = TaskProfileDto.getKafkaTask(dataConfig);
                task.setKafkaTask(kafkaTask);
                profileDto.setTask(task);
                break;
            }
            case PULSAR: {
                PulsarTask pulsarTask = TaskProfileDto.getPulsarTask(dataConfig);
                task.setPulsarTask(pulsarTask);
                profileDto.setTask(task);
                break;
            }
            case POSTGRES: {
                PostgreSQLTask postgreSQLTask = TaskProfileDto.getPostgresTask(dataConfig);
                task.setPostgreSQLTask(postgreSQLTask);
                profileDto.setTask(task);
                break;
            }
            case ORACLE: {
                OracleTask oracleTask = TaskProfileDto.getOracleTask(dataConfig);
                task.setOracleTask(oracleTask);
                profileDto.setTask(task);
                break;
            }
            case SQLSERVER: {
                SqlServerTask sqlserverTask = TaskProfileDto.getSqlServerTask(dataConfig);
                task.setSqlserverTask(sqlserverTask);
                profileDto.setTask(task);
                break;
            }
            case MONGODB: {
                MongoTask mongoTask = TaskProfileDto.getMongoTask(dataConfig);
                task.setMongoTask(mongoTask);
                profileDto.setTask(task);
                break;
            }
            case REDIS: {
                RedisTask redisTask = TaskProfileDto.getRedisTask(dataConfig);
                task.setRedisTask(redisTask);
                profileDto.setTask(task);
                break;
            }
            case MQTT: {
                MqttTask mqttTask = TaskProfileDto.getMqttTask(dataConfig);
                task.setMqttTask(mqttTask);
                profileDto.setTask(task);
                break;
            }
            case MOCK: {
                profileDto.setTask(task);
                break;
            }
            case COS: {
                COSTask cosTask = TaskProfileDto.getCOSTask(dataConfig);
                task.setCycleUnit(cosTask.getCycleUnit());
                task.setCosTask(cosTask);
                task.setRetry(cosTask.getRetry());
                profileDto.setTask(task);
                break;
            }
            default: {
                logger.error("invalid task type {}", (Object)taskType);
            }
        }
        return TaskProfile.parseJsonStr(GSON.toJson((Object)profileDto));
    }

    public Task getTask() {
        return this.task;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskProfileDto)) {
            return false;
        }
        TaskProfileDto other = (TaskProfileDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        return !(this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskProfileDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        return result;
    }

    public String toString() {
        return "TaskProfileDto(task=" + this.getTask() + ", proxy=" + this.getProxy() + ")";
    }

    public static class Proxy {
        private String inlongGroupId;
        private String inlongStreamId;
        private Manager manager;
        private Boolean sync;
        private String partitionKey;

        public String getInlongGroupId() {
            return this.inlongGroupId;
        }

        public String getInlongStreamId() {
            return this.inlongStreamId;
        }

        public Manager getManager() {
            return this.manager;
        }

        public Boolean getSync() {
            return this.sync;
        }

        public String getPartitionKey() {
            return this.partitionKey;
        }

        public void setInlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
        }

        public void setInlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
        }

        public void setManager(Manager manager) {
            this.manager = manager;
        }

        public void setSync(Boolean sync) {
            this.sync = sync;
        }

        public void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Proxy)) {
                return false;
            }
            Proxy other = (Proxy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$sync = this.getSync();
            Boolean other$sync = other.getSync();
            if (this$sync == null ? other$sync != null : !((Object)this$sync).equals(other$sync)) {
                return false;
            }
            String this$inlongGroupId = this.getInlongGroupId();
            String other$inlongGroupId = other.getInlongGroupId();
            if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
                return false;
            }
            String this$inlongStreamId = this.getInlongStreamId();
            String other$inlongStreamId = other.getInlongStreamId();
            if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
                return false;
            }
            Manager this$manager = this.getManager();
            Manager other$manager = other.getManager();
            if (this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager)) {
                return false;
            }
            String this$partitionKey = this.getPartitionKey();
            String other$partitionKey = other.getPartitionKey();
            return !(this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Proxy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $sync = this.getSync();
            result = result * 59 + ($sync == null ? 43 : ((Object)$sync).hashCode());
            String $inlongGroupId = this.getInlongGroupId();
            result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
            String $inlongStreamId = this.getInlongStreamId();
            result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
            Manager $manager = this.getManager();
            result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
            String $partitionKey = this.getPartitionKey();
            result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
            return result;
        }

        public String toString() {
            return "TaskProfileDto.Proxy(inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", manager=" + this.getManager() + ", sync=" + this.getSync() + ", partitionKey=" + this.getPartitionKey() + ")";
        }
    }

    public static class Manager {
        private String addr;

        public String getAddr() {
            return this.addr;
        }

        public void setAddr(String addr) {
            this.addr = addr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Manager)) {
                return false;
            }
            Manager other = (Manager)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$addr = this.getAddr();
            String other$addr = other.getAddr();
            return !(this$addr == null ? other$addr != null : !this$addr.equals(other$addr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Manager;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $addr = this.getAddr();
            result = result * 59 + ($addr == null ? 43 : $addr.hashCode());
            return result;
        }

        public String toString() {
            return "TaskProfileDto.Manager(addr=" + this.getAddr() + ")";
        }
    }

    public static class Task {
        private String id;
        private String groupId;
        private String streamId;
        private String ip;
        private String source;
        private String sink;
        private String channel;
        private String name;
        private String op;
        private String retryTime;
        private String deliveryTime;
        private String uuid;
        private Integer version;
        private boolean proxySend;
        private String mqClusters;
        private String topicInfo;
        private String taskClass;
        private Integer taskType;
        private String predefinedFields;
        private Integer state;
        private String cycleUnit;
        private String timeZone;
        private String auditVersion;
        private boolean retry;
        private FileTask fileTask;
        private BinlogTask binlogTask;
        private KafkaTask kafkaTask;
        private PulsarTask pulsarTask;
        private PostgreSQLTask postgreSQLTask;
        private OracleTask oracleTask;
        private MongoTask mongoTask;
        private RedisTask redisTask;
        private MqttTask mqttTask;
        private SqlServerTask sqlserverTask;
        private COSTask cosTask;
        private SQLTask sqlTask;

        public String getId() {
            return this.id;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getStreamId() {
            return this.streamId;
        }

        public String getIp() {
            return this.ip;
        }

        public String getSource() {
            return this.source;
        }

        public String getSink() {
            return this.sink;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }

        public String getOp() {
            return this.op;
        }

        public String getRetryTime() {
            return this.retryTime;
        }

        public String getDeliveryTime() {
            return this.deliveryTime;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Integer getVersion() {
            return this.version;
        }

        public boolean isProxySend() {
            return this.proxySend;
        }

        public String getMqClusters() {
            return this.mqClusters;
        }

        public String getTopicInfo() {
            return this.topicInfo;
        }

        public String getTaskClass() {
            return this.taskClass;
        }

        public Integer getTaskType() {
            return this.taskType;
        }

        public String getPredefinedFields() {
            return this.predefinedFields;
        }

        public Integer getState() {
            return this.state;
        }

        public String getCycleUnit() {
            return this.cycleUnit;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getAuditVersion() {
            return this.auditVersion;
        }

        public boolean isRetry() {
            return this.retry;
        }

        public FileTask getFileTask() {
            return this.fileTask;
        }

        public BinlogTask getBinlogTask() {
            return this.binlogTask;
        }

        public KafkaTask getKafkaTask() {
            return this.kafkaTask;
        }

        public PulsarTask getPulsarTask() {
            return this.pulsarTask;
        }

        public PostgreSQLTask getPostgreSQLTask() {
            return this.postgreSQLTask;
        }

        public OracleTask getOracleTask() {
            return this.oracleTask;
        }

        public MongoTask getMongoTask() {
            return this.mongoTask;
        }

        public RedisTask getRedisTask() {
            return this.redisTask;
        }

        public MqttTask getMqttTask() {
            return this.mqttTask;
        }

        public SqlServerTask getSqlserverTask() {
            return this.sqlserverTask;
        }

        public COSTask getCosTask() {
            return this.cosTask;
        }

        public SQLTask getSqlTask() {
            return this.sqlTask;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setSink(String sink) {
            this.sink = sink;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOp(String op) {
            this.op = op;
        }

        public void setRetryTime(String retryTime) {
            this.retryTime = retryTime;
        }

        public void setDeliveryTime(String deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public void setProxySend(boolean proxySend) {
            this.proxySend = proxySend;
        }

        public void setMqClusters(String mqClusters) {
            this.mqClusters = mqClusters;
        }

        public void setTopicInfo(String topicInfo) {
            this.topicInfo = topicInfo;
        }

        public void setTaskClass(String taskClass) {
            this.taskClass = taskClass;
        }

        public void setTaskType(Integer taskType) {
            this.taskType = taskType;
        }

        public void setPredefinedFields(String predefinedFields) {
            this.predefinedFields = predefinedFields;
        }

        public void setState(Integer state) {
            this.state = state;
        }

        public void setCycleUnit(String cycleUnit) {
            this.cycleUnit = cycleUnit;
        }

        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public void setAuditVersion(String auditVersion) {
            this.auditVersion = auditVersion;
        }

        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        public void setFileTask(FileTask fileTask) {
            this.fileTask = fileTask;
        }

        public void setBinlogTask(BinlogTask binlogTask) {
            this.binlogTask = binlogTask;
        }

        public void setKafkaTask(KafkaTask kafkaTask) {
            this.kafkaTask = kafkaTask;
        }

        public void setPulsarTask(PulsarTask pulsarTask) {
            this.pulsarTask = pulsarTask;
        }

        public void setPostgreSQLTask(PostgreSQLTask postgreSQLTask) {
            this.postgreSQLTask = postgreSQLTask;
        }

        public void setOracleTask(OracleTask oracleTask) {
            this.oracleTask = oracleTask;
        }

        public void setMongoTask(MongoTask mongoTask) {
            this.mongoTask = mongoTask;
        }

        public void setRedisTask(RedisTask redisTask) {
            this.redisTask = redisTask;
        }

        public void setMqttTask(MqttTask mqttTask) {
            this.mqttTask = mqttTask;
        }

        public void setSqlserverTask(SqlServerTask sqlserverTask) {
            this.sqlserverTask = sqlserverTask;
        }

        public void setCosTask(COSTask cosTask) {
            this.cosTask = cosTask;
        }

        public void setSqlTask(SQLTask sqlTask) {
            this.sqlTask = sqlTask;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Task)) {
                return false;
            }
            Task other = (Task)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isProxySend() != other.isProxySend()) {
                return false;
            }
            if (this.isRetry() != other.isRetry()) {
                return false;
            }
            Integer this$version = this.getVersion();
            Integer other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Integer this$taskType = this.getTaskType();
            Integer other$taskType = other.getTaskType();
            if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
                return false;
            }
            Integer this$state = this.getState();
            Integer other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$streamId = this.getStreamId();
            String other$streamId = other.getStreamId();
            if (this$streamId == null ? other$streamId != null : !this$streamId.equals(other$streamId)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$sink = this.getSink();
            String other$sink = other.getSink();
            if (this$sink == null ? other$sink != null : !this$sink.equals(other$sink)) {
                return false;
            }
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$op = this.getOp();
            String other$op = other.getOp();
            if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
                return false;
            }
            String this$retryTime = this.getRetryTime();
            String other$retryTime = other.getRetryTime();
            if (this$retryTime == null ? other$retryTime != null : !this$retryTime.equals(other$retryTime)) {
                return false;
            }
            String this$deliveryTime = this.getDeliveryTime();
            String other$deliveryTime = other.getDeliveryTime();
            if (this$deliveryTime == null ? other$deliveryTime != null : !this$deliveryTime.equals(other$deliveryTime)) {
                return false;
            }
            String this$uuid = this.getUuid();
            String other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
                return false;
            }
            String this$mqClusters = this.getMqClusters();
            String other$mqClusters = other.getMqClusters();
            if (this$mqClusters == null ? other$mqClusters != null : !this$mqClusters.equals(other$mqClusters)) {
                return false;
            }
            String this$topicInfo = this.getTopicInfo();
            String other$topicInfo = other.getTopicInfo();
            if (this$topicInfo == null ? other$topicInfo != null : !this$topicInfo.equals(other$topicInfo)) {
                return false;
            }
            String this$taskClass = this.getTaskClass();
            String other$taskClass = other.getTaskClass();
            if (this$taskClass == null ? other$taskClass != null : !this$taskClass.equals(other$taskClass)) {
                return false;
            }
            String this$predefinedFields = this.getPredefinedFields();
            String other$predefinedFields = other.getPredefinedFields();
            if (this$predefinedFields == null ? other$predefinedFields != null : !this$predefinedFields.equals(other$predefinedFields)) {
                return false;
            }
            String this$cycleUnit = this.getCycleUnit();
            String other$cycleUnit = other.getCycleUnit();
            if (this$cycleUnit == null ? other$cycleUnit != null : !this$cycleUnit.equals(other$cycleUnit)) {
                return false;
            }
            String this$timeZone = this.getTimeZone();
            String other$timeZone = other.getTimeZone();
            if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
                return false;
            }
            String this$auditVersion = this.getAuditVersion();
            String other$auditVersion = other.getAuditVersion();
            if (this$auditVersion == null ? other$auditVersion != null : !this$auditVersion.equals(other$auditVersion)) {
                return false;
            }
            FileTask this$fileTask = this.getFileTask();
            FileTask other$fileTask = other.getFileTask();
            if (this$fileTask == null ? other$fileTask != null : !((Object)this$fileTask).equals(other$fileTask)) {
                return false;
            }
            BinlogTask this$binlogTask = this.getBinlogTask();
            BinlogTask other$binlogTask = other.getBinlogTask();
            if (this$binlogTask == null ? other$binlogTask != null : !((Object)this$binlogTask).equals(other$binlogTask)) {
                return false;
            }
            KafkaTask this$kafkaTask = this.getKafkaTask();
            KafkaTask other$kafkaTask = other.getKafkaTask();
            if (this$kafkaTask == null ? other$kafkaTask != null : !((Object)this$kafkaTask).equals(other$kafkaTask)) {
                return false;
            }
            PulsarTask this$pulsarTask = this.getPulsarTask();
            PulsarTask other$pulsarTask = other.getPulsarTask();
            if (this$pulsarTask == null ? other$pulsarTask != null : !((Object)this$pulsarTask).equals(other$pulsarTask)) {
                return false;
            }
            PostgreSQLTask this$postgreSQLTask = this.getPostgreSQLTask();
            PostgreSQLTask other$postgreSQLTask = other.getPostgreSQLTask();
            if (this$postgreSQLTask == null ? other$postgreSQLTask != null : !((Object)this$postgreSQLTask).equals(other$postgreSQLTask)) {
                return false;
            }
            OracleTask this$oracleTask = this.getOracleTask();
            OracleTask other$oracleTask = other.getOracleTask();
            if (this$oracleTask == null ? other$oracleTask != null : !((Object)this$oracleTask).equals(other$oracleTask)) {
                return false;
            }
            MongoTask this$mongoTask = this.getMongoTask();
            MongoTask other$mongoTask = other.getMongoTask();
            if (this$mongoTask == null ? other$mongoTask != null : !((Object)this$mongoTask).equals(other$mongoTask)) {
                return false;
            }
            RedisTask this$redisTask = this.getRedisTask();
            RedisTask other$redisTask = other.getRedisTask();
            if (this$redisTask == null ? other$redisTask != null : !((Object)this$redisTask).equals(other$redisTask)) {
                return false;
            }
            MqttTask this$mqttTask = this.getMqttTask();
            MqttTask other$mqttTask = other.getMqttTask();
            if (this$mqttTask == null ? other$mqttTask != null : !((Object)this$mqttTask).equals(other$mqttTask)) {
                return false;
            }
            SqlServerTask this$sqlserverTask = this.getSqlserverTask();
            SqlServerTask other$sqlserverTask = other.getSqlserverTask();
            if (this$sqlserverTask == null ? other$sqlserverTask != null : !((Object)this$sqlserverTask).equals(other$sqlserverTask)) {
                return false;
            }
            COSTask this$cosTask = this.getCosTask();
            COSTask other$cosTask = other.getCosTask();
            if (this$cosTask == null ? other$cosTask != null : !((Object)this$cosTask).equals(other$cosTask)) {
                return false;
            }
            SQLTask this$sqlTask = this.getSqlTask();
            SQLTask other$sqlTask = other.getSqlTask();
            return !(this$sqlTask == null ? other$sqlTask != null : !((Object)this$sqlTask).equals(other$sqlTask));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Task;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isProxySend() ? 79 : 97);
            result = result * 59 + (this.isRetry() ? 79 : 97);
            Integer $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Integer $taskType = this.getTaskType();
            result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
            Integer $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $streamId = this.getStreamId();
            result = result * 59 + ($streamId == null ? 43 : $streamId.hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $sink = this.getSink();
            result = result * 59 + ($sink == null ? 43 : $sink.hashCode());
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $op = this.getOp();
            result = result * 59 + ($op == null ? 43 : $op.hashCode());
            String $retryTime = this.getRetryTime();
            result = result * 59 + ($retryTime == null ? 43 : $retryTime.hashCode());
            String $deliveryTime = this.getDeliveryTime();
            result = result * 59 + ($deliveryTime == null ? 43 : $deliveryTime.hashCode());
            String $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
            String $mqClusters = this.getMqClusters();
            result = result * 59 + ($mqClusters == null ? 43 : $mqClusters.hashCode());
            String $topicInfo = this.getTopicInfo();
            result = result * 59 + ($topicInfo == null ? 43 : $topicInfo.hashCode());
            String $taskClass = this.getTaskClass();
            result = result * 59 + ($taskClass == null ? 43 : $taskClass.hashCode());
            String $predefinedFields = this.getPredefinedFields();
            result = result * 59 + ($predefinedFields == null ? 43 : $predefinedFields.hashCode());
            String $cycleUnit = this.getCycleUnit();
            result = result * 59 + ($cycleUnit == null ? 43 : $cycleUnit.hashCode());
            String $timeZone = this.getTimeZone();
            result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
            String $auditVersion = this.getAuditVersion();
            result = result * 59 + ($auditVersion == null ? 43 : $auditVersion.hashCode());
            FileTask $fileTask = this.getFileTask();
            result = result * 59 + ($fileTask == null ? 43 : ((Object)$fileTask).hashCode());
            BinlogTask $binlogTask = this.getBinlogTask();
            result = result * 59 + ($binlogTask == null ? 43 : ((Object)$binlogTask).hashCode());
            KafkaTask $kafkaTask = this.getKafkaTask();
            result = result * 59 + ($kafkaTask == null ? 43 : ((Object)$kafkaTask).hashCode());
            PulsarTask $pulsarTask = this.getPulsarTask();
            result = result * 59 + ($pulsarTask == null ? 43 : ((Object)$pulsarTask).hashCode());
            PostgreSQLTask $postgreSQLTask = this.getPostgreSQLTask();
            result = result * 59 + ($postgreSQLTask == null ? 43 : ((Object)$postgreSQLTask).hashCode());
            OracleTask $oracleTask = this.getOracleTask();
            result = result * 59 + ($oracleTask == null ? 43 : ((Object)$oracleTask).hashCode());
            MongoTask $mongoTask = this.getMongoTask();
            result = result * 59 + ($mongoTask == null ? 43 : ((Object)$mongoTask).hashCode());
            RedisTask $redisTask = this.getRedisTask();
            result = result * 59 + ($redisTask == null ? 43 : ((Object)$redisTask).hashCode());
            MqttTask $mqttTask = this.getMqttTask();
            result = result * 59 + ($mqttTask == null ? 43 : ((Object)$mqttTask).hashCode());
            SqlServerTask $sqlserverTask = this.getSqlserverTask();
            result = result * 59 + ($sqlserverTask == null ? 43 : ((Object)$sqlserverTask).hashCode());
            COSTask $cosTask = this.getCosTask();
            result = result * 59 + ($cosTask == null ? 43 : ((Object)$cosTask).hashCode());
            SQLTask $sqlTask = this.getSqlTask();
            result = result * 59 + ($sqlTask == null ? 43 : ((Object)$sqlTask).hashCode());
            return result;
        }

        public String toString() {
            return "TaskProfileDto.Task(id=" + this.getId() + ", groupId=" + this.getGroupId() + ", streamId=" + this.getStreamId() + ", ip=" + this.getIp() + ", source=" + this.getSource() + ", sink=" + this.getSink() + ", channel=" + this.getChannel() + ", name=" + this.getName() + ", op=" + this.getOp() + ", retryTime=" + this.getRetryTime() + ", deliveryTime=" + this.getDeliveryTime() + ", uuid=" + this.getUuid() + ", version=" + this.getVersion() + ", proxySend=" + this.isProxySend() + ", mqClusters=" + this.getMqClusters() + ", topicInfo=" + this.getTopicInfo() + ", taskClass=" + this.getTaskClass() + ", taskType=" + this.getTaskType() + ", predefinedFields=" + this.getPredefinedFields() + ", state=" + this.getState() + ", cycleUnit=" + this.getCycleUnit() + ", timeZone=" + this.getTimeZone() + ", auditVersion=" + this.getAuditVersion() + ", retry=" + this.isRetry() + ", fileTask=" + this.getFileTask() + ", binlogTask=" + this.getBinlogTask() + ", kafkaTask=" + this.getKafkaTask() + ", pulsarTask=" + this.getPulsarTask() + ", postgreSQLTask=" + this.getPostgreSQLTask() + ", oracleTask=" + this.getOracleTask() + ", mongoTask=" + this.getMongoTask() + ", redisTask=" + this.getRedisTask() + ", mqttTask=" + this.getMqttTask() + ", sqlserverTask=" + this.getSqlserverTask() + ", cosTask=" + this.getCosTask() + ", sqlTask=" + this.getSqlTask() + ")";
        }
    }
}

