/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.conf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfiguration.class);
    private final Map<String, JsonPrimitive> configStorage = new HashMap<String, JsonPrimitive>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public AbstractConfiguration() {
        if (this.classLoader == null) {
            this.classLoader = AgentConfiguration.class.getClassLoader();
        }
    }

    public abstract boolean allRequiredKeyExist();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(String fileName, boolean isJson) {
        InputStreamReader reader = null;
        try {
            InputStream inputStream = this.classLoader.getResourceAsStream(fileName);
            if (inputStream != null) {
                reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                if (isJson) {
                    JsonObject tmpElement = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    this.updateConfig(new HashMap<Integer, String>(10), 0, (JsonElement)tmpElement);
                } else {
                    Properties properties = new Properties();
                    properties.load(reader);
                    properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.configStorage.put((String)key, new JsonPrimitive((String)value))));
                }
            }
        }
        catch (Exception ioe) {
            LOGGER.error("error init {}", (Object)fileName, (Object)ioe);
        }
        finally {
            AgentUtils.finallyClose(reader);
        }
    }

    public void loadJsonStrResource(String jsonStr) {
        JsonElement tmpElement = JsonParser.parseString((String)jsonStr);
        this.updateConfig(new HashMap<Integer, String>(10), 0, tmpElement);
    }

    void loadJsonResource(String fileName) {
        this.loadResource(fileName, true);
    }

    public void loadPropertiesResource(String fileName) {
        this.loadResource(fileName, false);
    }

    void updateConfig(HashMap<Integer, String> keyDeptPath, int dept, JsonElement tmpElement) {
        if (tmpElement instanceof JsonObject) {
            JsonObject tmpJsonObject = tmpElement.getAsJsonObject();
            for (String key : tmpJsonObject.keySet()) {
                keyDeptPath.put(dept, key);
                this.updateConfig(keyDeptPath, dept + 1, tmpJsonObject.get(key));
            }
        } else if (tmpElement instanceof JsonArray) {
            JsonArray tmpJsonArray = tmpElement.getAsJsonArray();
            String lastKey = keyDeptPath.getOrDefault(dept - 1, "");
            for (int index = 0; index < tmpJsonArray.size(); ++index) {
                keyDeptPath.put(dept - 1, lastKey + "[" + index + "]");
                this.updateConfig(keyDeptPath, dept, tmpJsonArray.get(index));
            }
        } else if (tmpElement instanceof JsonPrimitive) {
            ArrayList<String> builder = new ArrayList<String>();
            for (int index = 0; index < dept; ++index) {
                builder.add(keyDeptPath.getOrDefault(index, ""));
            }
            String keyChain = StringUtils.join(builder, (String)".");
            if (!StringUtils.isBlank((CharSequence)keyChain)) {
                this.configStorage.put(keyChain, tmpElement.getAsJsonPrimitive());
            }
        }
    }

    public int getInt(String key, int defaultValue) {
        JsonElement value = (JsonElement)this.configStorage.get(key);
        return value == null ? defaultValue : value.getAsInt();
    }

    public int getInt(String key) {
        JsonElement value = (JsonElement)this.configStorage.get(key);
        if (value == null) {
            LOGGER.error("null value for key " + key);
            throw new NullPointerException("null value for key " + key);
        }
        return value.getAsInt();
    }

    public long getLong(String key, long defaultValue) {
        JsonElement value = (JsonElement)this.configStorage.get(key);
        return value == null ? defaultValue : value.getAsLong();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        JsonElement value = (JsonElement)this.configStorage.get(key);
        return value == null ? defaultValue : value.getAsBoolean();
    }

    public float getFloat(String key, float defaultValue) {
        JsonElement value = (JsonElement)this.configStorage.get(key);
        return value == null ? defaultValue : value.getAsFloat();
    }

    public String get(String key, String defaultValue) {
        JsonElement value = (JsonElement)this.configStorage.get(key);
        return value == null ? defaultValue : value.getAsString();
    }

    public String get(String key) {
        JsonElement value = (JsonElement)this.configStorage.get(key);
        if (value == null) {
            LOGGER.error("null value for key " + key);
            throw new NullPointerException("null value for key " + key);
        }
        return value.getAsString();
    }

    public boolean hasKey(String key) {
        return this.configStorage.containsKey(key);
    }

    public void set(String key, String value) {
        if (value != null) {
            this.configStorage.put(key, new JsonPrimitive(value));
            return;
        }
        if (this.configStorage.containsKey(key)) {
            this.configStorage.remove(key);
        }
    }

    public void setInt(String key, int value) {
        this.configStorage.put(key, new JsonPrimitive((Number)value));
    }

    public void setLong(String key, long value) {
        this.configStorage.put(key, new JsonPrimitive((Number)value));
    }

    public void setBoolean(String key, boolean value) {
        this.configStorage.put(key, new JsonPrimitive(Boolean.valueOf(value)));
    }

    public Map<String, String> getConfigProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, JsonPrimitive> entry : this.configStorage.entrySet()) {
            properties.put(entry.getKey(), entry.getValue().getAsString());
        }
        return properties;
    }

    Map<String, JsonPrimitive> getConfigStorage() {
        return this.configStorage;
    }

    public URL getConfigLocation(String fileName) {
        return this.classLoader.getResource(fileName);
    }

    List<String> getStorageList() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, JsonPrimitive> entry : this.configStorage.entrySet()) {
            result.add(entry.getKey() + "=" + entry.getValue().getAsString());
        }
        return result;
    }
}

