/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataRequestImpl;

class SnapshotTxDataRequestSerializer
implements MessageSerializer<SnapshotTxDataRequest> {
    public static final SnapshotTxDataRequestSerializer INSTANCE = new SnapshotTxDataRequestSerializer();

    private SnapshotTxDataRequestSerializer() {
    }

    public boolean writeMessage(SnapshotTxDataRequest msg, MessageWriter writer) throws MessageMappingException {
        SnapshotTxDataRequestImpl message = (SnapshotTxDataRequestImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeUuid("id", message.id());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeInt("maxTransactionsInBatch", message.maxTransactionsInBatch());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

