/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public abstract class GridMergeIndex
extends BaseIndex {
    private static final int MAX_FETCH_SIZE = 100000;
    private final AtomicInteger rowsCnt = new AtomicInteger(0);
    private final ConcurrentMap<UUID, Counter> remainingRows = new ConcurrentHashMap8();
    private final AtomicBoolean lastSubmitted = new AtomicBoolean();
    private ArrayList<Row> fetched = new ArrayList();

    public GridMergeIndex(GridMergeTable tbl, String name, IndexType type, IndexColumn[] cols) {
        this.initBaseIndex((Table)tbl, 0, name, cols, type);
    }

    public boolean hasSource(UUID nodeId) {
        return this.remainingRows.containsKey(nodeId);
    }

    public long getRowCount(Session session) {
        return this.rowsCnt.get();
    }

    public long getRowCountApproximation() {
        return this.getRowCount(null);
    }

    public void addSource(UUID nodeId) {
        if (this.remainingRows.put(nodeId, new Counter()) != null) {
            throw new IllegalStateException();
        }
    }

    public void fail(UUID nodeId) {
        this.addPage0(new GridResultPage(nodeId, null, false));
    }

    public final void addPage(GridResultPage page) {
        int pageRowsCnt = page.rows().size();
        if (pageRowsCnt != 0) {
            this.addPage0(page);
        }
        Counter cnt = (Counter)this.remainingRows.get(page.source());
        int allRows = page.response().allRows();
        if (allRows != -1) {
            assert (!cnt.initialized) : "Counter is already initialized.";
            cnt.addAndGet(allRows);
            this.rowsCnt.addAndGet(allRows);
            cnt.initialized = true;
        }
        if (cnt.addAndGet(-pageRowsCnt) == 0) {
            boolean last = true;
            for (Counter c : this.remainingRows.values()) {
                if (c.get() == 0 && c.initialized) continue;
                last = false;
                break;
            }
            if (last) {
                last = this.lastSubmitted.compareAndSet(false, true);
            }
            this.addPage0(new GridResultPage(page.source(), null, last));
        }
    }

    protected abstract void addPage0(GridResultPage var1);

    protected void fetchNextPage(GridResultPage page) {
        if (((Counter)this.remainingRows.get(page.source())).get() != 0) {
            page.fetchNextPage();
        }
    }

    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (this.fetched == null) {
            throw new IgniteException("Fetched result set was too large.");
        }
        if (this.fetchedAll()) {
            return this.findAllFetched(this.fetched, first, last);
        }
        return this.findInStream(first, last);
    }

    public boolean fetchedAll() {
        return this.fetched.size() == this.rowsCnt.get();
    }

    protected abstract Cursor findInStream(@Nullable SearchRow var1, @Nullable SearchRow var2);

    protected abstract Cursor findAllFetched(List<Row> var1, @Nullable SearchRow var2, @Nullable SearchRow var3);

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void close(Session session) {
    }

    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return this.getRowCountApproximation() + 1000L;
    }

    public void remove(Session session) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session session) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException((String)"findFirstOrLast");
    }

    public boolean needRebuild() {
        return false;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    private static class Counter
    extends AtomicInteger {
        volatile boolean initialized;

        private Counter() {
        }
    }

    private class FetchedIterator
    implements Iterator<Row> {
        private int idx;

        private FetchedIterator() {
        }

        @Override
        public boolean hasNext() {
            return GridMergeIndex.this.fetched != null && this.idx < GridMergeIndex.this.fetched.size();
        }

        @Override
        public Row next() {
            return (Row)GridMergeIndex.this.fetched.get(this.idx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class FetchingCursor
    extends IteratorCursor {
        private Iterator<Row> stream;

        public FetchingCursor(Iterator<Row> stream) {
            super(new FetchedIterator());
            assert (stream != null);
            this.stream = stream;
        }

        @Override
        public boolean next() {
            if (super.next()) {
                assert (this.cur != null);
                if (this.iter == this.stream && GridMergeIndex.this.fetched != null) {
                    if (GridMergeIndex.this.fetched.size() == 100000) {
                        GridMergeIndex.this.fetched = null;
                    } else {
                        GridMergeIndex.this.fetched.add(this.cur);
                    }
                }
                return true;
            }
            if (this.iter == this.stream) {
                return false;
            }
            this.iter = this.stream;
            return this.next();
        }
    }

    protected class IteratorCursor
    implements Cursor {
        protected Iterator<Row> iter;
        protected Row cur;

        public IteratorCursor(Iterator<Row> iter) {
            assert (iter != null);
            this.iter = iter;
        }

        public Row get() {
            return this.cur;
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean next() {
            this.cur = this.iter.hasNext() ? this.iter.next() : null;
            return this.cur != null;
        }

        public boolean previous() {
            throw DbException.getUnsupportedException((String)"previous");
        }
    }
}

