/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridIoPolicy;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryRequest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.h2.jdbc.JdbcResultSet;
import org.h2.result.ResultInterface;
import org.h2.store.Data;
import org.h2.value.Value;
import org.jsr166.ConcurrentHashMap8;

public class GridMapQueryExecutor
implements GridMessageListener {
    private static final Field RESULT_FIELD;
    private IgniteLogger log;
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private ConcurrentMap<UUID, ConcurrentMap<Long, QueryResults>> qryRess = new ConcurrentHashMap8();

    public void start(GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridMapQueryExecutor.class);
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                ConcurrentMap nodeRess = (ConcurrentMap)GridMapQueryExecutor.this.qryRess.remove(nodeId);
                if (nodeRess == null) {
                    return;
                }
                for (QueryResults ress : nodeRess.values()) {
                    ress.cancel();
                }
            }
        }, 12, new int[]{11});
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, (GridMessageListener)this);
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            boolean processed = true;
            if (msg instanceof GridQueryRequest) {
                this.onQueryRequest(node, (GridQueryRequest)msg);
            } else if (msg instanceof GridQueryNextPageRequest) {
                this.onNextPageRequest(node, (GridQueryNextPageRequest)msg);
            } else if (msg instanceof GridQueryCancelRequest) {
                this.onCancel(node, (GridQueryCancelRequest)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed request: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    private void onCancel(ClusterNode node, GridQueryCancelRequest msg) {
        ConcurrentMap<Long, QueryResults> nodeRess = this.resultsForNode(node.id());
        QueryResults results = (QueryResults)nodeRess.remove(msg.queryRequestId());
        if (results == null) {
            return;
        }
        results.cancel();
    }

    private ConcurrentMap<Long, QueryResults> resultsForNode(UUID nodeId) {
        ConcurrentMap<Long, QueryResults> old;
        ConcurrentMap<Long, QueryResults> nodeRess = (ConcurrentMap<Long, QueryResults>)this.qryRess.get(nodeId);
        if (nodeRess == null && (old = this.qryRess.putIfAbsent(nodeId, nodeRess = new ConcurrentHashMap8())) != null) {
            nodeRess = old;
        }
        return nodeRess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryRequest(ClusterNode node, GridQueryRequest req) {
        Collection qrys;
        ConcurrentMap<Long, QueryResults> nodeRess = this.resultsForNode(node.id());
        try {
            qrys = req.queries(this.ctx.config().getMarshaller());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        QueryResults qr = new QueryResults(req.requestId(), qrys.size());
        if (nodeRess.put(req.requestId(), qr) != null) {
            throw new IllegalStateException();
        }
        this.h2.setFilters(this.h2.backupFilter());
        try {
            int i = 0;
            String space = req.space();
            for (GridCacheSqlQuery qry : qrys) {
                ResultSet rs = this.h2.executeSqlQueryWithTimer(space, this.h2.connectionForSpace(space), qry.query(), F.asList((Object[])qry.parameters()));
                if (this.ctx.event().isRecordable(96)) {
                    this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL, null, null, qry.query(), null, null, qry.parameters(), null, null));
                }
                assert (rs instanceof JdbcResultSet) : rs.getClass();
                qr.addResult(i, rs);
                if (qr.canceled) {
                    qr.result(i).close();
                    throw new IgniteException("Query was canceled.");
                }
                this.sendNextPage(nodeRess, node, qr, i, req.pageSize());
                ++i;
            }
        }
        catch (Throwable e) {
            nodeRess.remove(req.requestId(), qr);
            qr.cancel();
            U.error((IgniteLogger)this.log, (Object)("Failed to execute local query: " + req), (Throwable)e);
            this.sendError(node, req.requestId(), e);
        }
        finally {
            this.h2.setFilters(null);
        }
    }

    private void sendError(ClusterNode node, long qryReqId, Throwable err) {
        try {
            GridQueryFailResponse msg = new GridQueryFailResponse(qryReqId, err);
            if (node.isLocal()) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg, GridIoPolicy.PUBLIC_POOL);
            }
        }
        catch (Exception e) {
            e.addSuppressed(err);
            U.error((IgniteLogger)this.log, (Object)"Failed to send error message.", (Throwable)e);
        }
    }

    private void onNextPageRequest(ClusterNode node, GridQueryNextPageRequest req) {
        QueryResults qr;
        ConcurrentMap nodeRess = (ConcurrentMap)this.qryRess.get(node.id());
        QueryResults queryResults = qr = nodeRess == null ? null : (QueryResults)nodeRess.get(req.queryRequestId());
        if (qr == null || qr.canceled) {
            this.sendError(node, req.queryRequestId(), (Throwable)new CacheException("No query result found for request: " + req));
        } else {
            this.sendNextPage(nodeRess, node, qr, req.query(), req.pageSize());
        }
    }

    private void sendNextPage(ConcurrentMap<Long, QueryResults> nodeRess, ClusterNode node, QueryResults qr, int qry, int pageSize) {
        QueryResult res = qr.result(qry);
        assert (res != null);
        int page = res.page;
        ArrayList<Value[]> rows = new ArrayList<Value[]>(Math.min(64, pageSize));
        boolean last = res.fetchNextPage(rows, pageSize);
        if (last) {
            res.close();
            if (qr.isAllClosed()) {
                nodeRess.remove(qr.qryReqId, qr);
            }
        }
        try {
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(qr.qryReqId, qry, page, page == 0 ? res.rowCount : -1, GridMapQueryExecutor.marshallRows(rows));
            if (node.isLocal()) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg, GridIoPolicy.PUBLIC_POOL);
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to send message.", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    public static List<Value[]> unmarshallRows(byte[] bytes) {
        Data data = Data.create(null, (byte[])bytes);
        int rowCnt = data.readVarInt();
        if (rowCnt == 0) {
            return Collections.emptyList();
        }
        ArrayList<Value[]> rows = new ArrayList<Value[]>(rowCnt);
        int cols = data.readVarInt();
        for (int r = 0; r < rowCnt; ++r) {
            Value[] row = new Value[cols];
            for (int c = 0; c < cols; ++c) {
                row[c] = data.readValue();
            }
            rows.add(row);
        }
        return rows;
    }

    public static byte[] marshallRows(Collection<Value[]> rows) {
        Data data = Data.create(null, (int)256);
        data.writeVarInt(rows.size());
        boolean first = true;
        for (Value[] row : rows) {
            if (first) {
                data.writeVarInt(row.length);
                first = false;
            }
            for (Value val : row) {
                data.checkCapacity(data.getValueLen(val));
                data.writeValue(val);
            }
        }
        return Arrays.copyOf(data.getBytes(), data.length());
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }

    private class QueryResult
    implements AutoCloseable {
        private final ResultInterface res;
        private final ResultSet rs;
        private int page;
        private final int rowCount;
        private volatile boolean closed;

        private QueryResult(ResultSet rs) {
            this.rs = rs;
            try {
                this.res = (ResultInterface)RESULT_FIELD.get(rs);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            this.rowCount = this.res.getRowCount();
        }

        synchronized boolean fetchNextPage(List<Value[]> rows, int pageSize) {
            if (this.closed) {
                return true;
            }
            ++this.page;
            for (int i = 0; i < pageSize; ++i) {
                if (!this.res.next()) {
                    return true;
                }
                rows.add(this.res.currentRow());
            }
            return false;
        }

        @Override
        public synchronized void close() {
            Statement stmt;
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                stmt = this.rs.getStatement();
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
            U.close((AutoCloseable)this.rs, (IgniteLogger)GridMapQueryExecutor.this.log);
            U.close((AutoCloseable)stmt, (IgniteLogger)GridMapQueryExecutor.this.log);
        }
    }

    private class QueryResults {
        private final long qryReqId;
        private final AtomicReferenceArray<QueryResult> results;
        private volatile boolean canceled;

        private QueryResults(long qryReqId, int qrys) {
            this.qryReqId = qryReqId;
            this.results = new AtomicReferenceArray(qrys);
        }

        QueryResult result(int qry) {
            return this.results.get(qry);
        }

        void addResult(int qry, ResultSet rs) {
            if (!this.results.compareAndSet(qry, null, new QueryResult(rs))) {
                throw new IllegalStateException();
            }
        }

        boolean isAllClosed() {
            for (int i = 0; i < this.results.length(); ++i) {
                QueryResult res = this.results.get(i);
                if (res != null && res.closed) continue;
                return false;
            }
            return true;
        }

        void cancel() {
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            for (int i = 0; i < this.results.length(); ++i) {
                QueryResult res = this.results.get(i);
                if (res == null) continue;
                res.close();
            }
        }
    }
}

