/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public class GridSqlSelect
implements Cloneable {
    private boolean distinct;
    private List<GridSqlElement> allExprs;
    private List<GridSqlElement> select = new ArrayList<GridSqlElement>();
    private List<GridSqlElement> groups = new ArrayList<GridSqlElement>();
    private int[] grpCols;
    private GridSqlElement from;
    private GridSqlElement where;
    private GridSqlElement having;
    private int havingCol = -1;
    private Map<GridSqlElement, GridSqlSortColumn> sort = new LinkedHashMap<GridSqlElement, GridSqlSortColumn>();
    private GridSqlElement offset;
    private GridSqlElement limit;

    public GridSqlElement offset() {
        return this.offset;
    }

    public void offset(GridSqlElement offset) {
        this.offset = offset;
    }

    public void limit(GridSqlElement limit) {
        this.limit = limit;
    }

    public GridSqlElement limit() {
        return this.limit;
    }

    public boolean distinct() {
        return this.distinct;
    }

    public void distinct(boolean distinct) {
        this.distinct = distinct;
    }

    public String getSQL() {
        StatementBuilder buff = new StatementBuilder("SELECT");
        if (this.distinct) {
            buff.append(" DISTINCT");
        }
        for (GridSqlElement gridSqlElement : this.select) {
            buff.appendExceptFirst(",");
            buff.append('\n');
            buff.append(StringUtils.indent((String)gridSqlElement.getSQL(), (int)4, (boolean)false));
        }
        buff.append("\nFROM ").append(this.from.getSQL());
        if (this.where != null) {
            buff.append("\nWHERE ").append(StringUtils.unEnclose((String)this.where.getSQL()));
        }
        if (!this.groups.isEmpty()) {
            buff.append("\nGROUP BY ");
            buff.resetCount();
            for (GridSqlElement gridSqlElement : this.groups) {
                buff.appendExceptFirst(", ");
                if (gridSqlElement instanceof GridSqlAlias) {
                    buff.append(StringUtils.unEnclose((String)gridSqlElement.child().getSQL()));
                    continue;
                }
                buff.append(StringUtils.unEnclose((String)gridSqlElement.getSQL()));
            }
        }
        if (this.having != null) {
            buff.append("\nHAVING ").append(StringUtils.unEnclose((String)this.having.getSQL()));
        }
        if (!this.sort.isEmpty()) {
            buff.append("\nORDER BY ");
            buff.resetCount();
            for (Map.Entry entry : this.sort.entrySet()) {
                buff.appendExceptFirst(", ");
                GridSqlElement expression = (GridSqlElement)entry.getKey();
                int idx = this.select.indexOf(expression);
                if (idx >= 0) {
                    buff.append((long)(idx + 1));
                } else {
                    buff.append('=').append(StringUtils.unEnclose((String)expression.getSQL()));
                }
                GridSqlSortColumn type = (GridSqlSortColumn)entry.getValue();
                if (!type.asc()) {
                    buff.append(" DESC");
                }
                if (type.nullsFirst()) {
                    buff.append(" NULLS FIRST");
                    continue;
                }
                if (!type.nullsLast()) continue;
                buff.append(" NULLS LAST");
            }
        }
        if (this.limit != null) {
            buff.append(" LIMIT ").append(StringUtils.unEnclose((String)this.limit.getSQL()));
        }
        if (this.offset != null) {
            buff.append(" OFFSET ").append(StringUtils.unEnclose((String)this.offset.getSQL()));
        }
        return buff.toString();
    }

    public void addExpression(GridSqlElement expression) {
        if (this.allExprs == null) {
            this.allExprs = new ArrayList<GridSqlElement>();
        }
        this.allExprs.add(expression);
    }

    public List<GridSqlElement> allExpressions() {
        return this.allExprs;
    }

    public List<GridSqlElement> select() {
        return this.select;
    }

    public void clearSelect() {
        this.select = new ArrayList<GridSqlElement>();
    }

    public void addSelectExpression(GridSqlElement expression) {
        if (expression == null) {
            throw new NullPointerException();
        }
        this.select.add(expression);
    }

    public List<GridSqlElement> groups() {
        return this.groups;
    }

    public void clearGroups() {
        this.groups = new ArrayList<GridSqlElement>();
        this.grpCols = null;
    }

    public void addGroupExpression(GridSqlElement expression) {
        if (expression == null) {
            throw new NullPointerException();
        }
        this.groups.add(expression);
    }

    public int[] groupColumns() {
        return this.grpCols;
    }

    public void groupColumns(int[] grpCols) {
        this.grpCols = grpCols;
    }

    public GridSqlElement from() {
        return this.from;
    }

    public GridSqlSelect from(GridSqlElement from) {
        this.from = from;
        return this;
    }

    public GridSqlElement where() {
        return this.where;
    }

    public void where(GridSqlElement where) {
        this.where = where;
    }

    public GridSqlSelect whereAnd(GridSqlElement condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        GridSqlElement old = this.where();
        this.where(old == null ? condition : new GridSqlOperation(GridSqlOperationType.AND, old, condition));
        return this;
    }

    public GridSqlElement having() {
        return this.having;
    }

    public void having(GridSqlElement having) {
        this.having = having;
    }

    public void havingColumn(int col) {
        this.havingCol = col;
    }

    public int havingColumn() {
        return this.havingCol;
    }

    public Map<GridSqlElement, GridSqlSortColumn> sort() {
        return this.sort;
    }

    public void clearSort() {
        this.sort = new LinkedHashMap<GridSqlElement, GridSqlSortColumn>();
    }

    public void addSort(GridSqlElement expression, GridSqlSortColumn sortType) {
        this.sort.put(expression, sortType);
    }

    public GridSqlSelect clone() {
        try {
            GridSqlSelect res = (GridSqlSelect)super.clone();
            res.select = new ArrayList<GridSqlElement>(this.select);
            res.groups = new ArrayList<GridSqlElement>(this.groups);
            res.sort = new LinkedHashMap<GridSqlElement, GridSqlSortColumn>(this.sort);
            res.allExprs = null;
            return res;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

