/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;

public abstract class GridSqlElement
implements Cloneable,
Iterable<GridSqlElement> {
    protected List<GridSqlElement> children = new ArrayList<GridSqlElement>();
    private GridSqlType expressionResultType;

    public GridSqlType expressionResultType() {
        return this.expressionResultType;
    }

    public void expressionResultType(GridSqlType type) {
        this.expressionResultType = type;
    }

    public abstract String getSQL();

    public void clearChildren() {
        if (this.size() != 0) {
            this.children = new ArrayList<GridSqlElement>();
        }
    }

    public GridSqlElement addChild(GridSqlElement expr) {
        if (expr == null) {
            throw new NullPointerException();
        }
        this.children.add(expr);
        return this;
    }

    public GridSqlElement child() {
        return this.children.get(0);
    }

    public GridSqlElement child(int idx) {
        return this.children.get(idx);
    }

    public GridSqlElement clone() {
        try {
            GridSqlElement res = (GridSqlElement)super.clone();
            res.children = new ArrayList<GridSqlElement>(this.children);
            return res;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void child(int idx, GridSqlElement child) {
        this.children.set(idx, child);
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public Iterator<GridSqlElement> iterator() {
        return this.children.iterator();
    }
}

