/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.h2.util.StringUtils;

public class GridSqlAggregateFunction
extends GridSqlFunction {
    private static final GridSqlFunctionType[] TYPE_INDEX = new GridSqlFunctionType[]{GridSqlFunctionType.COUNT_ALL, GridSqlFunctionType.COUNT, GridSqlFunctionType.GROUP_CONCAT, GridSqlFunctionType.SUM, GridSqlFunctionType.MIN, GridSqlFunctionType.MAX, GridSqlFunctionType.AVG};
    private final boolean distinct;

    public GridSqlAggregateFunction(boolean distinct, GridSqlFunctionType type) {
        super(type);
        this.distinct = distinct;
    }

    public GridSqlAggregateFunction(boolean distinct, int typeId) {
        this(distinct, TYPE_INDEX[typeId]);
    }

    public boolean distinct() {
        return this.distinct;
    }

    @Override
    public String getSQL() {
        switch (this.type) {
            case GROUP_CONCAT: {
                throw new UnsupportedOperationException();
            }
            case COUNT_ALL: {
                return "COUNT(*)";
            }
        }
        String text = this.type.name();
        if (this.distinct) {
            return text + "(DISTINCT " + this.child().getSQL() + ")";
        }
        return text + StringUtils.enclose((String)this.child().getSQL());
    }
}

