/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.io.EOFException;
import java.io.IOException;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneFile;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneOutputStream;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class GridLuceneInputStream
extends IndexInput {
    private GridLuceneFile file;
    private long length;
    private long currBuf;
    private int currBufIdx;
    private int bufPosition;
    private long bufStart;
    private int bufLength;
    private final GridUnsafeMemory mem;

    public GridLuceneInputStream(String name, GridLuceneFile f) throws IOException {
        super("RAMInputStream(name=" + name + ")");
        this.file = f;
        this.length = this.file.getLength();
        if (this.length / 32768L >= Integer.MAX_VALUE) {
            throw new IOException("RAMInputStream too large length=" + this.length + ": " + name);
        }
        this.mem = this.file.getDirectory().memory();
        this.currBufIdx = -1;
        this.currBuf = 0L;
    }

    public void close() {
    }

    public long length() {
        return this.length;
    }

    public byte readByte() throws IOException {
        if (this.bufPosition >= this.bufLength) {
            ++this.currBufIdx;
            this.switchCurrentBuffer(true);
        }
        return this.mem.readByte(this.currBuf + (long)this.bufPosition++);
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuf;
            if (this.bufPosition >= this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer(true);
            }
            int bytesToCp = len < (remainInBuf = this.bufLength - this.bufPosition) ? len : remainInBuf;
            this.mem.readBytes(this.currBuf + (long)this.bufPosition, b, offset, bytesToCp);
            offset += bytesToCp;
            len -= bytesToCp;
            this.bufPosition += bytesToCp;
        }
    }

    private void switchCurrentBuffer(boolean enforceEOF) throws IOException {
        this.bufStart = 32768L * (long)this.currBufIdx;
        if (this.currBufIdx >= this.file.numBuffers()) {
            if (enforceEOF) {
                throw new EOFException("read past EOF: " + (Object)((Object)this));
            }
            --this.currBufIdx;
            this.bufPosition = 32768;
        } else {
            this.currBuf = this.file.getBuffer(this.currBufIdx);
            this.bufPosition = 0;
            long buflen = this.length - this.bufStart;
            this.bufLength = buflen > 32768L ? 32768 : (int)buflen;
        }
    }

    public void copyBytes(IndexOutput out, long numBytes) throws IOException {
        long left;
        int toCp;
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        GridLuceneOutputStream gridOut = out instanceof GridLuceneOutputStream ? (GridLuceneOutputStream)out : null;
        for (left = numBytes; left > 0L; left -= (long)toCp) {
            int bytesInBuf;
            if (this.bufPosition == this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer(true);
            }
            toCp = (int)((long)(bytesInBuf = this.bufLength - this.bufPosition) < left ? (long)bytesInBuf : left);
            if (gridOut != null) {
                gridOut.writeBytes(this.currBuf + (long)this.bufPosition, toCp);
            } else {
                byte[] buff = new byte[toCp];
                this.mem.readBytes(this.currBuf + (long)this.bufPosition, buff);
                out.writeBytes(buff, toCp);
            }
            this.bufPosition += toCp;
        }
        assert (left == 0L) : "Insufficient bytes to copy: numBytes=" + numBytes + " copied=" + (numBytes - left);
    }

    void readBytes(long ptr, int len) throws IOException {
        while (len > 0) {
            int remainInBuf;
            if (this.bufPosition >= this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer(true);
            }
            int bytesToCp = len < (remainInBuf = this.bufLength - this.bufPosition) ? len : remainInBuf;
            this.mem.copyMemory(this.currBuf + (long)this.bufPosition, ptr, (long)bytesToCp);
            ptr += (long)bytesToCp;
            len -= bytesToCp;
            this.bufPosition += bytesToCp;
        }
    }

    public long getFilePointer() {
        return this.currBufIdx < 0 ? 0L : this.bufStart + (long)this.bufPosition;
    }

    public void seek(long pos) throws IOException {
        if (this.currBuf == 0L || pos < this.bufStart || pos >= this.bufStart + 32768L) {
            this.currBufIdx = (int)(pos / 32768L);
            this.switchCurrentBuffer(false);
        }
        this.bufPosition = (int)(pos % 32768L);
    }
}

