/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Utils;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueUuid;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2AbstractKeyValueRow
extends GridH2Row {
    private static final int DEFAULT_COLUMNS_COUNT = 2;
    public static final int KEY_COL = 0;
    public static final int VAL_COL = 1;
    protected final GridH2RowDescriptor desc;
    protected long expirationTime;

    protected GridH2AbstractKeyValueRow(GridH2RowDescriptor desc, Object key, int keyType, @Nullable Object val, int valType, long expirationTime) throws IgniteSpiException {
        super(GridH2AbstractKeyValueRow.wrap(key, keyType), val == null ? null : GridH2AbstractKeyValueRow.wrap(val, valType));
        this.desc = desc;
        this.expirationTime = expirationTime;
    }

    protected GridH2AbstractKeyValueRow(GridH2RowDescriptor desc) {
        super(new Value[2]);
        this.desc = desc;
    }

    public static Value wrap(Object obj, int type) throws IgniteSpiException {
        assert (obj != null);
        switch (type) {
            case 1: {
                return ValueBoolean.get((boolean)((Boolean)obj));
            }
            case 2: {
                return ValueByte.get((byte)((Byte)obj));
            }
            case 3: {
                return ValueShort.get((short)((Short)obj));
            }
            case 4: {
                return ValueInt.get((int)((Integer)obj));
            }
            case 8: {
                return ValueFloat.get((float)((Float)obj).floatValue());
            }
            case 5: {
                return ValueLong.get((long)((Long)obj));
            }
            case 7: {
                return ValueDouble.get((double)((Double)obj));
            }
            case 20: {
                UUID uuid = (UUID)obj;
                return ValueUuid.get((long)uuid.getMostSignificantBits(), (long)uuid.getLeastSignificantBits());
            }
            case 10: {
                return ValueDate.get((Date)((Date)obj));
            }
            case 9: {
                return ValueTime.get((Time)((Time)obj));
            }
            case 11: {
                if (obj instanceof java.util.Date && !(obj instanceof Timestamp)) {
                    obj = new Timestamp(((java.util.Date)obj).getTime());
                }
                return GridH2Utils.toValueTimestamp((Timestamp)obj);
            }
            case 6: {
                return ValueDecimal.get((BigDecimal)((BigDecimal)obj));
            }
            case 13: {
                return ValueString.get((String)obj.toString());
            }
            case 12: {
                return ValueBytes.get((byte[])((byte[])obj));
            }
            case 19: {
                return ValueJavaObject.getNoCopy((Object)obj, null, null);
            }
            case 17: {
                Object[] arr = (Object[])obj;
                Value[] valArr = new Value[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    Object o = arr[i];
                    valArr[i] = o == null ? ValueNull.INSTANCE : GridH2AbstractKeyValueRow.wrap(o, DataType.getTypeFromClass(o.getClass()));
                }
                return ValueArray.get((Value[])valArr);
            }
            case 22: {
                return ValueGeometry.getFromGeometry((Object)obj);
            }
        }
        throw new IgniteSpiException("Failed to wrap value[type=" + type + ", value=" + obj + "]");
    }

    public long expirationTime() {
        return this.expirationTime;
    }

    public int getColumnCount() {
        return 2 + this.desc.fieldsCount();
    }

    public synchronized void onSwap() throws IgniteCheckedException {
        this.setValue(1, null);
    }

    public synchronized void onUnswap(Object val, boolean beforeRmv) throws IgniteCheckedException {
        this.setValue(1, GridH2AbstractKeyValueRow.wrap(val, this.desc.valueType()));
        this.notifyAll();
    }

    protected synchronized Value updateWeakValue(Value upd) {
        Value res = this.peekValue(1);
        if (res != null && !(res instanceof WeakValue)) {
            return res;
        }
        this.setValue(1, new WeakValue(upd));
        this.notifyAll();
        return null;
    }

    protected synchronized Value syncValue(int attempt) {
        Value v = this.peekValue(1);
        if (v == null && attempt != 0) {
            try {
                this.wait(attempt);
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedException(e);
            }
            v = this.peekValue(1);
        }
        return v;
    }

    protected final Value peekValue(int col) {
        return this.getValueList()[col];
    }

    public Value getValue(int col) {
        if (col < 2) {
            Value v = this.peekValue(col);
            if (col == 1) {
                long start = 0L;
                int attempt = 0;
                while ((v = WeakValue.unwrap(v)) == null) {
                    v = this.getOffheapValue(1);
                    if (v != null) {
                        this.setValue(1, v);
                        if (this.peekValue(0) == null) {
                            this.cache();
                        }
                        return v;
                    }
                    Object k = this.getValue(0).getObject();
                    try {
                        Object valObj = this.desc.readFromSwap(k);
                        if (valObj != null) {
                            Value upd = GridH2AbstractKeyValueRow.wrap(valObj, this.desc.valueType());
                            v = this.updateWeakValue(upd);
                            return v == null ? upd : v;
                        }
                        v = this.syncValue(attempt);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                    ++attempt;
                    if (start == 0L) {
                        start = U.currentTimeMillis();
                        continue;
                    }
                    if (U.currentTimeMillis() - start <= 15000L) continue;
                    throw new IgniteException("Failed to get value for key: " + k + ". This can happen due to a long GC pause.");
                }
            }
            if (v == null) {
                assert (col == 0) : col;
                v = this.getOffheapValue(0);
                assert (v != null) : v;
                this.setValue(0, v);
                if (this.peekValue(1) == null) {
                    this.cache();
                }
            }
            assert (!(v instanceof WeakValue)) : v;
            return v;
        }
        assert ((col -= 2) >= 0);
        Value key = this.getValue(0);
        Value val = this.getValue(1);
        assert (key != null);
        assert (val != null);
        Object res = this.desc.columnValue(key.getObject(), val.getObject(), col);
        if (res == null) {
            return ValueNull.INSTANCE;
        }
        try {
            return GridH2AbstractKeyValueRow.wrap(res, this.desc.fieldType(col));
        }
        catch (IgniteSpiException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    protected abstract void cache();

    protected abstract Value getOffheapValue(int var1);

    protected void addOffheapRowId(SB sb) {
    }

    public String toString() {
        SB sb = new SB("Row@");
        sb.a(Integer.toHexString(System.identityHashCode(this)));
        this.addOffheapRowId(sb);
        Value v = this.peekValue(0);
        sb.a("[ key: ").a(v == null ? "nil" : v.getString());
        v = WeakValue.unwrap(this.peekValue(1));
        sb.a(", val: ").a(v == null ? "nil" : v.getString());
        sb.a(" ][ ");
        if (v != null) {
            int cnt = this.getColumnCount();
            for (int i = 2; i < cnt; ++i) {
                v = this.getValue(i);
                if (i != 2) {
                    sb.a(", ");
                }
                sb.a(v == null ? "nil" : v.getString());
            }
        }
        sb.a(" ]");
        return sb.toString();
    }

    public void setKeyAndVersion(SearchRow old) {
        assert (false);
    }

    public void setKey(long key) {
        assert (false);
    }

    public Row getCopy() {
        assert (false);
        return null;
    }

    public void setDeleted(boolean deleted) {
        assert (false);
    }

    public long getKey() {
        assert (false);
        return 0L;
    }

    public void setSessionId(int sesId) {
        assert (false);
    }

    public void setVersion(int ver) {
        assert (false);
    }

    private static class WeakValue
    extends Value {
        private final WeakReference<Value> ref;

        static Value unwrap(Value v) {
            return v instanceof WeakValue ? ((WeakValue)v).get() : v;
        }

        private WeakValue(Value v) {
            this.ref = new WeakReference<Value>(v);
        }

        public Value get() {
            return (Value)this.ref.get();
        }

        public String getSQL() {
            throw new IllegalStateException();
        }

        public int getType() {
            throw new IllegalStateException();
        }

        public long getPrecision() {
            throw new IllegalStateException();
        }

        public int getDisplaySize() {
            throw new IllegalStateException();
        }

        public String getString() {
            throw new IllegalStateException();
        }

        public Object getObject() {
            throw new IllegalStateException();
        }

        public void set(PreparedStatement preparedStatement, int i) throws SQLException {
            throw new IllegalStateException();
        }

        protected int compareSecure(Value val, CompareMode compareMode) {
            throw new IllegalStateException();
        }

        public int hashCode() {
            throw new IllegalStateException();
        }

        public boolean equals(Object o) {
            throw new IllegalStateException();
        }
    }
}

