/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class GridH2ResultSetIterator<T>
extends GridCloseableIteratorAdapter<T> {
    private static final long serialVersionUID = 0L;
    private final ResultSet data;
    protected final Object[] row;
    private boolean hasRow;

    protected GridH2ResultSetIterator(ResultSet data) throws IgniteCheckedException {
        this.data = data;
        if (data != null) {
            try {
                this.row = new Object[data.getMetaData().getColumnCount()];
            }
            catch (SQLException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        } else {
            this.row = null;
        }
    }

    private boolean fetchNext() {
        if (this.data == null) {
            return false;
        }
        try {
            if (!this.data.next()) {
                return false;
            }
            for (int c = 0; c < this.row.length; ++c) {
                this.row[c] = this.data.getObject(c + 1);
            }
            return true;
        }
        catch (SQLException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public boolean onHasNext() {
        return this.hasRow || (this.hasRow = this.fetchNext());
    }

    public T onNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasRow = false;
        return this.createRow();
    }

    protected abstract T createRow();

    public void onRemove() {
        throw new UnsupportedOperationException();
    }

    public void onClose() throws IgniteCheckedException {
        if (this.data == null) {
            return;
        }
        try {
            U.closeQuiet((AutoCloseable)this.data.getStatement());
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        U.closeQuiet((AutoCloseable)this.data);
    }

    public String toString() {
        return S.toString(((Object)((Object)this)).getClass(), (Object)((Object)this));
    }
}

