/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit.metastore;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.metastore.ClusterStatusWatchListener;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite.internal.deployunit.metastore.NodeStatusWatchListener;
import org.apache.ignite.internal.deployunit.metastore.accumulator.ClusterStatusAccumulator;
import org.apache.ignite.internal.deployunit.metastore.accumulator.NodeStatusAccumulator;
import org.apache.ignite.internal.deployunit.metastore.status.ClusterStatusKey;
import org.apache.ignite.internal.deployunit.metastore.status.NodeStatusKey;
import org.apache.ignite.internal.deployunit.metastore.status.UnitClusterStatus;
import org.apache.ignite.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class DeploymentUnitStoreImpl
implements DeploymentUnitStore {
    private final MetaStorageManager metaStorage;

    public DeploymentUnitStoreImpl(MetaStorageManager metaStorage) {
        this.metaStorage = metaStorage;
    }

    @Override
    public void registerNodeStatusListener(NodeStatusWatchListener listener) {
        this.metaStorage.registerPrefixWatch(NodeStatusKey.builder().build().toByteArray(), (WatchListener)listener);
    }

    @Override
    public void unregisterNodeStatusListener(NodeStatusWatchListener listener) {
        this.metaStorage.unregisterWatch((WatchListener)listener);
    }

    @Override
    public void registerClusterStatusListener(ClusterStatusWatchListener listener) {
        this.metaStorage.registerPrefixWatch(ClusterStatusKey.builder().build().toByteArray(), (WatchListener)listener);
    }

    @Override
    public void unregisterClusterStatusListener(ClusterStatusWatchListener listener) {
        this.metaStorage.unregisterWatch((WatchListener)listener);
    }

    @Override
    public CompletableFuture<List<UnitClusterStatus>> getClusterStatuses() {
        CompletableFuture<List<UnitClusterStatus>> result = new CompletableFuture<List<UnitClusterStatus>>();
        this.metaStorage.prefix(ClusterStatusKey.builder().build().toByteArray()).subscribe(new ClusterStatusAccumulator().toSubscriber(result));
        return result;
    }

    @Override
    public CompletableFuture<List<UnitClusterStatus>> getClusterStatuses(String id) {
        CompletableFuture<List<UnitClusterStatus>> result = new CompletableFuture<List<UnitClusterStatus>>();
        this.metaStorage.prefix(ClusterStatusKey.builder().id(id).build().toByteArray()).subscribe(new ClusterStatusAccumulator().toSubscriber(result));
        return result;
    }

    @Override
    public CompletableFuture<UnitClusterStatus> getClusterStatus(String id, Version version) {
        return this.metaStorage.get(ClusterStatusKey.builder().id(id).version(version).build().toByteArray()).thenApply(entry -> {
            byte[] value = entry.value();
            if (value == null) {
                return null;
            }
            return UnitClusterStatus.deserialize(value);
        });
    }

    @Override
    public CompletableFuture<List<UnitNodeStatus>> getNodeStatuses(String nodeId) {
        CompletableFuture<List<UnitNodeStatus>> result = new CompletableFuture<List<UnitNodeStatus>>();
        this.metaStorage.prefix(NodeStatusKey.builder().build().toByteArray()).subscribe(new NodeStatusAccumulator(unitNodeStatus -> Objects.equals(unitNodeStatus.nodeId(), nodeId)).toSubscriber(result));
        return result;
    }

    @Override
    public CompletableFuture<List<UnitNodeStatus>> getNodeStatuses(String nodeId, String unitId) {
        CompletableFuture<List<UnitNodeStatus>> result = new CompletableFuture<List<UnitNodeStatus>>();
        this.metaStorage.prefix(NodeStatusKey.builder().id(unitId).build().toByteArray()).subscribe(new NodeStatusAccumulator(unitNodeStatus -> Objects.equals(unitNodeStatus.nodeId(), nodeId)).toSubscriber(result));
        return result;
    }

    @Override
    public CompletableFuture<UnitNodeStatus> getNodeStatus(String nodeId, String id, Version version) {
        return this.metaStorage.get(NodeStatusKey.builder().id(id).version(version).nodeId(nodeId).build().toByteArray()).thenApply(entry -> {
            byte[] value = entry.value();
            if (value == null) {
                return null;
            }
            return UnitNodeStatus.deserialize(value);
        });
    }

    @Override
    public CompletableFuture<@Nullable UnitClusterStatus> createClusterStatus(String id, Version version, Set<String> nodes) {
        ByteArray key = ClusterStatusKey.builder().id(id).version(version).build().toByteArray();
        UUID operationId = UUID.randomUUID();
        UnitClusterStatus clusterStatus = new UnitClusterStatus(id, version, DeploymentStatus.UPLOADING, operationId, nodes);
        byte[] value = UnitClusterStatus.serialize(clusterStatus);
        return this.metaStorage.invoke((Condition)Conditions.notExists((ByteArray)key), Operations.put((ByteArray)key, (byte[])value), Operations.noop()).thenApply(deployed -> deployed != false ? clusterStatus : null);
    }

    @Override
    public CompletableFuture<Boolean> createNodeStatus(String nodeId, String id, Version version, UUID opId, DeploymentStatus status) {
        ByteArray key = NodeStatusKey.builder().id(id).version(version).nodeId(nodeId).build().toByteArray();
        byte[] value = UnitNodeStatus.serialize(new UnitNodeStatus(id, version, status, opId, nodeId));
        return this.metaStorage.invoke((Condition)Conditions.notExists((ByteArray)key), Operations.put((ByteArray)key, (byte[])value), Operations.noop());
    }

    @Override
    public CompletableFuture<Boolean> updateClusterStatus(String id, Version version, DeploymentStatus status) {
        return this.updateStatus(ClusterStatusKey.builder().id(id).version(version).build().toByteArray(), bytes -> {
            UnitClusterStatus prev = UnitClusterStatus.deserialize(bytes);
            if (status.compareTo(prev.status()) <= 0) {
                return null;
            }
            prev.updateStatus(status);
            return UnitClusterStatus.serialize(prev);
        }, status == DeploymentStatus.DEPLOYED);
    }

    @Override
    public CompletableFuture<Boolean> updateNodeStatus(String nodeId, String id, Version version, DeploymentStatus status) {
        return this.updateStatus(NodeStatusKey.builder().id(id).version(version).nodeId(nodeId).build().toByteArray(), bytes -> {
            UnitNodeStatus prev = UnitNodeStatus.deserialize(bytes);
            if (status.compareTo(prev.status()) <= 0) {
                return null;
            }
            prev.updateStatus(status);
            return UnitNodeStatus.serialize(prev);
        }, status == DeploymentStatus.DEPLOYED);
    }

    @Override
    public CompletableFuture<List<String>> getAllNodes(String id, Version version) {
        CompletableFuture result = new CompletableFuture();
        ByteArray nodes = NodeStatusKey.builder().id(id).version(version).build().toByteArray();
        this.metaStorage.prefix(nodes).subscribe(new NodeStatusAccumulator(status -> status.status() == DeploymentStatus.DEPLOYED).toSubscriber(result));
        return result.thenApply(status -> status.stream().map(UnitNodeStatus::nodeId).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<List<UnitNodeStatus>> getAllNodeStatuses(String id, Version version) {
        CompletableFuture<List<UnitNodeStatus>> result = new CompletableFuture<List<UnitNodeStatus>>();
        ByteArray nodes = NodeStatusKey.builder().id(id).version(version).build().toByteArray();
        this.metaStorage.prefix(nodes).subscribe(new NodeStatusAccumulator().toSubscriber(result));
        return result;
    }

    @Override
    public CompletableFuture<Boolean> removeClusterStatus(String id, Version version, UUID opId) {
        ByteArray key = ClusterStatusKey.builder().id(id).version(version).build().toByteArray();
        return this.metaStorage.get(key).thenCompose(e -> {
            UnitClusterStatus prev = UnitClusterStatus.deserialize(e.value());
            if (!Objects.equals(prev.opId(), opId)) {
                return CompletableFutures.falseCompletedFuture();
            }
            return this.metaStorage.invoke((Condition)Conditions.revision((ByteArray)key).eq(e.revision()), Operations.remove((ByteArray)key), Operations.noop());
        });
    }

    @Override
    public CompletableFuture<Boolean> removeNodeStatus(String nodeId, String id, Version version, UUID opId) {
        ByteArray key = NodeStatusKey.builder().id(id).version(version).nodeId(nodeId).build().toByteArray();
        return this.metaStorage.get(key).thenCompose(e -> {
            UnitNodeStatus prev = UnitNodeStatus.deserialize(e.value());
            if (!Objects.equals(prev.opId(), opId)) {
                return CompletableFutures.falseCompletedFuture();
            }
            return this.metaStorage.invoke((Condition)Conditions.revision((ByteArray)key).eq(e.revision()), Operations.remove((ByteArray)key), Operations.noop());
        });
    }

    private CompletableFuture<Boolean> updateStatus(ByteArray key, Function<byte[], byte[]> mapper, boolean force) {
        return this.metaStorage.get(key).thenCompose(e -> {
            byte[] value = e.value();
            if (value == null) {
                return CompletableFutures.falseCompletedFuture();
            }
            byte[] newValue = (byte[])mapper.apply(value);
            if (newValue == null) {
                return CompletableFutures.falseCompletedFuture();
            }
            return this.metaStorage.invoke((Condition)(force ? Conditions.exists((ByteArray)key) : Conditions.revision((ByteArray)key).eq(e.revision())), Operations.put((ByteArray)key, (byte[])newValue), Operations.noop()).thenCompose(finished -> {
                if (!finished.booleanValue() && !force) {
                    return this.updateStatus(key, mapper, false);
                }
                return CompletableFuture.completedFuture(finished);
            });
        });
    }
}

