/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class NewSchemaEntry
implements UpdateEntry {
    public static final CatalogObjectSerializer<NewSchemaEntry> SERIALIZER = new Serializer();
    private final CatalogSchemaDescriptor descriptor;

    public NewSchemaEntry(CatalogSchemaDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogSchemaDescriptor schema = catalog.schema(this.descriptor.name());
        if (schema != null) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Schema with name '{}' already exists", (Object[])new Object[]{schema.name()}));
        }
        this.descriptor.updateToken(causalityToken);
        ArrayList<CatalogSchemaDescriptor> schemas = new ArrayList<CatalogSchemaDescriptor>(catalog.schemas().size() + 1);
        schemas.addAll(catalog.schemas());
        schemas.add(this.descriptor);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), schemas, catalog.defaultZone().id());
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_SCHEMA.id();
    }

    private static class Serializer
    implements CatalogObjectSerializer<NewSchemaEntry> {
        private Serializer() {
        }

        @Override
        public NewSchemaEntry readFrom(IgniteDataInput input) throws IOException {
            CatalogSchemaDescriptor schemaDescriptor = CatalogSchemaDescriptor.SERIALIZER.readFrom(input);
            return new NewSchemaEntry(schemaDescriptor);
        }

        @Override
        public void writeTo(NewSchemaEntry value, IgniteDataOutput output) throws IOException {
            CatalogSchemaDescriptor.SERIALIZER.writeTo(value.descriptor, output);
        }
    }
}

