/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.query.calcite.message.MarshalableMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MarshallingContext;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationMappingException;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;

public class FragmentMapping
implements MarshalableMessage {
    @GridDirectCollection(value=ColocationGroup.class)
    private List<ColocationGroup> colocationGroups;

    public FragmentMapping() {
    }

    private FragmentMapping(ColocationGroup colocationGroup) {
        this(F.asList((Object)colocationGroup));
    }

    private FragmentMapping(List<ColocationGroup> colocationGroups) {
        this.colocationGroups = colocationGroups;
    }

    public static FragmentMapping create() {
        return new FragmentMapping(Collections.emptyList());
    }

    public static FragmentMapping create(UUID nodeId) {
        return new FragmentMapping(ColocationGroup.forNodes(Collections.singletonList(nodeId)));
    }

    public static FragmentMapping create(long sourceId) {
        return new FragmentMapping(ColocationGroup.forSourceId(sourceId));
    }

    public static FragmentMapping create(long sourceId, ColocationGroup group) {
        try {
            return new FragmentMapping(ColocationGroup.forSourceId(sourceId).colocate(group));
        }
        catch (ColocationMappingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean colocated() {
        return this.colocationGroups.isEmpty() || this.colocationGroups.size() == 1;
    }

    public FragmentMapping combine(FragmentMapping other) {
        return new FragmentMapping(Commons.combine(this.colocationGroups, other.colocationGroups));
    }

    public FragmentMapping colocate(FragmentMapping other) throws ColocationMappingException {
        assert (this.colocated() && other.colocated());
        ColocationGroup first = (ColocationGroup)F.first(this.colocationGroups);
        ColocationGroup second = (ColocationGroup)F.first(other.colocationGroups);
        if (first == null && second == null) {
            return this;
        }
        if (first == null || second == null) {
            return new FragmentMapping((ColocationGroup)U.firstNotNull((Object[])new ColocationGroup[]{first, second}));
        }
        return new FragmentMapping(first.colocate(second));
    }

    public FragmentMapping local(UUID nodeId) throws ColocationMappingException {
        if (this.colocationGroups.isEmpty()) {
            return FragmentMapping.create(nodeId).colocate(this);
        }
        return new FragmentMapping(Commons.transform(this.colocationGroups, c -> c.local(nodeId)));
    }

    public List<UUID> nodeIds() {
        return this.colocationGroups.stream().flatMap(g -> g.nodeIds().stream()).distinct().collect(Collectors.toList());
    }

    public List<ColocationGroup> colocationGroups() {
        return Collections.unmodifiableList(this.colocationGroups);
    }

    public FragmentMapping finalizeMapping(Supplier<List<UUID>> nodesSource) {
        if (this.colocationGroups.isEmpty()) {
            return this;
        }
        List<ColocationGroup> colocationGroups = this.colocationGroups;
        colocationGroups = Commons.transform(colocationGroups, ColocationGroup::finalizeMapping);
        List<UUID> nodes = this.nodeIds();
        List<UUID> nodes0 = nodes.isEmpty() ? nodesSource.get() : nodes;
        colocationGroups = Commons.transform(colocationGroups, g -> g.mapToNodes(nodes0));
        return new FragmentMapping(colocationGroups);
    }

    public FragmentMapping filterByPartitions(int[] parts) throws ColocationMappingException {
        List<ColocationGroup> colocationGroups = this.colocationGroups;
        if (!F.isEmpty((int[])parts) && colocationGroups.size() > 1) {
            throw new ColocationMappingException("Execution of non-collocated query with partition parameter is not possible");
        }
        colocationGroups = Commons.transform(colocationGroups, g -> g.filterByPartitions(parts));
        return new FragmentMapping(colocationGroups);
    }

    @NotNull
    public ColocationGroup findGroup(long sourceId) {
        List groups = this.colocationGroups.stream().filter(c -> c.belongs(sourceId)).collect(Collectors.toList());
        if (groups.isEmpty()) {
            throw new IllegalStateException("Failed to find group with given id. [sourceId=" + sourceId + "]");
        }
        if (groups.size() > 1) {
            throw new IllegalStateException("Multiple groups with the same id found. [sourceId=" + sourceId + "]");
        }
        return (ColocationGroup)F.first(groups);
    }

    @Override
    public void prepareMarshal(MarshallingContext ctx) {
        this.colocationGroups.forEach(g -> g.prepareMarshal(ctx));
    }

    @Override
    public void prepareUnmarshal(MarshallingContext ctx) {
        this.colocationGroups.forEach(g -> g.prepareUnmarshal(ctx));
    }

    @Override
    public MessageType type() {
        return MessageType.FRAGMENT_MAPPING;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("colocationGroups", this.colocationGroups, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.colocationGroups = (List)reader.readCollection("colocationGroups", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FragmentMapping.class);
    }

    public byte fieldsCount() {
        return 1;
    }
}

