/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.calcite.message.ExecutionContextAware;
import org.apache.ignite.internal.processors.query.calcite.message.MarshalableMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MarshallingContext;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentDescription;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class QueryStartRequest
implements MarshalableMessage,
ExecutionContextAware {
    private String schema;
    private UUID qryId;
    private long originatingQryId;
    private AffinityTopologyVersion ver;
    private FragmentDescription fragmentDesc;
    private String root;
    private int totalFragmentsCnt;
    @GridDirectTransient
    private Object[] params;
    private byte[] paramsBytes;
    private long timeout;

    public QueryStartRequest(UUID qryId, long originatingQryId, String schema, String root, AffinityTopologyVersion ver, FragmentDescription fragmentDesc, int totalFragmentsCnt, Object[] params, @Nullable byte[] paramsBytes, long timeout) {
        this.qryId = qryId;
        this.originatingQryId = originatingQryId;
        this.schema = schema;
        this.root = root;
        this.ver = ver;
        this.fragmentDesc = fragmentDesc;
        this.totalFragmentsCnt = totalFragmentsCnt;
        this.params = params;
        this.paramsBytes = paramsBytes;
        this.timeout = timeout;
    }

    QueryStartRequest() {
    }

    public String schema() {
        return this.schema;
    }

    @Override
    public UUID queryId() {
        return this.qryId;
    }

    public long originatingQryId() {
        return this.originatingQryId;
    }

    @Override
    public long fragmentId() {
        return this.fragmentDesc.fragmentId();
    }

    public FragmentDescription fragmentDescription() {
        return this.fragmentDesc;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.ver;
    }

    public String root() {
        return this.root;
    }

    public int totalFragmentsCount() {
        return this.totalFragmentsCnt;
    }

    public Object[] parameters() {
        return this.params;
    }

    public byte[] parametersMarshalled() {
        return this.paramsBytes;
    }

    public long timeout() {
        return this.timeout;
    }

    @Override
    public void prepareMarshal(MarshallingContext ctx) throws IgniteCheckedException {
        if (this.paramsBytes == null && this.params != null) {
            this.paramsBytes = ctx.marshal(this.params);
        }
        this.fragmentDesc.prepareMarshal(ctx);
    }

    @Override
    public void prepareUnmarshal(MarshallingContext ctx) throws IgniteCheckedException {
        if (this.params == null && this.paramsBytes != null) {
            this.params = (Object[])ctx.unmarshal(this.paramsBytes);
        }
        this.fragmentDesc.prepareUnmarshal(ctx);
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("fragmentDesc", (Message)this.fragmentDesc)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("originatingQryId", this.originatingQryId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByteArray("paramsBytes", this.paramsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeUuid("qryId", this.qryId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeString("root", this.root)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeString("schema", this.schema)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeInt("totalFragmentsCnt", this.totalFragmentsCnt)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeAffinityTopologyVersion("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.fragmentDesc = (FragmentDescription)reader.readMessage("fragmentDesc");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.originatingQryId = reader.readLong("originatingQryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.paramsBytes = reader.readByteArray("paramsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.qryId = reader.readUuid("qryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.root = reader.readString("root");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.schema = reader.readString("schema");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.totalFragmentsCnt = reader.readInt("totalFragmentsCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.ver = reader.readAffinityTopologyVersion("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryStartRequest.class);
    }

    @Override
    public MessageType type() {
        return MessageType.QUERY_START_REQUEST;
    }

    public byte fieldsCount() {
        return 9;
    }
}

