/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.util.EnumMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.calcite.CalciteQueryProcessor;
import org.apache.ignite.internal.processors.query.calcite.exec.QueryTaskExecutor;
import org.apache.ignite.internal.processors.query.calcite.message.CalciteMessage;
import org.apache.ignite.internal.processors.query.calcite.message.ExecutionContextAware;
import org.apache.ignite.internal.processors.query.calcite.message.MarshalableMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MarshallingContext;
import org.apache.ignite.internal.processors.query.calcite.message.MessageListener;
import org.apache.ignite.internal.processors.query.calcite.message.MessageService;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.plugin.extensions.communication.Message;

public class MessageServiceImpl
extends AbstractService
implements MessageService,
MarshallingContext {
    private final GridMessageListener msgLsnr = this::onMessage;
    private UUID localNodeId;
    private GridIoManager ioManager;
    private ClassLoader classLoader;
    private QueryTaskExecutor taskExecutor;
    private FailureProcessor failureProcessor;
    private Marshaller marsh;
    private EnumMap<MessageType, MessageListener> lsnrs;

    public MessageServiceImpl(GridKernalContext ctx) {
        super(ctx);
    }

    public void localNodeId(UUID localNodeId) {
        this.localNodeId = localNodeId;
    }

    public UUID localNodeId() {
        return this.localNodeId;
    }

    public void ioManager(GridIoManager ioManager) {
        this.ioManager = ioManager;
    }

    public GridIoManager ioManager() {
        return this.ioManager;
    }

    public void classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public void taskExecutor(QueryTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public QueryTaskExecutor taskExecutor() {
        return this.taskExecutor;
    }

    public void marshaller(Marshaller marsh) {
        this.marsh = marsh;
    }

    @Override
    public Marshaller marshaller() {
        return this.marsh;
    }

    public void failureProcessor(FailureProcessor failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public FailureProcessor failureProcessor() {
        return this.failureProcessor;
    }

    @Override
    public void onStart(GridKernalContext ctx) {
        this.localNodeId(ctx.localNodeId());
        this.classLoader(U.resolveClassLoader((IgniteConfiguration)ctx.config()));
        this.ioManager(ctx.io());
        Marshaller marsh0 = ctx.config().getMarshaller();
        if (marsh0 == null) {
            marsh0 = MarshallerUtils.jdkMarshaller((String)ctx.igniteInstanceName());
        }
        this.marshaller(marsh0);
        CalciteQueryProcessor proc = Objects.requireNonNull(Commons.lookupComponent(ctx, CalciteQueryProcessor.class));
        this.taskExecutor(proc.taskExecutor());
        this.failureProcessor(proc.failureProcessor());
        this.init();
    }

    @Override
    public void init() {
        this.ioManager().addMessageListener(GridTopic.TOPIC_QUERY, this.msgLsnr);
    }

    @Override
    public void tearDown() {
        this.ioManager().removeMessageListener(GridTopic.TOPIC_QUERY, this.msgLsnr);
        this.lsnrs = null;
    }

    @Override
    public void send(UUID nodeId, CalciteMessage msg) throws IgniteCheckedException {
        if (this.localNodeId().equals(nodeId)) {
            this.onMessage(nodeId, msg);
        } else {
            this.prepareMarshal(msg);
            this.ioManager().sendToGridTopic(nodeId, GridTopic.TOPIC_QUERY, (Message)msg, (byte)13);
        }
    }

    @Override
    public void register(MessageListener lsnr, MessageType type) {
        if (this.lsnrs == null) {
            this.lsnrs = new EnumMap(MessageType.class);
        }
        MessageListener old = this.lsnrs.put(type, lsnr);
        assert (old == null) : old;
    }

    @Override
    public boolean alive(UUID nodeId) {
        try {
            return !this.ioManager().checkNodeLeft(nodeId, null, false);
        }
        catch (IgniteClientDisconnectedCheckedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void prepareMarshal(Message msg) throws IgniteCheckedException {
        try {
            if (msg instanceof MarshalableMessage) {
                ((MarshalableMessage)msg).prepareMarshal(this);
            }
        }
        catch (Exception e) {
            this.failureProcessor().process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
            throw e;
        }
    }

    protected void prepareUnmarshal(Message msg) throws IgniteCheckedException {
        try {
            if (msg instanceof MarshalableMessage) {
                ((MarshalableMessage)msg).prepareUnmarshal(this);
            }
        }
        catch (Exception e) {
            this.failureProcessor().process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
            throw e;
        }
    }

    protected void onMessage(UUID nodeId, CalciteMessage msg) {
        if (msg instanceof ExecutionContextAware) {
            ExecutionContextAware msg0 = (ExecutionContextAware)msg;
            this.taskExecutor().execute(msg0.queryId(), msg0.fragmentId(), () -> this.onMessageInternal(nodeId, msg));
        } else {
            this.taskExecutor().execute(IgniteUuid.VM_ID, ThreadLocalRandom.current().nextLong(1024L), () -> this.onMessageInternal(nodeId, msg));
        }
    }

    private void onMessage(UUID nodeId, Object msg, byte plc) {
        if (msg instanceof CalciteMessage) {
            this.onMessage(nodeId, (CalciteMessage)msg);
        }
    }

    private void onMessageInternal(UUID nodeId, CalciteMessage msg) {
        try {
            this.prepareUnmarshal(msg);
            MessageListener lsnr = Objects.requireNonNull(this.lsnrs.get((Object)msg.type()));
            lsnr.onMessage(nodeId, msg);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }
}

