/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RuntimeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.jetbrains.annotations.NotNull;

public class RuntimeHashIndex<Row>
implements RuntimeIndex<Row> {
    private static final GroupKey NULL_KEY = new GroupKey(X.EMPTY_OBJECT_ARRAY);
    protected final ExecutionContext<Row> ectx;
    private final ImmutableBitSet keys;
    private final HashMap<GroupKey, List<Row>> rows;
    private final boolean allowNulls;

    public RuntimeHashIndex(ExecutionContext<Row> ectx, ImmutableBitSet keys, boolean allowNulls) {
        this.ectx = ectx;
        assert (!F.isEmpty((Iterable)keys));
        this.keys = keys;
        this.allowNulls = allowNulls;
        this.rows = new HashMap();
    }

    @Override
    public void push(Row r) {
        GroupKey key = this.key(r);
        if (key == NULL_KEY) {
            return;
        }
        List eqRows = this.rows.computeIfAbsent(key, k -> new ArrayList());
        eqRows.add(r);
    }

    @Override
    public void close() {
        this.rows.clear();
    }

    public Iterable<Row> scan(Supplier<Row> searchRow) {
        return new IndexScan(searchRow);
    }

    private GroupKey key(Row r) {
        GroupKey.Builder b = GroupKey.builder(this.keys.cardinality());
        for (Integer field : this.keys) {
            Object fieldVal = this.ectx.rowHandler().get(field, r);
            if (fieldVal == null && !this.allowNulls) {
                return NULL_KEY;
            }
            b.add(fieldVal);
        }
        return b.build();
    }

    private class IndexScan
    implements Iterable<Row>,
    AutoCloseable {
        private final Supplier<Row> searchRow;

        IndexScan(Supplier<Row> searchRow) {
            this.searchRow = searchRow;
        }

        @Override
        public void close() {
        }

        @Override
        @NotNull
        public Iterator<Row> iterator() {
            GroupKey key = RuntimeHashIndex.this.key(this.searchRow.get());
            if (key == NULL_KEY) {
                return Collections.emptyIterator();
            }
            List eqRows = (List)RuntimeHashIndex.this.rows.get(key);
            return eqRows == null ? Collections.emptyIterator() : eqRows.iterator();
        }
    }
}

