/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.QueryState;
import org.apache.ignite.internal.processors.query.calcite.RunningFragment;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeService;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.MemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.NoOpMemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.QueryMemoryTracker;
import org.apache.ignite.internal.util.lang.RunnableX;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class Query<RowT> {
    private final UUID initNodeId;
    private final UUID id;
    protected final Object mux = new Object();
    protected final Set<RunningFragment<RowT>> fragments;
    protected final GridQueryCancel cancel;
    protected final BiConsumer<Query<RowT>, Throwable> unregister;
    protected volatile QueryState state = QueryState.INITED;
    protected final ExchangeService exch;
    protected final int totalFragmentsCnt;
    protected final AtomicInteger finishedFragmentsCnt = new AtomicInteger();
    protected final Set<Long> initNodeStartedExchanges = new HashSet<Long>();
    protected final IgniteLogger log;
    private MemoryTracker memoryTracker;

    public Query(UUID id, UUID initNodeId, GridQueryCancel cancel, ExchangeService exch, BiConsumer<Query<RowT>, Throwable> unregister, IgniteLogger log, int totalFragmentsCnt) {
        this.id = id;
        this.unregister = unregister;
        this.initNodeId = initNodeId;
        this.exch = exch;
        this.log = log;
        this.cancel = cancel != null ? cancel : new GridQueryCancel();
        this.fragments = Collections.newSetFromMap(new ConcurrentHashMap());
        this.totalFragmentsCnt = totalFragmentsCnt;
    }

    public UUID id() {
        return this.id;
    }

    public QueryState state() {
        return this.state;
    }

    public UUID initiatorNodeId() {
        return this.initNodeId;
    }

    public void onError(Throwable failure) {
        this.tryClose(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryClose(@Nullable Throwable failure) {
        ArrayList<RunningFragment<RowT>> fragments = new ArrayList<RunningFragment<RowT>>(this.fragments);
        AtomicInteger cntDown = new AtomicInteger(fragments.size());
        if (cntDown.get() == 0) {
            this.unregister.accept(this, failure);
        }
        for (RunningFragment runningFragment : fragments) {
            runningFragment.context().execute((RunnableX & Serializable)() -> {
                frag.root().close();
                frag.context().cancel();
                if (cntDown.decrementAndGet() == 0) {
                    this.unregister.accept(this, failure);
                }
            }, runningFragment.root()::onError);
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.memoryTracker != null) {
                this.memoryTracker.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Iterator<RunningFragment<RowT>> iterator = this.mux;
        synchronized (iterator) {
            if (this.state == QueryState.CLOSED) {
                return;
            }
            if (this.state == QueryState.INITED) {
                this.state = QueryState.CLOSING;
                try {
                    this.exch.closeQuery(this.initNodeId, this.id);
                    return;
                }
                catch (IgniteCheckedException e) {
                    this.log.warning("Cannot send cancel request to query initiator", (Throwable)e);
                }
            }
            if (this.state == QueryState.EXECUTING || this.state == QueryState.CLOSING) {
                this.state = QueryState.CLOSED;
            }
        }
        for (RunningFragment frag : this.fragments) {
            frag.context().execute((RunnableX & Serializable)() -> frag.root().onError((Throwable)new QueryCancelledException()), frag.root()::onError);
        }
        this.tryClose((Throwable)this.queryCanceledException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFragment(RunningFragment<RowT> f) {
        Object object = this.mux;
        synchronized (object) {
            if (this.state == QueryState.INITED) {
                this.state = QueryState.EXECUTING;
            }
            if (this.state == QueryState.CLOSING || this.state == QueryState.CLOSED) {
                throw this.queryCanceledException();
            }
            this.fragments.add(f);
        }
    }

    public boolean isCancelled() {
        return this.cancel.isCanceled();
    }

    protected IgniteSQLException queryCanceledException() {
        return new IgniteSQLException("The query was cancelled", 3014, (Throwable)new QueryCancelledException());
    }

    public void onNodeLeft(UUID nodeId) {
        if (this.initNodeId.equals(nodeId)) {
            this.cancel();
        }
    }

    public void onInboundExchangeStarted(UUID nodeId, long exchangeId) {
    }

    public void onInboundExchangeFinished(UUID nodeId, long exchangeId) {
    }

    public void onOutboundExchangeStarted(UUID nodeId, long exchangeId) {
        if (this.initNodeId.equals(nodeId)) {
            this.initNodeStartedExchanges.add(exchangeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutboundExchangeFinished(long exchangeId) {
        if (this.finishedFragmentsCnt.incrementAndGet() == this.totalFragmentsCnt) {
            QueryState state0;
            Object object = this.mux;
            synchronized (object) {
                state0 = this.state;
                if (state0 == QueryState.EXECUTING) {
                    this.state = QueryState.CLOSED;
                }
            }
            if (state0 == QueryState.EXECUTING) {
                this.tryClose(null);
            }
        }
    }

    public boolean isExchangeWithInitNodeStarted(long fragmentId) {
        return this.initNodeStartedExchanges.contains(fragmentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryTracker createMemoryTracker(MemoryTracker globalMemoryTracker, long quota) {
        Object object = this.mux;
        synchronized (object) {
            if (this.memoryTracker == null) {
                this.memoryTracker = quota > 0L || globalMemoryTracker != NoOpMemoryTracker.INSTANCE ? new QueryMemoryTracker(globalMemoryTracker, quota) : NoOpMemoryTracker.INSTANCE;
            }
            return this.memoryTracker;
        }
    }

    public String toString() {
        return S.toString(Query.class, (Object)this, (String)"state", (Object)((Object)this.state), (String)"fragments", this.fragments);
    }
}

