/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class GenericOrcWriter
implements OrcValueWriter<Record> {
    private final Converter[] converters;
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private GenericOrcWriter(TypeDescription schema) {
        this.converters = GenericOrcWriter.buildConverters(schema);
    }

    public static OrcValueWriter<Record> buildWriter(TypeDescription fileSchema) {
        return new GenericOrcWriter(fileSchema);
    }

    public void write(Record value, VectorizedRowBatch output) throws IOException {
        int row = output.size++;
        for (int c = 0; c < this.converters.length; ++c) {
            this.converters[c].addValue(row, value.get(c, this.converters[c].getJavaClass()), output.cols[c]);
        }
    }

    private static Converter buildConverter(TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanConverter();
            }
            case BYTE: {
                return new ByteConverter();
            }
            case SHORT: {
                return new ShortConverter();
            }
            case DATE: {
                return new DateConverter();
            }
            case INT: {
                return new IntConverter();
            }
            case LONG: {
                String longAttributeValue = schema.getAttributeValue("iceberg.long-type");
                ORCSchemaUtil.LongType longType = longAttributeValue == null ? ORCSchemaUtil.LongType.LONG : ORCSchemaUtil.LongType.valueOf((String)longAttributeValue);
                switch (longType) {
                    case TIME: {
                        return new TimeConverter();
                    }
                    case LONG: {
                        return new LongConverter();
                    }
                }
                throw new IllegalStateException("Unhandled Long type found in ORC type attribute: " + longType);
            }
            case FLOAT: {
                return new FloatConverter();
            }
            case DOUBLE: {
                return new DoubleConverter();
            }
            case BINARY: {
                String binaryAttributeValue = schema.getAttributeValue("iceberg.binary-type");
                ORCSchemaUtil.BinaryType binaryType = binaryAttributeValue == null ? ORCSchemaUtil.BinaryType.BINARY : ORCSchemaUtil.BinaryType.valueOf((String)binaryAttributeValue);
                switch (binaryType) {
                    case UUID: {
                        return new UUIDConverter();
                    }
                    case FIXED: {
                        return new FixedConverter();
                    }
                    case BINARY: {
                        return new BytesConverter();
                    }
                }
                throw new IllegalStateException("Unhandled Binary type found in ORC type attribute: " + binaryType);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringConverter();
            }
            case DECIMAL: {
                return schema.getPrecision() <= 18 ? new Decimal18Converter(schema) : new Decimal38Converter(schema);
            }
            case TIMESTAMP: {
                return new TimestampConverter();
            }
            case TIMESTAMP_INSTANT: {
                return new TimestampTzConverter();
            }
            case STRUCT: {
                return new StructConverter(schema);
            }
            case LIST: {
                return new ListConverter(schema);
            }
            case MAP: {
                return new MapConverter(schema);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    private static Converter[] buildConverters(TypeDescription schema) {
        if (schema.getCategory() != TypeDescription.Category.STRUCT) {
            throw new IllegalArgumentException("Top level must be a struct " + schema);
        }
        List children = schema.getChildren();
        Converter[] result = new Converter[children.size()];
        for (int c = 0; c < children.size(); ++c) {
            result[c] = GenericOrcWriter.buildConverter((TypeDescription)children.get(c));
        }
        return result;
    }

    static class MapConverter
    implements Converter<Map> {
        private final Converter keyConverter;
        private final Converter valueConverter;

        MapConverter(TypeDescription schema) {
            this.keyConverter = GenericOrcWriter.buildConverter((TypeDescription)schema.getChildren().get(0));
            this.valueConverter = GenericOrcWriter.buildConverter((TypeDescription)schema.getChildren().get(1));
        }

        @Override
        public Class<Map> getJavaClass() {
            return Map.class;
        }

        @Override
        public void addValue(int rowId, Map data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                Map map = data;
                ArrayList keys = Lists.newArrayListWithExpectedSize((int)map.size());
                ArrayList values = Lists.newArrayListWithExpectedSize((int)map.size());
                for (Map.Entry entry : map.entrySet()) {
                    keys.add(entry.getKey());
                    values.add(entry.getValue());
                }
                MapColumnVector cv = (MapColumnVector)output;
                cv.lengths[rowId] = map.size();
                cv.offsets[rowId] = cv.childCount;
                cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
                cv.keys.ensureSize(cv.childCount, true);
                cv.values.ensureSize(cv.childCount, true);
                int e = 0;
                while ((long)e < cv.lengths[rowId]) {
                    int pos = (int)((long)e + cv.offsets[rowId]);
                    this.keyConverter.addValue(pos, keys.get(e), cv.keys);
                    this.valueConverter.addValue(pos, values.get(e), cv.values);
                    ++e;
                }
            }
        }
    }

    static class ListConverter
    implements Converter<List> {
        private final Converter children;

        ListConverter(TypeDescription schema) {
            this.children = GenericOrcWriter.buildConverter((TypeDescription)schema.getChildren().get(0));
        }

        @Override
        public Class<List> getJavaClass() {
            return List.class;
        }

        @Override
        public void addValue(int rowId, List data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                List value = data;
                ListColumnVector cv = (ListColumnVector)output;
                cv.lengths[rowId] = value.size();
                cv.offsets[rowId] = cv.childCount;
                cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
                cv.child.ensureSize(cv.childCount, true);
                int e = 0;
                while ((long)e < cv.lengths[rowId]) {
                    this.children.addValue((int)((long)e + cv.offsets[rowId]), value.get(e), cv.child);
                    ++e;
                }
            }
        }
    }

    static class StructConverter
    implements Converter<Record> {
        private final Converter[] children;

        StructConverter(TypeDescription schema) {
            this.children = new Converter[schema.getChildren().size()];
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = GenericOrcWriter.buildConverter((TypeDescription)schema.getChildren().get(c));
            }
        }

        @Override
        public Class<Record> getJavaClass() {
            return Record.class;
        }

        @Override
        public void addValue(int rowId, Record data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                StructColumnVector cv = (StructColumnVector)output;
                for (int c = 0; c < this.children.length; ++c) {
                    this.children[c].addValue(rowId, data.get(c, this.children[c].getJavaClass()), cv.fields[c]);
                }
            }
        }
    }

    static class Decimal38Converter
    implements Converter<BigDecimal> {
        Decimal38Converter(TypeDescription schema) {
        }

        @Override
        public Class<BigDecimal> getJavaClass() {
            return BigDecimal.class;
        }

        @Override
        public void addValue(int rowId, BigDecimal data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((DecimalColumnVector)output).vector[rowId].set(HiveDecimal.create((BigDecimal)data, (boolean)false));
            }
        }
    }

    static class Decimal18Converter
    implements Converter<BigDecimal> {
        private final int scale;

        Decimal18Converter(TypeDescription schema) {
            this.scale = schema.getScale();
        }

        @Override
        public Class<BigDecimal> getJavaClass() {
            return BigDecimal.class;
        }

        @Override
        public void addValue(int rowId, BigDecimal data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((DecimalColumnVector)output).vector[rowId].setFromLongAndScale(data.unscaledValue().longValueExact(), this.scale);
            }
        }
    }

    static class TimestampConverter
    implements Converter<LocalDateTime> {
        TimestampConverter() {
        }

        @Override
        public Class<LocalDateTime> getJavaClass() {
            return LocalDateTime.class;
        }

        @Override
        public void addValue(int rowId, LocalDateTime data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                TimestampColumnVector cv = (TimestampColumnVector)output;
                cv.setIsUTC(true);
                cv.time[rowId] = data.toInstant(ZoneOffset.UTC).toEpochMilli();
                cv.nanos[rowId] = data.getNano() / 1000 * 1000;
            }
        }
    }

    static class TimestampTzConverter
    implements Converter<OffsetDateTime> {
        TimestampTzConverter() {
        }

        @Override
        public Class<OffsetDateTime> getJavaClass() {
            return OffsetDateTime.class;
        }

        @Override
        public void addValue(int rowId, OffsetDateTime data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                TimestampColumnVector cv = (TimestampColumnVector)output;
                cv.time[rowId] = data.toInstant().toEpochMilli();
                cv.nanos[rowId] = data.getNano() / 1000 * 1000;
            }
        }
    }

    static class DateConverter
    implements Converter<LocalDate> {
        DateConverter() {
        }

        @Override
        public Class<LocalDate> getJavaClass() {
            return LocalDate.class;
        }

        @Override
        public void addValue(int rowId, LocalDate data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = ChronoUnit.DAYS.between(EPOCH_DAY, data);
            }
        }
    }

    static class FixedConverter
    implements Converter<byte[]> {
        FixedConverter() {
        }

        @Override
        public Class<byte[]> getJavaClass() {
            return byte[].class;
        }

        @Override
        public void addValue(int rowId, byte[] data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((BytesColumnVector)output).setRef(rowId, data, 0, data.length);
            }
        }
    }

    static class UUIDConverter
    implements Converter<UUID> {
        UUIDConverter() {
        }

        @Override
        public Class<UUID> getJavaClass() {
            return UUID.class;
        }

        @Override
        public void addValue(int rowId, UUID data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ByteBuffer buffer = ByteBuffer.allocate(16);
                buffer.putLong(data.getMostSignificantBits());
                buffer.putLong(data.getLeastSignificantBits());
                ((BytesColumnVector)output).setRef(rowId, buffer.array(), 0, buffer.array().length);
            }
        }
    }

    static class BytesConverter
    implements Converter<ByteBuffer> {
        BytesConverter() {
        }

        @Override
        public Class<ByteBuffer> getJavaClass() {
            return ByteBuffer.class;
        }

        @Override
        public void addValue(int rowId, ByteBuffer data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((BytesColumnVector)output).setRef(rowId, data.array(), 0, data.array().length);
            }
        }
    }

    static class StringConverter
    implements Converter<String> {
        StringConverter() {
        }

        @Override
        public Class<String> getJavaClass() {
            return String.class;
        }

        @Override
        public void addValue(int rowId, String data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                byte[] value = data.getBytes(StandardCharsets.UTF_8);
                ((BytesColumnVector)output).setRef(rowId, value, 0, value.length);
            }
        }
    }

    static class DoubleConverter
    implements Converter<Double> {
        DoubleConverter() {
        }

        @Override
        public Class<Double> getJavaClass() {
            return Double.class;
        }

        @Override
        public void addValue(int rowId, Double data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((DoubleColumnVector)output).vector[rowId] = data;
            }
        }
    }

    static class FloatConverter
    implements Converter<Float> {
        FloatConverter() {
        }

        @Override
        public Class<Float> getJavaClass() {
            return Float.class;
        }

        @Override
        public void addValue(int rowId, Float data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((DoubleColumnVector)output).vector[rowId] = data.floatValue();
            }
        }
    }

    static class LongConverter
    implements Converter<Long> {
        LongConverter() {
        }

        @Override
        public Class<Long> getJavaClass() {
            return Long.class;
        }

        @Override
        public void addValue(int rowId, Long data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data;
            }
        }
    }

    static class TimeConverter
    implements Converter<LocalTime> {
        TimeConverter() {
        }

        @Override
        public Class<LocalTime> getJavaClass() {
            return LocalTime.class;
        }

        @Override
        public void addValue(int rowId, LocalTime data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.toNanoOfDay() / 1000L;
            }
        }
    }

    static class IntConverter
    implements Converter<Integer> {
        IntConverter() {
        }

        @Override
        public Class<Integer> getJavaClass() {
            return Integer.class;
        }

        @Override
        public void addValue(int rowId, Integer data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.intValue();
            }
        }
    }

    static class ShortConverter
    implements Converter<Short> {
        ShortConverter() {
        }

        @Override
        public Class<Short> getJavaClass() {
            return Short.class;
        }

        @Override
        public void addValue(int rowId, Short data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.shortValue();
            }
        }
    }

    static class ByteConverter
    implements Converter<Byte> {
        ByteConverter() {
        }

        @Override
        public Class<Byte> getJavaClass() {
            return Byte.class;
        }

        @Override
        public void addValue(int rowId, Byte data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.byteValue();
            }
        }
    }

    static class BooleanConverter
    implements Converter<Boolean> {
        BooleanConverter() {
        }

        @Override
        public Class<Boolean> getJavaClass() {
            return Boolean.class;
        }

        @Override
        public void addValue(int rowId, Boolean data, ColumnVector output) {
            if (data == null) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data != false ? 1L : 0L;
            }
        }
    }

    static interface Converter<T> {
        public Class<T> getJavaClass();

        public void addValue(int var1, T var2, ColumnVector var3);
    }
}

