/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaWithTypeVisitor;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.data.avro.GenericReaders;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class DataReader<T>
implements DatumReader<T> {
    private static final ThreadLocal<Map<org.apache.avro.Schema, Map<org.apache.avro.Schema, ResolvingDecoder>>> DECODER_CACHES = ThreadLocal.withInitial(() -> new MapMaker().weakKeys().makeMap());
    private final org.apache.avro.Schema readSchema;
    private final ValueReader<T> reader;
    private org.apache.avro.Schema fileSchema = null;

    public static <D> DataReader<D> create(Schema expectedSchema, org.apache.avro.Schema readSchema) {
        return DataReader.create(expectedSchema, readSchema, ImmutableMap.of());
    }

    public static <D> DataReader<D> create(Schema expectedSchema, org.apache.avro.Schema readSchema, Map<Integer, ?> idToConstant) {
        return new DataReader(expectedSchema, readSchema, idToConstant);
    }

    private DataReader(Schema expectedSchema, org.apache.avro.Schema readSchema, Map<Integer, ?> idToConstant) {
        this.readSchema = readSchema;
        this.reader = (ValueReader)AvroSchemaWithTypeVisitor.visit((Schema)expectedSchema, (org.apache.avro.Schema)readSchema, (AvroSchemaWithTypeVisitor)new ReadBuilder(idToConstant));
    }

    public void setSchema(org.apache.avro.Schema newFileSchema) {
        this.fileSchema = org.apache.avro.Schema.applyAliases((org.apache.avro.Schema)newFileSchema, (org.apache.avro.Schema)this.readSchema);
    }

    public T read(T reuse, Decoder decoder) throws IOException {
        ResolvingDecoder resolver = this.resolve(decoder);
        Object value = this.reader.read((Decoder)resolver, reuse);
        resolver.drain();
        return (T)value;
    }

    private ResolvingDecoder resolve(Decoder decoder) throws IOException {
        Map<org.apache.avro.Schema, Map<org.apache.avro.Schema, ResolvingDecoder>> cache = DECODER_CACHES.get();
        Map fileSchemaToResolver = cache.computeIfAbsent(this.readSchema, k -> new HashMap());
        ResolvingDecoder resolver = (ResolvingDecoder)fileSchemaToResolver.get(this.fileSchema);
        if (resolver == null) {
            resolver = this.newResolver();
            fileSchemaToResolver.put(this.fileSchema, resolver);
        }
        resolver.configure(decoder);
        return resolver;
    }

    private ResolvingDecoder newResolver() {
        try {
            return DecoderFactory.get().resolvingDecoder(this.fileSchema, this.readSchema, null);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static class ReadBuilder
    extends AvroSchemaWithTypeVisitor<ValueReader<?>> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        public ValueReader<?> record(Types.StructType struct, org.apache.avro.Schema record, List<String> names, List<ValueReader<?>> fields) {
            return GenericReaders.struct(struct, fields, this.idToConstant);
        }

        public ValueReader<?> union(Type ignored, org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        public ValueReader<?> array(Types.ListType ignored, org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return ValueReaders.array(elementReader);
        }

        public ValueReader<?> map(Types.MapType iMap, org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            return ValueReaders.arrayMap(keyReader, valueReader);
        }

        public ValueReader<?> map(Types.MapType ignored, org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map((ValueReader)ValueReaders.strings(), valueReader);
        }

        public ValueReader<?> primitive(Type.PrimitiveType ignored, org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return GenericReaders.dates();
                    }
                    case "time-micros": {
                        return GenericReaders.times();
                    }
                    case "timestamp-micros": {
                        if (AvroSchemaUtil.isTimestamptz((org.apache.avro.Schema)primitive)) {
                            return GenericReaders.timestamptz();
                        }
                        return GenericReaders.timestamps();
                    }
                    case "decimal": {
                        ValueReader inner;
                        switch (primitive.getType()) {
                            case FIXED: {
                                inner = ValueReaders.fixed((int)primitive.getFixedSize());
                                break;
                            }
                            case BYTES: {
                                inner = ValueReaders.bytes();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid primitive type for decimal: " + primitive.getType());
                            }
                        }
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return ValueReaders.decimal((ValueReader)inner, (int)decimal.getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.strings();
                }
                case FIXED: {
                    return ValueReaders.fixed((int)primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

