/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import com.google.common.primitives.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.message.MessageEncoder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.avro.DataWriter;

public class IcebergEncoder<D>
implements MessageEncoder<D> {
    static final byte[] V1_HEADER = new byte[]{-61, 1};
    private static final ThreadLocal<BufferOutputStream> TEMP = ThreadLocal.withInitial(BufferOutputStream::new);
    private static final ThreadLocal<BinaryEncoder> ENCODER = new ThreadLocal();
    private final byte[] headerBytes;
    private final boolean copyOutputBytes;
    private final DatumWriter<D> writer;

    public IcebergEncoder(Schema schema) {
        this(schema, true);
    }

    public IcebergEncoder(Schema schema, boolean shouldCopy) {
        this.copyOutputBytes = shouldCopy;
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)schema, (String)"table");
        this.writer = DataWriter.create(avroSchema);
        this.headerBytes = IcebergEncoder.getWriteHeader(avroSchema);
    }

    public ByteBuffer encode(D datum) throws IOException {
        BufferOutputStream temp = TEMP.get();
        temp.reset();
        temp.write(this.headerBytes);
        this.encode(datum, temp);
        if (this.copyOutputBytes) {
            return temp.toBufferWithCopy();
        }
        return temp.toBufferWithoutCopy();
    }

    public void encode(D datum, OutputStream stream) throws IOException {
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder(stream, ENCODER.get());
        ENCODER.set(encoder);
        this.writer.write(datum, (Encoder)encoder);
        encoder.flush();
    }

    private static byte[] getWriteHeader(org.apache.avro.Schema schema) {
        try {
            byte[] fp = SchemaNormalization.parsingFingerprint((String)"CRC-64-AVRO", (org.apache.avro.Schema)schema);
            return Bytes.concat((byte[][])new byte[][]{V1_HEADER, fp});
        }
        catch (NoSuchAlgorithmException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    private static class BufferOutputStream
    extends ByteArrayOutputStream {
        BufferOutputStream() {
        }

        ByteBuffer toBufferWithoutCopy() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }

        ByteBuffer toBufferWithCopy() {
            return ByteBuffer.wrap(this.toByteArray());
        }
    }
}

