/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.data.avro.GenericWriters;

public class DataWriter<T>
implements DatumWriter<T> {
    private ValueWriter<T> writer = null;

    public static <D> DataWriter<D> create(Schema schema) {
        return new DataWriter(schema);
    }

    private DataWriter(Schema schema) {
        this.setSchema(schema);
    }

    public void setSchema(Schema schema) {
        this.writer = (ValueWriter)AvroSchemaVisitor.visit((Schema)schema, (AvroSchemaVisitor)new WriteBuilder());
    }

    public void write(T datum, Encoder out) throws IOException {
        this.writer.write(datum, out);
    }

    private static class WriteBuilder
    extends AvroSchemaVisitor<ValueWriter<?>> {
        private WriteBuilder() {
        }

        public ValueWriter<?> record(Schema record, List<String> names, List<ValueWriter<?>> fields) {
            return GenericWriters.struct(fields);
        }

        public ValueWriter<?> union(Schema union, List<ValueWriter<?>> options) {
            Preconditions.checkArgument((boolean)options.contains(ValueWriters.nulls()), (String)"Cannot create writer for non-option union: %s", (Object)union);
            Preconditions.checkArgument((options.size() == 2 ? 1 : 0) != 0, (String)"Cannot create writer for non-option union: %s", (Object)union);
            if (((Schema)union.getTypes().get(0)).getType() == Schema.Type.NULL) {
                return ValueWriters.option((int)0, options.get(1));
            }
            return ValueWriters.option((int)1, options.get(0));
        }

        public ValueWriter<?> array(Schema array, ValueWriter<?> elementWriter) {
            if (array.getLogicalType() instanceof LogicalMap) {
                ValueWriters.StructWriter keyValueWriter = (ValueWriters.StructWriter)elementWriter;
                return ValueWriters.arrayMap((ValueWriter)keyValueWriter.writer(0), (ValueWriter)keyValueWriter.writer(1));
            }
            return ValueWriters.array(elementWriter);
        }

        public ValueWriter<?> map(Schema map, ValueWriter<?> valueWriter) {
            return ValueWriters.map((ValueWriter)ValueWriters.strings(), valueWriter);
        }

        public ValueWriter<?> primitive(Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return GenericWriters.dates();
                    }
                    case "time-micros": {
                        return GenericWriters.times();
                    }
                    case "timestamp-micros": {
                        if (AvroSchemaUtil.isTimestamptz((Schema)primitive)) {
                            return GenericWriters.timestamptz();
                        }
                        return GenericWriters.timestamps();
                    }
                    case "decimal": {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return ValueWriters.decimal((int)decimal.getPrecision(), (int)decimal.getScale());
                    }
                    case "uuid": {
                        return ValueWriters.uuids();
                    }
                }
                throw new IllegalArgumentException("Unsupported logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueWriters.nulls();
                }
                case BOOLEAN: {
                    return ValueWriters.booleans();
                }
                case INT: {
                    return ValueWriters.ints();
                }
                case LONG: {
                    return ValueWriters.longs();
                }
                case FLOAT: {
                    return ValueWriters.floats();
                }
                case DOUBLE: {
                    return ValueWriters.doubles();
                }
                case STRING: {
                    return ValueWriters.strings();
                }
                case FIXED: {
                    return ValueWriters.fixed((int)primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueWriters.byteBuffers();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

