/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.Parquet;

class TableScanIterable
extends CloseableGroup
implements CloseableIterable<Record> {
    private final TableOperations ops;
    private final Schema projection;
    private final boolean reuseContainers;
    private final boolean caseSensitive;
    private final CloseableIterable<CombinedScanTask> tasks;

    TableScanIterable(TableScan scan, boolean reuseContainers) {
        Preconditions.checkArgument((boolean)(scan.table() instanceof HasTableOperations), (Object)"Cannot scan table that doesn't expose its TableOperations");
        this.ops = ((HasTableOperations)scan.table()).operations();
        this.projection = scan.schema();
        this.reuseContainers = reuseContainers;
        this.caseSensitive = scan.isCaseSensitive();
        this.tasks = scan.planTasks();
    }

    public Iterator<Record> iterator() {
        ScanIterator iter = new ScanIterator(this.tasks, this.caseSensitive);
        this.addCloseable(iter);
        return iter;
    }

    private CloseableIterable<Record> open(FileScanTask task) {
        InputFile input = this.ops.io().newInputFile(task.file().path().toString());
        switch (task.file().format()) {
            case AVRO: {
                Avro.ReadBuilder avro = Avro.read((InputFile)input).project(this.projection).createReaderFunc(DataReader::create).split(task.start(), task.length());
                if (this.reuseContainers) {
                    avro.reuseContainers();
                }
                return avro.build();
            }
            case PARQUET: {
                Parquet.ReadBuilder parquet = Parquet.read((InputFile)input).project(this.projection).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader(this.projection, fileSchema)).split(task.start(), task.length());
                if (this.reuseContainers) {
                    parquet.reuseContainers();
                }
                return parquet.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read %s file: %s", task.file().format().name(), task.file().path()));
    }

    public void close() throws IOException {
        this.tasks.close();
        super.close();
    }

    private class ScanIterator
    implements Iterator<Record>,
    Closeable {
        private final Iterator<FileScanTask> tasks;
        private final boolean caseSensitive;
        private Closeable currentCloseable = null;
        private Iterator<Record> currentIterator = Collections.emptyIterator();

        private ScanIterator(CloseableIterable<CombinedScanTask> tasks, boolean caseSensitive) {
            this.tasks = Lists.newArrayList((Iterable)Iterables.concat((Iterable)CloseableIterable.transform(tasks, CombinedScanTask::files))).iterator();
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                if (!this.tasks.hasNext()) break;
                if (this.currentCloseable != null) {
                    try {
                        this.currentCloseable.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e, "Failed to close task", new Object[0]);
                    }
                }
                FileScanTask task = this.tasks.next();
                CloseableIterable reader = TableScanIterable.this.open(task);
                this.currentCloseable = reader;
                if (task.residual() != null && task.residual() != Expressions.alwaysTrue()) {
                    Evaluator filter = new Evaluator(TableScanIterable.this.projection.asStruct(), task.residual(), this.caseSensitive);
                    this.currentIterator = Iterables.filter((Iterable)reader, arg_0 -> ((Evaluator)filter).eval(arg_0)).iterator();
                    continue;
                }
                this.currentIterator = reader.iterator();
            }
            return false;
        }

        @Override
        public Record next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }

        @Override
        public void close() throws IOException {
            if (this.currentCloseable != null) {
                this.currentCloseable.close();
            }
        }
    }
}

