/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.aws.s3.VendedCredentialsProvider;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializableMap;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;

public class AwsClientProperties
implements Serializable {
    public static final String CLIENT_CREDENTIALS_PROVIDER = "client.credentials-provider";
    protected static final String CLIENT_CREDENTIAL_PROVIDER_PREFIX = "client.credentials-provider.";
    public static final String CLIENT_REGION = "client.region";
    public static final String REFRESH_CREDENTIALS_ENDPOINT = "client.refresh-credentials-endpoint";
    public static final String REFRESH_CREDENTIALS_ENABLED = "client.refresh-credentials-enabled";
    private String clientRegion;
    private final String clientCredentialsProvider;
    private final Map<String, String> clientCredentialsProviderProperties;
    private final String refreshCredentialsEndpoint;
    private final boolean refreshCredentialsEnabled;
    private final Map<String, String> allProperties;

    public AwsClientProperties() {
        this.clientRegion = null;
        this.clientCredentialsProvider = null;
        this.clientCredentialsProviderProperties = null;
        this.refreshCredentialsEndpoint = null;
        this.refreshCredentialsEnabled = true;
        this.allProperties = null;
    }

    public AwsClientProperties(Map<String, String> properties) {
        this.allProperties = SerializableMap.copyOf(properties);
        this.clientRegion = properties.get(CLIENT_REGION);
        this.clientCredentialsProvider = properties.get(CLIENT_CREDENTIALS_PROVIDER);
        this.clientCredentialsProviderProperties = PropertyUtil.propertiesWithPrefix(properties, (String)CLIENT_CREDENTIAL_PROVIDER_PREFIX);
        this.refreshCredentialsEndpoint = RESTUtil.resolveEndpoint((String)properties.get("uri"), (String)properties.get(REFRESH_CREDENTIALS_ENDPOINT));
        this.refreshCredentialsEnabled = PropertyUtil.propertyAsBoolean(properties, (String)REFRESH_CREDENTIALS_ENABLED, (boolean)true);
    }

    public String clientRegion() {
        return this.clientRegion;
    }

    public void setClientRegion(String clientRegion) {
        this.clientRegion = clientRegion;
    }

    public <T extends AwsClientBuilder> void applyClientRegionConfiguration(T builder) {
        if (this.clientRegion != null) {
            builder.region(Region.of((String)this.clientRegion));
        }
    }

    public <T extends AwsClientBuilder> void applyClientCredentialConfigurations(T builder) {
        if (!Strings.isNullOrEmpty((String)this.clientCredentialsProvider)) {
            builder.credentialsProvider(this.credentialsProvider(this.clientCredentialsProvider));
        }
    }

    public AwsCredentialsProvider credentialsProvider(String accessKeyId, String secretAccessKey, String sessionToken) {
        if (this.refreshCredentialsEnabled && !Strings.isNullOrEmpty((String)this.refreshCredentialsEndpoint)) {
            this.clientCredentialsProviderProperties.put("credentials.uri", this.refreshCredentialsEndpoint);
            Optional.ofNullable(this.allProperties.get("token")).ifPresent(token -> this.clientCredentialsProviderProperties.putIfAbsent("token", (String)token));
            return this.credentialsProvider(VendedCredentialsProvider.class.getName());
        }
        if (!Strings.isNullOrEmpty((String)accessKeyId) && !Strings.isNullOrEmpty((String)secretAccessKey)) {
            if (Strings.isNullOrEmpty((String)sessionToken)) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)sessionToken));
        }
        if (!Strings.isNullOrEmpty((String)this.clientCredentialsProvider)) {
            return this.credentialsProvider(this.clientCredentialsProvider);
        }
        return DefaultCredentialsProvider.builder().build();
    }

    private AwsCredentialsProvider credentialsProvider(String credentialsProviderClass) {
        Class providerClass;
        try {
            providerClass = DynClasses.builder().impl(credentialsProviderClass).buildChecked();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Cannot load class %s, it does not exist in the classpath", credentialsProviderClass), e);
        }
        Preconditions.checkArgument((boolean)AwsCredentialsProvider.class.isAssignableFrom(providerClass), (Object)String.format("Cannot initialize %s, it does not implement %s.", credentialsProviderClass, AwsCredentialsProvider.class.getName()));
        try {
            return this.createCredentialsProvider(providerClass);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot create an instance of %s, it does not contain a static 'create' or 'create(Map<String, String>)' method", credentialsProviderClass), e);
        }
    }

    private AwsCredentialsProvider createCredentialsProvider(Class<?> providerClass) throws NoSuchMethodException {
        AwsCredentialsProvider provider;
        try {
            provider = (AwsCredentialsProvider)DynMethods.builder((String)"create").hiddenImpl(providerClass, new Class[]{Map.class}).buildStaticChecked().invoke(new Object[]{this.clientCredentialsProviderProperties});
        }
        catch (NoSuchMethodException e) {
            provider = (AwsCredentialsProvider)DynMethods.builder((String)"create").hiddenImpl(providerClass, new Class[0]).buildStaticChecked().invoke(new Object[0]);
        }
        return provider;
    }
}

