/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.glue;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.LockManager;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.glue.GlueTableOperations;
import org.apache.iceberg.aws.glue.GlueToIcebergConverter;
import org.apache.iceberg.aws.glue.IcebergToGlueConverter;
import org.apache.iceberg.aws.lakeformation.LakeFormationAwsClientFactory;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.LockManagers;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.InvalidInputException;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;

public class GlueCatalog
extends BaseMetastoreCatalog
implements Closeable,
SupportsNamespaces,
Configurable<Configuration> {
    private static final Logger LOG = LoggerFactory.getLogger(GlueCatalog.class);
    private GlueClient glue;
    private Object hadoopConf;
    private String catalogName;
    private String warehousePath;
    private AwsProperties awsProperties;
    private FileIO fileIO;
    private LockManager lockManager;
    private CloseableGroup closeableGroup;
    private Map<String, String> catalogProperties;
    private static final DynMethods.UnboundMethod SET_VERSION_ID = DynMethods.builder((String)"versionId").hiddenImpl("software.amazon.awssdk.services.glue.model.UpdateTableRequest$Builder", new Class[]{String.class}).orNoop().build();

    public void initialize(String name, Map<String, String> properties) {
        FileIO catalogFileIO;
        AwsClientFactory awsClientFactory;
        this.catalogProperties = ImmutableMap.copyOf(properties);
        if (PropertyUtil.propertyAsBoolean(properties, (String)"glue.lakeformation-enabled", (boolean)false)) {
            String factoryImpl = PropertyUtil.propertyAsString(properties, (String)"client.factory", null);
            ImmutableMap.Builder builder = ImmutableMap.builder().putAll(properties);
            if (factoryImpl == null) {
                builder.put((Object)"client.factory", (Object)LakeFormationAwsClientFactory.class.getName());
            }
            this.catalogProperties = builder.buildOrThrow();
            awsClientFactory = AwsClientFactories.from(this.catalogProperties);
            Preconditions.checkArgument((boolean)(awsClientFactory instanceof LakeFormationAwsClientFactory), (String)"Detected LakeFormation enabled for Glue catalog, should use a client factory that extends %s, but found %s", (Object)LakeFormationAwsClientFactory.class.getName(), (Object)factoryImpl);
            catalogFileIO = null;
        } else {
            awsClientFactory = AwsClientFactories.from(properties);
            catalogFileIO = GlueTableOperations.initializeFileIO(properties, this.hadoopConf);
        }
        this.initialize(name, properties.get("warehouse"), new AwsProperties(properties), awsClientFactory.glue(), this.initializeLockManager(properties), catalogFileIO);
    }

    private LockManager initializeLockManager(Map<String, String> properties) {
        if (properties.containsKey("lock-impl")) {
            return LockManagers.from(properties);
        }
        if (SET_VERSION_ID.isNoop()) {
            LOG.warn("Optimistic locking is not available in the environment. Using in-memory lock manager. To ensure atomic transaction, please configure a distributed lock manager such as the DynamoDB lock manager.");
            return LockManagers.defaultLockManager();
        }
        LOG.debug("Using optimistic locking for Glue Data Catalog tables.");
        return null;
    }

    @VisibleForTesting
    void initialize(String name, String path, AwsProperties properties, GlueClient client, LockManager lock, FileIO io, Map<String, String> catalogProps) {
        this.catalogProperties = catalogProps;
        this.initialize(name, path, properties, client, lock, io);
    }

    @VisibleForTesting
    void initialize(String name, String path, AwsProperties properties, GlueClient client, LockManager lock, FileIO io) {
        this.catalogName = name;
        this.awsProperties = properties;
        this.warehousePath = path != null && path.length() > 0 ? LocationUtil.stripTrailingSlash((String)path) : null;
        this.glue = client;
        this.lockManager = lock;
        this.fileIO = io;
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable((AutoCloseable)this.glue);
        this.closeableGroup.addCloseable((AutoCloseable)this.lockManager);
        this.closeableGroup.addCloseable((Closeable)this.fileIO);
        this.closeableGroup.setSuppressCloseFailure(true);
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        if (this.catalogProperties != null) {
            ImmutableMap.Builder tableSpecificCatalogPropertiesBuilder = ImmutableMap.builder().putAll(this.catalogProperties);
            boolean skipNameValidation = this.awsProperties.glueCatalogSkipNameValidation();
            if (this.awsProperties.s3WriteTableTagEnabled()) {
                tableSpecificCatalogPropertiesBuilder.put((Object)"s3.write.tags.".concat("iceberg.table"), (Object)IcebergToGlueConverter.getTableName(tableIdentifier, skipNameValidation));
            }
            if (this.awsProperties.s3WriteNamespaceTagEnabled()) {
                tableSpecificCatalogPropertiesBuilder.put((Object)"s3.write.tags.".concat("iceberg.namespace"), (Object)IcebergToGlueConverter.getDatabaseName(tableIdentifier, skipNameValidation));
            }
            if (this.awsProperties.glueLakeFormationEnabled()) {
                tableSpecificCatalogPropertiesBuilder.put((Object)"lakeformation.db-name", (Object)IcebergToGlueConverter.getDatabaseName(tableIdentifier, skipNameValidation)).put((Object)"lakeformation.table-name", (Object)IcebergToGlueConverter.getTableName(tableIdentifier, skipNameValidation)).put((Object)"s3.preload-client-enabled", (Object)String.valueOf(true));
            }
            return new GlueTableOperations(this.glue, this.lockManager, this.catalogName, this.awsProperties, (Map<String, String>)tableSpecificCatalogPropertiesBuilder.buildOrThrow(), this.hadoopConf, tableIdentifier);
        }
        return new GlueTableOperations(this.glue, this.lockManager, this.catalogName, this.awsProperties, this.catalogProperties, this.hadoopConf, tableIdentifier);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        GetDatabaseResponse response = this.glue.getDatabase((GetDatabaseRequest)GetDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(IcebergToGlueConverter.getDatabaseName(tableIdentifier, this.awsProperties.glueCatalogSkipNameValidation())).build());
        String dbLocationUri = response.database().locationUri();
        if (dbLocationUri != null) {
            return String.format("%s/%s", dbLocationUri, tableIdentifier.name());
        }
        ValidationException.check((this.warehousePath != null && this.warehousePath.length() > 0 ? 1 : 0) != 0, (String)"Cannot derive default warehouse location, warehouse path must not be null or empty", (Object[])new Object[0]);
        return String.format("%s/%s.db/%s", this.warehousePath, IcebergToGlueConverter.getDatabaseName(tableIdentifier, this.awsProperties.glueCatalogSkipNameValidation()), tableIdentifier.name());
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        this.namespaceExists(namespace);
        String nextToken = null;
        ArrayList results = Lists.newArrayList();
        do {
            GetTablesResponse response = this.glue.getTables((GetTablesRequest)GetTablesRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).nextToken(nextToken).build());
            nextToken = response.nextToken();
            if (!response.hasTableList()) continue;
            results.addAll(response.tableList().stream().filter(this::isGlueIcebergTable).map(GlueToIcebergConverter::toTableId).collect(Collectors.toList()));
        } while (nextToken != null);
        LOG.debug("Listing of namespace: {} resulted in the following tables: {}", (Object)namespace, (Object)results);
        return results;
    }

    private boolean isGlueIcebergTable(Table table) {
        return table.parameters() != null && "iceberg".equalsIgnoreCase((String)table.parameters().get("table_type"));
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        try {
            TableOperations ops = this.newTableOps(identifier);
            TableMetadata lastMetadata = null;
            if (purge) {
                try {
                    lastMetadata = ops.current();
                }
                catch (NotFoundException e) {
                    LOG.warn("Failed to load table metadata for table: {}, continuing drop without purge", (Object)identifier, (Object)e);
                }
            }
            this.glue.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(IcebergToGlueConverter.getDatabaseName(identifier, this.awsProperties.glueCatalogSkipNameValidation())).name(identifier.name()).build());
            LOG.info("Successfully dropped table {} from Glue", (Object)identifier);
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData((FileIO)ops.io(), (TableMetadata)lastMetadata);
                LOG.info("Glue table {} data purged", (Object)identifier);
            }
            LOG.info("Dropped table: {}", (Object)identifier);
            return true;
        }
        catch (EntityNotFoundException e) {
            LOG.error("Cannot drop table {} because table not found or not accessible", (Object)identifier, (Object)e);
            return false;
        }
        catch (Exception e) {
            LOG.error("Cannot complete drop table operation for {} due to unexpected exception", (Object)identifier, (Object)e);
            throw e;
        }
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        if (!this.namespaceExists(to.namespace())) {
            throw new NoSuchNamespaceException("Cannot rename %s to %s because namespace %s does not exist", new Object[]{from, to, to.namespace()});
        }
        Table fromTable = null;
        String fromTableDbName = IcebergToGlueConverter.getDatabaseName(from, this.awsProperties.glueCatalogSkipNameValidation());
        String fromTableName = IcebergToGlueConverter.getTableName(from, this.awsProperties.glueCatalogSkipNameValidation());
        String toTableDbName = IcebergToGlueConverter.getDatabaseName(to, this.awsProperties.glueCatalogSkipNameValidation());
        String toTableName = IcebergToGlueConverter.getTableName(to, this.awsProperties.glueCatalogSkipNameValidation());
        try {
            GetTableResponse response = this.glue.getTable((GetTableRequest)GetTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(fromTableDbName).name(fromTableName).build());
            fromTable = response.table();
        }
        catch (EntityNotFoundException e) {
            throw new NoSuchTableException((Throwable)e, "Cannot rename %s because the table does not exist in Glue", new Object[]{from});
        }
        TableInput.Builder tableInputBuilder = TableInput.builder().owner(fromTable.owner()).tableType(fromTable.tableType()).parameters(fromTable.parameters()).storageDescriptor(fromTable.storageDescriptor());
        this.glue.createTable((CreateTableRequest)CreateTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(toTableDbName).tableInput((TableInput)tableInputBuilder.name(toTableName).build()).build());
        LOG.info("created rename destination table {}", (Object)to);
        try {
            this.dropTable(from, false);
        }
        catch (Exception e) {
            LOG.error("Fail to drop old table {} after renaming to {}, rollback to use the old table", new Object[]{from, to, e});
            this.glue.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(toTableDbName).name(toTableName).build());
            throw e;
        }
        LOG.info("Successfully renamed table from {} to {}", (Object)from, (Object)to);
    }

    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
        try {
            this.glue.createDatabase((CreateDatabaseRequest)CreateDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseInput(IcebergToGlueConverter.toDatabaseInput(namespace, metadata, this.awsProperties.glueCatalogSkipNameValidation())).build());
            LOG.info("Created namespace: {}", (Object)namespace);
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException("Cannot create namespace %s because it already exists in Glue", new Object[]{namespace});
        }
    }

    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        if (!namespace.isEmpty()) {
            if (this.namespaceExists(namespace)) {
                return Lists.newArrayList();
            }
            throw new NoSuchNamespaceException("Glue does not support nested namespace, cannot list namespaces under %s", new Object[]{namespace});
        }
        String nextToken = null;
        ArrayList results = Lists.newArrayList();
        do {
            GetDatabasesResponse response = this.glue.getDatabases((GetDatabasesRequest)GetDatabasesRequest.builder().catalogId(this.awsProperties.glueCatalogId()).nextToken(nextToken).build());
            nextToken = response.nextToken();
            if (!response.hasDatabaseList()) continue;
            results.addAll(response.databaseList().stream().map(GlueToIcebergConverter::toNamespace).collect(Collectors.toList()));
        } while (nextToken != null);
        LOG.debug("Listing namespace {} returned namespaces: {}", (Object)namespace, (Object)results);
        return results;
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        String databaseName = IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation());
        try {
            Database database = this.glue.getDatabase((GetDatabaseRequest)GetDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(databaseName).build()).database();
            HashMap result = Maps.newHashMap((Map)database.parameters());
            if (database.locationUri() != null) {
                result.put("location", database.locationUri());
            }
            if (database.description() != null) {
                result.put("comment", database.description());
            }
            LOG.debug("Loaded metadata for namespace {} found {}", (Object)namespace, (Object)result);
            return result;
        }
        catch (InvalidInputException e) {
            throw new NoSuchNamespaceException("invalid input for namespace %s, error message: %s", new Object[]{namespace, e.getMessage()});
        }
        catch (EntityNotFoundException e) {
            throw new NoSuchNamespaceException("fail to find Glue database for namespace %s, error message: %s", new Object[]{databaseName, e.getMessage()});
        }
    }

    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        this.namespaceExists(namespace);
        GetTablesResponse response = this.glue.getTables((GetTablesRequest)GetTablesRequest.builder().catalogId(this.awsProperties.glueCatalogId()).databaseName(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).build());
        if (response.hasTableList() && !response.tableList().isEmpty()) {
            Table table = (Table)response.tableList().get(0);
            if (this.isGlueIcebergTable(table)) {
                throw new NamespaceNotEmptyException("Cannot drop namespace %s because it still contains Iceberg tables", new Object[]{namespace});
            }
            throw new NamespaceNotEmptyException("Cannot drop namespace %s because it still contains non-Iceberg tables", new Object[]{namespace});
        }
        this.glue.deleteDatabase((DeleteDatabaseRequest)DeleteDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).build());
        LOG.info("Dropped namespace: {}", (Object)namespace);
        return true;
    }

    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        HashMap newProperties = Maps.newHashMap();
        newProperties.putAll(this.loadNamespaceMetadata(namespace));
        newProperties.putAll(properties);
        this.glue.updateDatabase((UpdateDatabaseRequest)UpdateDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).databaseInput(IcebergToGlueConverter.toDatabaseInput(namespace, newProperties, this.awsProperties.glueCatalogSkipNameValidation())).build());
        LOG.debug("Successfully set properties {} for {}", properties.keySet(), (Object)namespace);
        return true;
    }

    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        HashMap metadata = Maps.newHashMap(this.loadNamespaceMetadata(namespace));
        for (String property : properties) {
            metadata.remove(property);
        }
        this.glue.updateDatabase((UpdateDatabaseRequest)UpdateDatabaseRequest.builder().catalogId(this.awsProperties.glueCatalogId()).name(IcebergToGlueConverter.toDatabaseName(namespace, this.awsProperties.glueCatalogSkipNameValidation())).databaseInput(IcebergToGlueConverter.toDatabaseInput(namespace, metadata, this.awsProperties.glueCatalogSkipNameValidation())).build());
        LOG.debug("Successfully removed properties {} from {}", properties, (Object)namespace);
        return true;
    }

    protected boolean isValidIdentifier(TableIdentifier tableIdentifier) {
        if (this.awsProperties.glueCatalogSkipNameValidation()) {
            return true;
        }
        return IcebergToGlueConverter.isValidNamespace(tableIdentifier.namespace()) && IcebergToGlueConverter.isValidTableName(tableIdentifier.name());
    }

    public String name() {
        return this.catalogName;
    }

    @Override
    public void close() throws IOException {
        this.closeableGroup.close();
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = conf;
    }

    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }
}

