/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.iterator;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.hugegraph.iterator.WrappedIterator;

public class MapperIterator<T, R>
extends WrappedIterator<R> {
    private final Iterator<T> originIterator;
    private final Function<T, R> mapperCallback;

    public MapperIterator(Iterator<T> origin, Function<T, R> mapper) {
        this.originIterator = origin;
        this.mapperCallback = mapper;
    }

    @Override
    protected Iterator<T> originIterator() {
        return this.originIterator;
    }

    @Override
    protected final boolean fetch() {
        while (this.originIterator.hasNext()) {
            T next = this.originIterator.next();
            R result = this.mapperCallback.apply(next);
            if (result == null) continue;
            assert (this.current == MapperIterator.none());
            this.current = result;
            return true;
        }
        return false;
    }
}

