/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.util.E;

public class ConfigListOption<T>
extends ConfigOption<List<T>> {
    private final Class<T> elemClass;

    public ConfigListOption(String name, String desc, Predicate<List<T>> pred, T ... values) {
        this(name, false, desc, pred, (Class<T>)null, Arrays.asList(values));
    }

    public ConfigListOption(String name, boolean required, String desc, Predicate<List<T>> pred, Class<T> clazz, List<T> values) {
        super(name, required, desc, pred, values.getClass(), values);
        if (clazz == null && values.size() > 0) {
            clazz = values.get(0).getClass();
        }
        E.checkArgumentNotNull(clazz, "Element class can't be null", new Object[0]);
        this.elemClass = clazz;
    }

    @Override
    protected boolean forList() {
        return true;
    }

    @Override
    protected List<T> parse(String value) {
        return ConfigListOption.convert(value, part -> this.parse((String)part, this.elemClass));
    }

    public static <T> List<T> convert(Object value, Function<String, ?> conv) {
        if (value instanceof List) {
            return (List)value;
        }
        String str = (String)value;
        if (str.startsWith("[") && str.endsWith("]")) {
            str = str.substring(1, str.length() - 1);
        }
        String[] parts = str.split(",");
        ArrayList results = new ArrayList(parts.length);
        for (String part : parts) {
            results.add(conv.apply(part.trim()));
        }
        return results;
    }
}

