/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;

public abstract class AbstractClientConnAdapter
implements ManagedClientConnection {
    protected ClientConnectionManager connManager;
    protected OperatedClientConnection wrappedConnection;
    protected boolean markedReusable;

    protected AbstractClientConnAdapter(ClientConnectionManager mgr, OperatedClientConnection conn) {
        this.connManager = mgr;
        this.wrappedConnection = conn;
        this.markedReusable = false;
    }

    protected final void assertWrappedConn() {
        if (this.wrappedConnection == null) {
            throw new IllegalStateException("No wrapped connection.");
        }
    }

    public boolean isOpen() {
        if (this.wrappedConnection == null) {
            return false;
        }
        return this.wrappedConnection.isOpen();
    }

    public boolean isStale() {
        if (this.wrappedConnection == null) {
            return true;
        }
        return this.wrappedConnection.isStale();
    }

    public void setSocketTimeout(int timeout) {
        this.assertWrappedConn();
        this.wrappedConnection.setSocketTimeout(timeout);
    }

    public int getSocketTimeout() {
        this.assertWrappedConn();
        return this.wrappedConnection.getSocketTimeout();
    }

    public HttpConnectionMetrics getMetrics() {
        this.assertWrappedConn();
        return this.wrappedConnection.getMetrics();
    }

    public void flush() throws IOException {
        this.assertWrappedConn();
        this.wrappedConnection.flush();
    }

    public boolean isResponseAvailable(int timeout) throws IOException {
        this.assertWrappedConn();
        return this.wrappedConnection.isResponseAvailable(timeout);
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        this.assertWrappedConn();
        this.markedReusable = false;
        this.wrappedConnection.receiveResponseEntity(response);
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.assertWrappedConn();
        this.markedReusable = false;
        return this.wrappedConnection.receiveResponseHeader();
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        this.assertWrappedConn();
        this.markedReusable = false;
        this.wrappedConnection.sendRequestEntity(request);
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        this.assertWrappedConn();
        this.markedReusable = false;
        this.wrappedConnection.sendRequestHeader(request);
    }

    public InetAddress getLocalAddress() {
        this.assertWrappedConn();
        return this.wrappedConnection.getLocalAddress();
    }

    public int getLocalPort() {
        this.assertWrappedConn();
        return this.wrappedConnection.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        this.assertWrappedConn();
        return this.wrappedConnection.getRemoteAddress();
    }

    public int getRemotePort() {
        this.assertWrappedConn();
        return this.wrappedConnection.getRemotePort();
    }

    public boolean isSecure() {
        this.assertWrappedConn();
        return this.wrappedConnection.isSecure();
    }

    public SSLSession getSSLSession() {
        if (!this.isOpen()) {
            return null;
        }
        SSLSession result = null;
        Socket sock = this.wrappedConnection.getSocket();
        if (sock instanceof SSLSocket) {
            result = ((SSLSocket)sock).getSession();
        }
        return result;
    }

    public void markReusable() {
        this.markedReusable = true;
    }

    public void unmarkReusable() {
        this.markedReusable = false;
    }

    public boolean isMarkedReusable() {
        return this.markedReusable;
    }

    public void releaseConnection() {
        if (this.connManager != null) {
            this.connManager.releaseConnection(this);
        }
    }

    public void abortConnection() {
        this.unmarkReusable();
        if (this.connManager != null) {
            this.connManager.releaseConnection(this);
        }
    }
}

