/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.impl.client.cache.AsynchronousValidator;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.protocol.HttpContext;

public class AsynchronousValidationRequest
implements Runnable {
    private final AsynchronousValidator parent;
    private final CachingHttpClient cachingClient;
    private final HttpHost target;
    private final HttpRequest request;
    private final HttpContext context;
    private final HttpCacheEntry cacheEntry;
    private final String identifier;
    private final int consecutiveFailedAttempts;
    private final Log log = LogFactory.getLog(this.getClass());

    AsynchronousValidationRequest(AsynchronousValidator parent, CachingHttpClient cachingClient, HttpHost target, HttpRequest request, HttpContext context, HttpCacheEntry cacheEntry, String identifier, int consecutiveFailedAttempts) {
        this.parent = parent;
        this.cachingClient = cachingClient;
        this.target = target;
        this.request = request;
        this.context = context;
        this.cacheEntry = cacheEntry;
        this.identifier = identifier;
        this.consecutiveFailedAttempts = consecutiveFailedAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.revalidateCacheEntry()) {
                this.parent.jobSuccessful(this.identifier);
            } else {
                this.parent.jobFailed(this.identifier);
            }
        }
        finally {
            this.parent.markComplete(this.identifier);
        }
    }

    protected boolean revalidateCacheEntry() {
        try {
            HttpResponse httpResponse = this.cachingClient.revalidateCacheEntry(this.target, this.request, this.context, this.cacheEntry);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            return this.isNotServerError(statusCode) && this.isNotStale(httpResponse);
        }
        catch (IOException ioe) {
            this.log.debug((Object)("Asynchronous revalidation failed due to exception: " + ioe));
            return false;
        }
        catch (ProtocolException pe) {
            this.log.error((Object)("ProtocolException thrown during asynchronous revalidation: " + (Object)((Object)pe)));
            return false;
        }
        catch (RuntimeException re) {
            this.log.error((Object)("RuntimeException thrown during asynchronous revalidation: " + re));
            return false;
        }
    }

    private boolean isNotServerError(int statusCode) {
        return statusCode < 500;
    }

    private boolean isNotStale(HttpResponse httpResponse) {
        Header[] warnings = httpResponse.getHeaders("Warning");
        if (warnings != null) {
            for (Header warning : warnings) {
                if (!warning.getValue().contains("Response is stale")) continue;
                return false;
            }
        }
        return true;
    }

    String getIdentifier() {
        return this.identifier;
    }

    public int getConsecutiveFailedAttempts() {
        return this.consecutiveFailedAttempts;
    }
}

