/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.conn.AsyncSchemeRegistryFactory;
import org.apache.http.impl.nio.conn.HttpNIOConnPool;
import org.apache.http.impl.nio.conn.HttpPoolEntry;
import org.apache.http.impl.nio.conn.ManagedAsyncClientConnectionImpl;
import org.apache.http.nio.conn.ClientAsyncConnectionManager;
import org.apache.http.nio.conn.ManagedAsyncClientConnection;
import org.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingAsyncClientConnectionManager
implements ClientAsyncConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConnectingIOReactor ioreactor;
    private final HttpNIOConnPool pool;
    private final AsyncSchemeRegistry schemeRegistry;

    public PoolingAsyncClientConnectionManager(ConnectingIOReactor ioreactor, AsyncSchemeRegistry schemeRegistry, long timeToLive, TimeUnit tunit) {
        if (ioreactor == null) {
            throw new IllegalArgumentException("I/O reactor may not be null");
        }
        if (schemeRegistry == null) {
            throw new IllegalArgumentException("Scheme registory may not be null");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null");
        }
        this.ioreactor = ioreactor;
        this.pool = new HttpNIOConnPool(this.log, ioreactor, schemeRegistry, timeToLive, tunit);
        this.schemeRegistry = schemeRegistry;
    }

    public PoolingAsyncClientConnectionManager(ConnectingIOReactor ioreactor, AsyncSchemeRegistry schemeRegistry) throws IOReactorException {
        this(ioreactor, schemeRegistry, -1L, TimeUnit.MILLISECONDS);
    }

    public PoolingAsyncClientConnectionManager(ConnectingIOReactor ioreactor) throws IOReactorException {
        this(ioreactor, AsyncSchemeRegistryFactory.createDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public AsyncSchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    public void execute(IOEventDispatch eventDispatch) throws IOException {
        this.ioreactor.execute(eventDispatch);
    }

    public IOReactorStatus getStatus() {
        return this.ioreactor.getStatus();
    }

    public void shutdown(long waitMs) throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(waitMs);
        this.log.debug((Object)"Connection manager shut down");
    }

    public void shutdown() throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(2000L);
        this.log.debug((Object)"Connection manager shut down");
    }

    private String format(HttpRoute route, Object state) {
        StringBuilder buf = new StringBuilder();
        buf.append("[route: ").append(route).append("]");
        if (state != null) {
            buf.append("[state: ").append(state).append("]");
        }
        return buf.toString();
    }

    private String formatStats(HttpRoute route) {
        StringBuilder buf = new StringBuilder();
        PoolStats totals = this.pool.getTotalStats();
        PoolStats stats = this.pool.getStats(route);
        buf.append("[total kept alive: ").append(totals.getAvailable()).append("; ");
        buf.append("route allocated: ").append(stats.getLeased() + stats.getAvailable());
        buf.append(" of ").append(stats.getMax()).append("; ");
        buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
        buf.append(" of ").append(totals.getMax()).append("]");
        return buf.toString();
    }

    private String format(HttpPoolEntry entry) {
        StringBuilder buf = new StringBuilder();
        buf.append("[id: ").append(entry.getId()).append("]");
        buf.append("[route: ").append(entry.getRoute()).append("]");
        Object state = entry.getState();
        if (state != null) {
            buf.append("[state: ").append(state).append("]");
        }
        return buf.toString();
    }

    @Override
    public Future<ManagedAsyncClientConnection> leaseConnection(HttpRoute route, Object state, long connectTimeout, TimeUnit tunit, FutureCallback<ManagedAsyncClientConnection> callback) {
        if (route == null) {
            throw new IllegalArgumentException("HTTP route may not be null");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request: " + this.format(route, state) + this.formatStats(route)));
        }
        BasicFuture future = new BasicFuture(callback);
        this.pool.lease(route, state, connectTimeout, tunit, new InternalPoolEntryCallback((BasicFuture<ManagedAsyncClientConnection>)future));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(ManagedAsyncClientConnection conn, long keepalive, TimeUnit tunit) {
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (!(conn instanceof ManagedAsyncClientConnectionImpl)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null");
        }
        ManagedAsyncClientConnectionImpl managedConn = (ManagedAsyncClientConnectionImpl)conn;
        ClientAsyncConnectionManager manager = managedConn.getManager();
        if (manager != null && manager != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager");
        }
        if (this.pool.isShutdown()) {
            return;
        }
        ManagedAsyncClientConnectionImpl managedAsyncClientConnectionImpl = managedConn;
        synchronized (managedAsyncClientConnectionImpl) {
            HttpPoolEntry entry = managedConn.detach();
            if (entry == null) {
                return;
            }
            try {
                block17: {
                    if (managedConn.isOpen() && !managedConn.isMarkedReusable()) {
                        try {
                            managedConn.shutdown();
                        }
                        catch (IOException iox) {
                            if (!this.log.isDebugEnabled()) break block17;
                            this.log.debug((Object)"I/O exception shutting down released connection", (Throwable)iox);
                        }
                    }
                }
                entry.updateExpiry(keepalive, tunit != null ? tunit : TimeUnit.MILLISECONDS);
                if (this.log.isDebugEnabled()) {
                    String s = keepalive > 0L ? "for " + keepalive + " " + (Object)((Object)tunit) : "indefinitely";
                    this.log.debug((Object)("Connection " + this.format(entry) + " can be kept alive " + s));
                }
            }
            finally {
                this.pool.release(entry, managedConn.isMarkedReusable());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection released: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
            }
        }
    }

    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    public PoolStats getStats(HttpRoute route) {
        return this.pool.getStats(route);
    }

    @Deprecated
    public void setTotalMax(int max) {
        this.pool.setMaxTotal(max);
    }

    public void setMaxTotal(int max) {
        this.pool.setMaxTotal(max);
    }

    @Deprecated
    public void setDefaultMaxPerHost(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    public void setDefaultMaxPerRoute(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    @Deprecated
    public void setMaxPerHost(HttpRoute route, int max) {
        this.pool.setMaxPerRoute(route, max);
    }

    public void setMaxPerRoute(HttpRoute route, int max) {
        this.pool.setMaxPerRoute(route, max);
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    public int getMaxPerRoute(HttpRoute route) {
        return this.pool.getMaxPerRoute(route);
    }

    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + idleTimeout + " " + (Object)((Object)tunit)));
        }
        this.pool.closeIdle(idleTimeout, tunit);
    }

    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpired();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InternalPoolEntryCallback
    implements FutureCallback<HttpPoolEntry> {
        private final BasicFuture<ManagedAsyncClientConnection> future;

        public InternalPoolEntryCallback(BasicFuture<ManagedAsyncClientConnection> future) {
            this.future = future;
        }

        public void completed(HttpPoolEntry entry) {
            ManagedAsyncClientConnectionImpl conn;
            if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingAsyncClientConnectionManager.this.log.debug((Object)("Connection leased: " + PoolingAsyncClientConnectionManager.this.format(entry) + PoolingAsyncClientConnectionManager.this.formatStats((HttpRoute)entry.getRoute())));
            }
            if (!this.future.completed((Object)(conn = new ManagedAsyncClientConnectionImpl(PoolingAsyncClientConnectionManager.this, entry)))) {
                PoolingAsyncClientConnectionManager.this.pool.release(entry, true);
            }
        }

        public void failed(Exception ex) {
            if (PoolingAsyncClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingAsyncClientConnectionManager.this.log.debug((Object)"Connection request failed", (Throwable)ex);
            }
            this.future.failed(ex);
        }

        public void cancelled() {
            PoolingAsyncClientConnectionManager.this.log.debug((Object)"Connection request cancelled");
            this.future.cancel(true);
        }
    }
}

