/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.pool;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.impl.nio.pool.LeaseRequest;
import org.apache.http.impl.nio.pool.PoolEntry;
import org.apache.http.impl.nio.pool.PoolEntryCallback;
import org.apache.http.impl.nio.pool.PoolEntryFactory;
import org.apache.http.impl.nio.pool.RouteResolver;
import org.apache.http.impl.nio.pool.RouteSpecificPool;
import org.apache.http.nio.conn.PoolStats;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionPool<T, E extends PoolEntry<T>> {
    private final ConnectingIOReactor ioreactor;
    private final PoolEntryFactory<T, E> factory;
    private final SessionRequestCallback sessionRequestCallback;
    private final RouteResolver<T> routeResolver;
    private final Map<T, RouteSpecificPool<T, E>> routeToPool;
    private final LinkedList<LeaseRequest<T, E>> leasingRequests;
    private final Set<SessionRequest> pendingSessions;
    private final Set<PoolEntry<T>> leasedSessions;
    private final LinkedList<E> availableSessions;
    private final Map<T, Integer> maxPerRoute;
    private final Lock lock;
    private volatile boolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;

    public SessionPool(ConnectingIOReactor ioreactor, PoolEntryFactory<T, E> factory, RouteResolver<T> routeResolver, int defaultMaxPerRoute, int maxTotal) {
        if (ioreactor == null) {
            throw new IllegalArgumentException("I/O reactor may not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Pool entry factory may not be null");
        }
        if (routeResolver == null) {
            throw new IllegalArgumentException("Route resolver may not be null");
        }
        if (defaultMaxPerRoute <= 0) {
            throw new IllegalArgumentException("Max per route value may not be negative or zero");
        }
        if (maxTotal <= 0) {
            throw new IllegalArgumentException("Max total value may not be negative or zero");
        }
        this.ioreactor = ioreactor;
        this.factory = factory;
        this.sessionRequestCallback = new InternalSessionRequestCallback();
        this.routeResolver = routeResolver;
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, E>>();
        this.leasingRequests = new LinkedList();
        this.pendingSessions = new HashSet<SessionRequest>();
        this.leasedSessions = new HashSet<PoolEntry<T>>();
        this.availableSessions = new LinkedList();
        this.maxPerRoute = new HashMap<T, Integer>();
        this.lock = new ReentrantLock();
        this.defaultMaxPerRoute = defaultMaxPerRoute;
        this.maxTotal = maxTotal;
    }

    public boolean isShutdown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long waitMs) throws IOException {
        if (this.isShutDown) {
            return;
        }
        this.isShutDown = true;
        this.lock.lock();
        try {
            for (RouteSpecificPool<T, E> pool : this.routeToPool.values()) {
                pool.shutdown();
            }
            this.routeToPool.clear();
            this.leasedSessions.clear();
            this.pendingSessions.clear();
            this.availableSessions.clear();
            this.leasingRequests.clear();
            this.ioreactor.shutdown(waitMs);
        }
        finally {
            this.lock.unlock();
        }
    }

    private RouteSpecificPool<T, E> getPool(T route) {
        RouteSpecificPool<T, E> pool = this.routeToPool.get(route);
        if (pool == null) {
            pool = new RouteSpecificPool<T, E>(route, this.factory);
            this.routeToPool.put(route, pool);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lease(T route, Object state, long connectTimeout, TimeUnit tunit, PoolEntryCallback<T, E> callback) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback may not be null.");
        }
        if (this.isShutDown) {
            throw new IllegalStateException("Session pool has been shut down");
        }
        this.lock.lock();
        try {
            int timeout = (int)tunit.toMillis(connectTimeout);
            if (timeout < 0) {
                timeout = 0;
            }
            LeaseRequest<T, E> request = new LeaseRequest<T, E>(route, state, timeout, callback);
            this.leasingRequests.add(request);
            this.processPendingRequests();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(E entry, boolean reusable) {
        if (this.isShutDown) {
            return;
        }
        this.lock.lock();
        try {
            if (this.leasedSessions.remove(entry)) {
                RouteSpecificPool pool = this.getPool(((PoolEntry)entry).getRoute());
                pool.freeEntry(entry, reusable);
                if (reusable) {
                    this.availableSessions.add(entry);
                } else {
                    IOSession iosession = ((PoolEntry)entry).getIOSession();
                    iosession.close();
                }
                this.processPendingRequests();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void processPendingRequests() {
        ListIterator it = this.leasingRequests.listIterator();
        while (it.hasNext()) {
            int totalUsed;
            int freeCapacity;
            LeaseRequest request = (LeaseRequest)it.next();
            Object route = request.getRoute();
            Object state = request.getState();
            int timeout = request.getConnectTimeout();
            PoolEntryCallback callback = request.getCallback();
            RouteSpecificPool pool = this.getPool(request.getRoute());
            PoolEntry entry = null;
            while ((entry = (PoolEntry)pool.getFreeEntry(state)) != null) {
                IOSession iosession = entry.getIOSession();
                if (entry.isExpired(System.currentTimeMillis())) {
                    iosession.close();
                }
                if (!iosession.isClosed()) break;
                this.availableSessions.remove(entry);
                pool.freeEntry(entry, false);
            }
            if (entry != null) {
                it.remove();
                this.availableSessions.remove(entry);
                this.leasedSessions.add(entry);
                callback.completed(entry);
                continue;
            }
            if (pool.getAllocatedCount() >= this.getMaxPerRoute(route) || (freeCapacity = Math.max(this.maxTotal - (totalUsed = this.pendingSessions.size() + this.leasedSessions.size()), 0)) == 0) continue;
            int totalAvailable = this.availableSessions.size();
            if (totalAvailable > freeCapacity - 1) {
                this.dropLastUsed();
            }
            it.remove();
            SessionRequest sessionRequest = this.ioreactor.connect(this.routeResolver.resolveRemoteAddress(route), this.routeResolver.resolveLocalAddress(route), route, this.sessionRequestCallback);
            sessionRequest.setConnectTimeout(timeout);
            this.pendingSessions.add(sessionRequest);
            pool.addPending(sessionRequest, callback);
        }
    }

    private void dropLastUsed() {
        if (!this.availableSessions.isEmpty()) {
            PoolEntry entry = (PoolEntry)this.availableSessions.removeFirst();
            IOSession iosession = entry.getIOSession();
            iosession.close();
            RouteSpecificPool pool = this.getPool(entry.getRoute());
            pool.remove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCompleted(SessionRequest request) {
        if (this.isShutDown) {
            return;
        }
        Object route = request.getAttachment();
        this.lock.lock();
        try {
            this.pendingSessions.remove(request);
            RouteSpecificPool<Object, E> pool = this.getPool(route);
            E entry = pool.completed(request);
            this.leasedSessions.add((PoolEntry<T>)entry);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCancelled(SessionRequest request) {
        if (this.isShutDown) {
            return;
        }
        Object route = request.getAttachment();
        this.lock.lock();
        try {
            this.pendingSessions.remove(request);
            RouteSpecificPool<Object, E> pool = this.getPool(route);
            pool.cancelled(request);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFailed(SessionRequest request) {
        if (this.isShutDown) {
            return;
        }
        Object route = request.getAttachment();
        this.lock.lock();
        try {
            this.pendingSessions.remove(request);
            RouteSpecificPool<Object, E> pool = this.getPool(route);
            pool.failed(request);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestTimeout(SessionRequest request) {
        if (this.isShutDown) {
            return;
        }
        Object route = request.getAttachment();
        this.lock.lock();
        try {
            this.pendingSessions.remove(request);
            RouteSpecificPool<Object, E> pool = this.getPool(route);
            pool.timeout(request);
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getMaxPerRoute(T route) {
        Integer v = this.maxPerRoute.get(route);
        if (v != null) {
            return v;
        }
        return this.defaultMaxPerRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalMax(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("Max value may not be negative or zero");
        }
        this.lock.lock();
        try {
            this.maxTotal = max;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultMaxPerHost(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("Max value may not be negative or zero");
        }
        this.lock.lock();
        try {
            this.defaultMaxPerRoute = max;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPerHost(T route, int max) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        if (max <= 0) {
            throw new IllegalArgumentException("Max value may not be negative or zero");
        }
        this.lock.lock();
        try {
            this.maxPerRoute.put(route, max);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            PoolStats poolStats = new PoolStats(this.leasedSessions.size(), this.pendingSessions.size(), this.availableSessions.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats getStats(T route) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        this.lock.lock();
        try {
            RouteSpecificPool<T, E> pool = this.getPool(route);
            PoolStats poolStats = new PoolStats(pool.getLeasedCount(), pool.getPendingCount(), pool.getAvailableCount(), this.getMaxPerRoute(route));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIdle(long idletime, TimeUnit tunit) {
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        long time = tunit.toMillis(idletime);
        if (time < 0L) {
            time = 0L;
        }
        long deadline = System.currentTimeMillis() - time;
        this.lock.lock();
        try {
            Iterator it = this.availableSessions.iterator();
            while (it.hasNext()) {
                PoolEntry entry = (PoolEntry)it.next();
                if (entry.getUpdated() > deadline) continue;
                IOSession iosession = entry.getIOSession();
                iosession.close();
                RouteSpecificPool pool = this.getPool(entry.getRoute());
                pool.remove(entry);
                it.remove();
            }
            this.processPendingRequests();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeExpired() {
        long now = System.currentTimeMillis();
        this.lock.lock();
        try {
            Iterator it = this.availableSessions.iterator();
            while (it.hasNext()) {
                PoolEntry entry = (PoolEntry)it.next();
                if (!entry.isExpired(now)) continue;
                IOSession iosession = entry.getIOSession();
                iosession.close();
                RouteSpecificPool pool = this.getPool(entry.getRoute());
                pool.remove(entry);
                it.remove();
            }
            this.processPendingRequests();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[leased: ");
        buffer.append(this.leasedSessions);
        buffer.append("][available: ");
        buffer.append(this.availableSessions);
        buffer.append("][pending: ");
        buffer.append(this.pendingSessions);
        buffer.append("]");
        return buffer.toString();
    }

    class InternalSessionRequestCallback
    implements SessionRequestCallback {
        InternalSessionRequestCallback() {
        }

        public void completed(SessionRequest request) {
            SessionPool.this.requestCompleted(request);
        }

        public void cancelled(SessionRequest request) {
            SessionPool.this.requestCancelled(request);
        }

        public void failed(SessionRequest request) {
            SessionPool.this.requestFailed(request);
        }

        public void timeout(SessionRequest request) {
            SessionPool.this.requestTimeout(request);
        }
    }
}

