/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.conn.ClientConnAdaptor;
import org.apache.http.impl.nio.conn.HttpPoolEntry;
import org.apache.http.impl.nio.conn.HttpSessionPool;
import org.apache.http.impl.nio.conn.SchemeRegistryFactory;
import org.apache.http.impl.nio.pool.PoolEntryCallback;
import org.apache.http.nio.concurrent.BasicFuture;
import org.apache.http.nio.concurrent.FutureCallback;
import org.apache.http.nio.conn.ClientConnectionManager;
import org.apache.http.nio.conn.ManagedClientConnection;
import org.apache.http.nio.conn.PoolStats;
import org.apache.http.nio.conn.scheme.SchemeRegistry;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingClientConnectionManager
implements ClientConnectionManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConnectingIOReactor ioreactor;
    private final HttpSessionPool pool;
    private final SchemeRegistry schemeRegistry;

    public PoolingClientConnectionManager(ConnectingIOReactor ioreactor, SchemeRegistry schemeRegistry, long timeToLive, TimeUnit tunit) {
        if (ioreactor == null) {
            throw new IllegalArgumentException("I/O reactor may not be null");
        }
        if (schemeRegistry == null) {
            throw new IllegalArgumentException("Scheme registory may not be null");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null");
        }
        this.ioreactor = ioreactor;
        this.pool = new HttpSessionPool(this.log, ioreactor, schemeRegistry, timeToLive, tunit);
        this.schemeRegistry = schemeRegistry;
    }

    public PoolingClientConnectionManager(ConnectingIOReactor ioreactor, SchemeRegistry schemeRegistry) throws IOReactorException {
        this(ioreactor, schemeRegistry, -1L, TimeUnit.MILLISECONDS);
    }

    public PoolingClientConnectionManager(ConnectingIOReactor ioreactor) throws IOReactorException {
        this(ioreactor, SchemeRegistryFactory.createDefault());
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    public void execute(IOEventDispatch eventDispatch) throws IOException {
        this.ioreactor.execute(eventDispatch);
    }

    public IOReactorStatus getStatus() {
        return this.ioreactor.getStatus();
    }

    public void shutdown(long waitMs) throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(waitMs);
        this.log.debug((Object)"Connection manager shut down");
    }

    public void shutdown() throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(2000L);
        this.log.debug((Object)"Connection manager shut down");
    }

    @Override
    public Future<ManagedClientConnection> leaseConnection(HttpRoute route, Object state, long timeout, TimeUnit tunit, FutureCallback<ManagedClientConnection> callback) {
        if (route == null) {
            throw new IllegalArgumentException("HTTP route may not be null");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request: route[" + route + "][state: " + state + "]"));
            PoolStats totals = this.pool.getTotalStats();
            PoolStats stats = this.pool.getStats(route);
            this.log.debug((Object)("Total: " + totals));
            this.log.debug((Object)("Route [" + route + "]: " + stats));
        }
        BasicFuture<ManagedClientConnection> future = new BasicFuture<ManagedClientConnection>(callback);
        this.pool.lease(route, state, timeout, tunit, new InternalPoolEntryCallback(future));
        if (this.log.isDebugEnabled() && !future.isDone()) {
            this.log.debug((Object)("Connection could not be allocated immediately: route[" + route + "][state: " + state + "]"));
        }
        return future;
    }

    @Override
    public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit tunit) {
        boolean reusable;
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (!(conn instanceof ClientConnAdaptor)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager");
        }
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit may not be null");
        }
        ClientConnAdaptor adaptor = (ClientConnAdaptor)conn;
        ClientConnectionManager manager = adaptor.getManager();
        if (manager != null && manager != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager");
        }
        if (this.pool.isShutdown()) {
            return;
        }
        HttpPoolEntry entry = adaptor.getEntry();
        if (this.log.isDebugEnabled()) {
            HttpRoute route = entry.getPlannedRoute();
            this.log.debug((Object)("Releasing connection: " + entry));
            PoolStats totals = this.pool.getTotalStats();
            PoolStats stats = this.pool.getStats(route);
            this.log.debug((Object)("Total: " + totals));
            this.log.debug((Object)("Route [" + route + "]: " + stats));
        }
        if (reusable = adaptor.isReusable()) {
            entry.updateExpiry(validDuration, tunit);
            if (this.log.isDebugEnabled()) {
                String s = validDuration > 0L ? "for " + validDuration + " " + (Object)((Object)tunit) : "indefinitely";
                this.log.debug((Object)("Pooling connection: " + entry + "; keep alive " + s));
            }
        }
        this.pool.release(entry, reusable);
    }

    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    public PoolStats getStats(HttpRoute route) {
        return this.pool.getStats(route);
    }

    public void setTotalMax(int max) {
        this.pool.setTotalMax(max);
    }

    public void setDefaultMaxPerHost(int max) {
        this.pool.setDefaultMaxPerHost(max);
    }

    public void setMaxPerHost(HttpRoute route, int max) {
        this.pool.setMaxPerHost(route, max);
    }

    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + idleTimeout + " " + (Object)((Object)tunit)));
        }
        this.pool.closeIdle(idleTimeout, tunit);
    }

    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpired();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InternalPoolEntryCallback
    implements PoolEntryCallback<HttpRoute, HttpPoolEntry> {
        private final BasicFuture<ManagedClientConnection> future;

        public InternalPoolEntryCallback(BasicFuture<ManagedClientConnection> future) {
            this.future = future;
        }

        @Override
        public void completed(HttpPoolEntry entry) {
            ClientConnAdaptor conn;
            if (PoolingClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingClientConnectionManager.this.log.debug((Object)("Connection allocated: " + entry));
            }
            if (!this.future.completed(conn = new ClientConnAdaptor(PoolingClientConnectionManager.this, entry))) {
                PoolingClientConnectionManager.this.pool.release(entry, true);
            }
        }

        @Override
        public void failed(Exception ex) {
            if (PoolingClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingClientConnectionManager.this.log.debug((Object)"Connection request failed", (Throwable)ex);
            }
            this.future.failed(ex);
        }

        @Override
        public void cancelled() {
            PoolingClientConnectionManager.this.log.debug((Object)"Connection request cancelled");
            this.future.cancel(true);
        }
    }
}

