/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.conn.HttpPoolEntry;
import org.apache.http.impl.nio.pool.PoolEntryFactory;
import org.apache.http.impl.nio.pool.RouteResolver;
import org.apache.http.impl.nio.pool.SessionPool;
import org.apache.http.nio.conn.scheme.Scheme;
import org.apache.http.nio.conn.scheme.SchemeRegistry;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpSessionPool
extends SessionPool<HttpRoute, HttpPoolEntry> {
    HttpSessionPool(Log log, ConnectingIOReactor ioreactor, SchemeRegistry schemeRegistry, long timeToLive, TimeUnit tunit) {
        super(ioreactor, new InternalEntryFactory(log, timeToLive, tunit), new InternalRouteResolver(schemeRegistry), 20, 50);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalEntryFactory
    implements PoolEntryFactory<HttpRoute, HttpPoolEntry> {
        private final Log log;
        private final long connTimeToLive;
        private final TimeUnit tunit;

        InternalEntryFactory(Log log, long connTimeToLive, TimeUnit tunit) {
            this.log = log;
            this.connTimeToLive = connTimeToLive;
            this.tunit = tunit;
        }

        @Override
        public HttpPoolEntry createEntry(HttpRoute route, IOSession session) {
            return new HttpPoolEntry(this.log, route, session, this.connTimeToLive, this.tunit);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalRouteResolver
    implements RouteResolver<HttpRoute> {
        private final SchemeRegistry schemeRegistry;

        InternalRouteResolver(SchemeRegistry schemeRegistry) {
            this.schemeRegistry = schemeRegistry;
        }

        @Override
        public SocketAddress resolveLocalAddress(HttpRoute route) {
            return new InetSocketAddress(route.getLocalAddress(), 0);
        }

        @Override
        public SocketAddress resolveRemoteAddress(HttpRoute route) {
            HttpHost firsthop = route.getProxyHost();
            if (firsthop == null) {
                firsthop = route.getTargetHost();
            }
            String hostname = firsthop.getHostName();
            int port = firsthop.getPort();
            if (port < 0) {
                Scheme scheme = this.schemeRegistry.getScheme(firsthop);
                port = scheme.resolvePort(port);
            }
            return new InetSocketAddress(hostname, port);
        }
    }
}

