/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.cache.AsynchronousAsyncValidator;
import org.apache.http.impl.client.cache.BasicHttpCache;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheValidityPolicy;
import org.apache.http.impl.client.cache.CacheableRequestPolicy;
import org.apache.http.impl.client.cache.CachedHttpResponseGenerator;
import org.apache.http.impl.client.cache.CachedResponseSuitabilityChecker;
import org.apache.http.impl.client.cache.ConditionalRequestBuilder;
import org.apache.http.impl.client.cache.FutureHttpResponse;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.apache.http.impl.client.cache.HttpCache;
import org.apache.http.impl.client.cache.OptionsHttp11Response;
import org.apache.http.impl.client.cache.RequestProtocolCompliance;
import org.apache.http.impl.client.cache.RequestProtocolError;
import org.apache.http.impl.client.cache.ResponseCachingPolicy;
import org.apache.http.impl.client.cache.ResponseProtocolCompliance;
import org.apache.http.impl.client.cache.Variant;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;
import org.apache.http.util.VersionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class CachingHttpAsyncClient
implements HttpAsyncClient {
    private static final boolean SUPPORTS_RANGE_AND_CONTENT_RANGE_HEADERS = false;
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final AtomicLong cacheUpdates = new AtomicLong();
    private final Map<ProtocolVersion, String> viaHeaders = new HashMap<ProtocolVersion, String>(4);
    private final HttpAsyncClient backend;
    private final HttpCache responseCache;
    private final CacheValidityPolicy validityPolicy;
    private final ResponseCachingPolicy responseCachingPolicy;
    private final CachedHttpResponseGenerator responseGenerator;
    private final CacheableRequestPolicy cacheableRequestPolicy;
    private final CachedResponseSuitabilityChecker suitabilityChecker;
    private final ConditionalRequestBuilder conditionalRequestBuilder;
    private final long maxObjectSizeBytes;
    private final boolean sharedCache;
    private final ResponseProtocolCompliance responseCompliance;
    private final RequestProtocolCompliance requestCompliance;
    private final AsynchronousAsyncValidator asynchAsyncRevalidator;
    private final Log log = LogFactory.getLog(this.getClass());

    CachingHttpAsyncClient(HttpAsyncClient client, HttpCache cache, CacheConfig config) {
        Args.notNull((Object)client, (String)"HttpClient");
        Args.notNull((Object)cache, (String)"HttpCache");
        Args.notNull((Object)config, (String)"CacheConfig");
        this.maxObjectSizeBytes = config.getMaxObjectSize();
        this.sharedCache = config.isSharedCache();
        this.backend = client;
        this.responseCache = cache;
        this.validityPolicy = new CacheValidityPolicy();
        this.responseCachingPolicy = new ResponseCachingPolicy(this.maxObjectSizeBytes, this.sharedCache, false, config.is303CachingEnabled());
        this.responseGenerator = new CachedHttpResponseGenerator(this.validityPolicy);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker(this.validityPolicy, config);
        this.conditionalRequestBuilder = new ConditionalRequestBuilder();
        this.responseCompliance = new ResponseProtocolCompliance();
        this.requestCompliance = new RequestProtocolCompliance(config.isWeakETagOnPutDeleteAllowed());
        this.asynchAsyncRevalidator = this.makeAsynchronousValidator(config);
    }

    public CachingHttpAsyncClient() throws IOReactorException {
        this((HttpAsyncClient)HttpAsyncClients.createDefault(), (HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
    }

    public CachingHttpAsyncClient(CacheConfig config) throws IOReactorException {
        this((HttpAsyncClient)HttpAsyncClients.createDefault(), (HttpCache)new BasicHttpCache(config), config);
    }

    public CachingHttpAsyncClient(HttpAsyncClient client) {
        this(client, (HttpCache)new BasicHttpCache(), CacheConfig.DEFAULT);
    }

    public CachingHttpAsyncClient(HttpAsyncClient client, CacheConfig config) {
        this(client, (HttpCache)new BasicHttpCache(config), config);
    }

    public CachingHttpAsyncClient(HttpAsyncClient client, ResourceFactory resourceFactory, HttpCacheStorage storage, CacheConfig config) {
        this(client, (HttpCache)new BasicHttpCache(resourceFactory, storage, config), config);
    }

    public CachingHttpAsyncClient(HttpAsyncClient client, HttpCacheStorage storage, CacheConfig config) {
        this(client, (HttpCache)new BasicHttpCache((ResourceFactory)new HeapResourceFactory(), storage, config), config);
    }

    CachingHttpAsyncClient(HttpAsyncClient backend, CacheValidityPolicy validityPolicy, ResponseCachingPolicy responseCachingPolicy, HttpCache responseCache, CachedHttpResponseGenerator responseGenerator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker suitabilityChecker, ConditionalRequestBuilder conditionalRequestBuilder, ResponseProtocolCompliance responseCompliance, RequestProtocolCompliance requestCompliance) {
        CacheConfig config = CacheConfig.DEFAULT;
        this.maxObjectSizeBytes = config.getMaxObjectSize();
        this.sharedCache = config.isSharedCache();
        this.backend = backend;
        this.validityPolicy = validityPolicy;
        this.responseCachingPolicy = responseCachingPolicy;
        this.responseCache = responseCache;
        this.responseGenerator = responseGenerator;
        this.cacheableRequestPolicy = cacheableRequestPolicy;
        this.suitabilityChecker = suitabilityChecker;
        this.conditionalRequestBuilder = conditionalRequestBuilder;
        this.responseCompliance = responseCompliance;
        this.requestCompliance = requestCompliance;
        this.asynchAsyncRevalidator = this.makeAsynchronousValidator(config);
    }

    private AsynchronousAsyncValidator makeAsynchronousValidator(CacheConfig config) {
        if (config.getAsynchronousWorkersMax() > 0) {
            return new AsynchronousAsyncValidator(this, config);
        }
        return null;
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    public long getCacheUpdates() {
        return this.cacheUpdates.get();
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(target, request, null, callback);
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, callback);
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        this.log.warn((Object)"CachingHttpAsyncClient does not support caching for streaming HTTP exchanges");
        return this.backend.execute(requestProducer, responseConsumer, context, callback);
    }

    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(request, null, callback);
    }

    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        URI uri = request.getURI();
        HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        return this.execute(httpHost, (HttpRequest)request, context, callback);
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest originalRequest, HttpContext context, FutureCallback<HttpResponse> futureCallback) {
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)originalRequest);
        this.setResponseStatus(context, CacheResponseStatus.CACHE_MISS);
        String via = this.generateViaHeader((HttpMessage)request);
        if (this.clientRequestsOurOptions((HttpRequest)request)) {
            this.setResponseStatus(context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            BasicFuture future = new BasicFuture(futureCallback);
            future.completed((Object)new OptionsHttp11Response());
            return future;
        }
        HttpResponse fatalErrorResponse = this.getFatallyNoncompliantResponse((HttpRequest)request, context);
        if (fatalErrorResponse != null) {
            BasicFuture future = new BasicFuture(futureCallback);
            future.completed((Object)fatalErrorResponse);
            return future;
        }
        try {
            this.requestCompliance.makeRequestCompliant(request);
        }
        catch (ClientProtocolException e) {
            BasicFuture future = new BasicFuture(futureCallback);
            future.failed((Exception)((Object)e));
            return future;
        }
        request.addHeader("Via", via);
        this.flushEntriesInvalidatedByRequest(target, (HttpRequest)request);
        if (!this.cacheableRequestPolicy.isServableFromCache((HttpRequest)request)) {
            this.log.debug((Object)"Request is not servable from cache");
            return this.callBackend(target, request, context, futureCallback);
        }
        HttpCacheEntry entry = this.satisfyFromCache(target, (HttpRequest)request);
        if (entry == null) {
            this.log.debug((Object)"Cache miss");
            return this.handleCacheMiss(target, request, context, futureCallback);
        }
        try {
            return this.handleCacheHit(target, request, context, entry, futureCallback);
        }
        catch (ClientProtocolException e) {
            BasicFuture future = new BasicFuture(futureCallback);
            future.failed((Exception)((Object)e));
            return future;
        }
        catch (IOException e) {
            BasicFuture future = new BasicFuture(futureCallback);
            future.failed((Exception)e);
            return future;
        }
    }

    private Future<HttpResponse> handleCacheHit(HttpHost target, HttpRequestWrapper request, HttpContext context, HttpCacheEntry entry, FutureCallback<HttpResponse> futureCallback) throws ClientProtocolException, IOException {
        HttpResponse out;
        this.recordCacheHit(target, (HttpRequest)request);
        Date now = this.getCurrentDate();
        if (this.suitabilityChecker.canCachedResponseBeUsed(target, (HttpRequest)request, entry, now)) {
            this.log.debug((Object)"Cache hit");
            out = this.generateCachedResponse((HttpRequest)request, context, entry, now);
        } else if (!this.mayCallBackend((HttpRequest)request)) {
            this.log.debug((Object)"Cache entry not suitable but only-if-cached requested");
            out = this.generateGatewayTimeout(context);
        } else {
            if (this.validityPolicy.isRevalidatable(entry) && (entry.getStatusCode() != 304 || this.suitabilityChecker.isConditional((HttpRequest)request))) {
                this.log.debug((Object)"Revalidating cache entry");
                return this.revalidateCacheEntry(target, request, context, entry, now, futureCallback);
            }
            this.log.debug((Object)"Cache entry not usable; calling backend");
            return this.callBackend(target, request, context, futureCallback);
        }
        context.setAttribute("http.route", (Object)new HttpRoute(target));
        context.setAttribute("http.target_host", (Object)target);
        context.setAttribute("http.request", (Object)request);
        context.setAttribute("http.response", (Object)out);
        context.setAttribute("http.request_sent", (Object)Boolean.TRUE);
        BasicFuture future = new BasicFuture(futureCallback);
        future.completed((Object)out);
        return future;
    }

    private Future<HttpResponse> revalidateCacheEntry(HttpHost target, final HttpRequestWrapper request, final HttpContext context, final HttpCacheEntry entry, final Date now, FutureCallback<HttpResponse> futureCallback) throws ClientProtocolException {
        try {
            if (this.asynchAsyncRevalidator != null && !this.staleResponseNotAllowed((HttpRequest)request, entry, now) && this.validityPolicy.mayReturnStaleWhileRevalidating(entry, now)) {
                this.log.debug((Object)"Serving stale with asynchronous revalidation");
                HttpResponse resp = this.responseGenerator.generateResponse(entry);
                resp.addHeader("Warning", "110 localhost \"Response is stale\"");
                this.asynchAsyncRevalidator.revalidateCacheEntry(target, request, context, entry);
                BasicFuture future = new BasicFuture(futureCallback);
                future.completed((Object)resp);
                return future;
            }
            FutureHttpResponse future = new FutureHttpResponse(futureCallback){

                public void failed(Exception ex) {
                    if (ex instanceof IOException) {
                        super.completed(CachingHttpAsyncClient.this.handleRevalidationFailure((HttpRequest)request, context, entry, now));
                    } else {
                        super.failed(ex);
                    }
                }
            };
            future.setDelegate(this.revalidateCacheEntry(target, request, context, entry, future));
            return future;
        }
        catch (ProtocolException e) {
            throw new ClientProtocolException((Throwable)e);
        }
    }

    private Future<HttpResponse> handleCacheMiss(HttpHost target, HttpRequestWrapper request, HttpContext context, FutureCallback<HttpResponse> futureCallback) {
        this.recordCacheMiss(target, (HttpRequest)request);
        if (!this.mayCallBackend((HttpRequest)request)) {
            BasicFuture future = new BasicFuture(futureCallback);
            future.completed((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 504, "Gateway Timeout"));
            return future;
        }
        Map<String, Variant> variants = this.getExistingCacheVariants(target, (HttpRequest)request);
        if (variants != null && variants.size() > 0) {
            return this.negotiateResponseFromVariants(target, request, context, variants, futureCallback);
        }
        return this.callBackend(target, request, context, futureCallback);
    }

    private HttpCacheEntry satisfyFromCache(HttpHost target, HttpRequest request) {
        HttpCacheEntry entry = null;
        try {
            entry = this.responseCache.getCacheEntry(target, request);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Unable to retrieve entries from cache", (Throwable)ioe);
        }
        return entry;
    }

    private HttpResponse getFatallyNoncompliantResponse(HttpRequest request, HttpContext context) {
        HttpResponse fatalErrorResponse = null;
        List fatalError = this.requestCompliance.requestIsFatallyNonCompliant(request);
        for (RequestProtocolError error : fatalError) {
            this.setResponseStatus(context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            fatalErrorResponse = this.requestCompliance.getErrorForRequest(error);
        }
        return fatalErrorResponse;
    }

    private Map<String, Variant> getExistingCacheVariants(HttpHost target, HttpRequest request) {
        Map variants = null;
        try {
            variants = this.responseCache.getVariantCacheEntriesWithEtags(target, request);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Unable to retrieve variant entries from cache", (Throwable)ioe);
        }
        return variants;
    }

    private void recordCacheMiss(HttpHost target, HttpRequest request) {
        this.cacheMisses.getAndIncrement();
        if (this.log.isDebugEnabled()) {
            RequestLine rl = request.getRequestLine();
            this.log.debug((Object)("Cache miss [host: " + target + "; uri: " + rl.getUri() + "]"));
        }
    }

    private void recordCacheHit(HttpHost target, HttpRequest request) {
        this.cacheHits.getAndIncrement();
        if (this.log.isDebugEnabled()) {
            RequestLine rl = request.getRequestLine();
            this.log.debug((Object)("Cache hit [host: " + target + "; uri: " + rl.getUri() + "]"));
        }
    }

    private void recordCacheUpdate(HttpContext context) {
        this.cacheUpdates.getAndIncrement();
        this.setResponseStatus(context, CacheResponseStatus.VALIDATED);
    }

    private void flushEntriesInvalidatedByRequest(HttpHost target, HttpRequest request) {
        try {
            this.responseCache.flushInvalidatedCacheEntriesFor(target, request);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Unable to flush invalidated entries from cache", (Throwable)ioe);
        }
    }

    private HttpResponse generateCachedResponse(HttpRequest request, HttpContext context, HttpCacheEntry entry, Date now) {
        HttpResponse cachedResponse = request.containsHeader("If-None-Match") || request.containsHeader("If-Modified-Since") ? this.responseGenerator.generateNotModifiedResponse(entry) : this.responseGenerator.generateResponse(entry);
        this.setResponseStatus(context, CacheResponseStatus.CACHE_HIT);
        if (this.validityPolicy.getStalenessSecs(entry, now) > 0L) {
            cachedResponse.addHeader("Warning", "110 localhost \"Response is stale\"");
        }
        return cachedResponse;
    }

    private HttpResponse handleRevalidationFailure(HttpRequest request, HttpContext context, HttpCacheEntry entry, Date now) {
        if (this.staleResponseNotAllowed(request, entry, now)) {
            return this.generateGatewayTimeout(context);
        }
        return this.unvalidatedCacheHit(context, entry);
    }

    private HttpResponse generateGatewayTimeout(HttpContext context) {
        this.setResponseStatus(context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
        return new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 504, "Gateway Timeout");
    }

    private HttpResponse unvalidatedCacheHit(HttpContext context, HttpCacheEntry entry) {
        HttpResponse cachedResponse = this.responseGenerator.generateResponse(entry);
        this.setResponseStatus(context, CacheResponseStatus.CACHE_HIT);
        cachedResponse.addHeader("Warning", "111 localhost \"Revalidation failed\"");
        return cachedResponse;
    }

    private boolean staleResponseNotAllowed(HttpRequest request, HttpCacheEntry entry, Date now) {
        return this.validityPolicy.mustRevalidate(entry) || this.isSharedCache() && this.validityPolicy.proxyRevalidate(entry) || this.explicitFreshnessRequest(request, entry, now);
    }

    private boolean mayCallBackend(HttpRequest request) {
        for (Header h : request.getHeaders("Cache-Control")) {
            for (HeaderElement elt : h.getElements()) {
                if (!"only-if-cached".equals(elt.getName())) continue;
                this.log.debug((Object)"Request marked only-if-cached");
                return false;
            }
        }
        return true;
    }

    private boolean explicitFreshnessRequest(HttpRequest request, HttpCacheEntry entry, Date now) {
        for (Header h : request.getHeaders("Cache-Control")) {
            for (HeaderElement elt : h.getElements()) {
                if ("max-stale".equals(elt.getName())) {
                    try {
                        int maxstale = Integer.parseInt(elt.getValue());
                        long age = this.validityPolicy.getCurrentAgeSecs(entry, now);
                        long lifetime = this.validityPolicy.getFreshnessLifetimeSecs(entry);
                        if (age - lifetime <= (long)maxstale) continue;
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        return true;
                    }
                }
                if (!"min-fresh".equals(elt.getName()) && !"max-age".equals(elt.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private String generateViaHeader(HttpMessage msg) {
        ProtocolVersion pv = msg.getProtocolVersion();
        String existingEntry = this.viaHeaders.get(pv);
        if (existingEntry != null) {
            return existingEntry;
        }
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)this.getClass().getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        String value = "http".equalsIgnoreCase(pv.getProtocol()) ? String.format("%d.%d localhost (Apache-HttpClient/%s (cache))", pv.getMajor(), pv.getMinor(), release) : String.format("%s/%d.%d localhost (Apache-HttpClient/%s (cache))", pv.getProtocol(), pv.getMajor(), pv.getMinor(), release);
        this.viaHeaders.put(pv, value);
        return value;
    }

    private void setResponseStatus(HttpContext context, CacheResponseStatus value) {
        if (context != null) {
            context.setAttribute("http.cache.response.status", (Object)value);
        }
    }

    public boolean supportsRangeAndContentRangeHeaders() {
        return false;
    }

    public boolean isSharedCache() {
        return this.sharedCache;
    }

    Date getCurrentDate() {
        return new Date();
    }

    boolean clientRequestsOurOptions(HttpRequest request) {
        RequestLine line = request.getRequestLine();
        if (!"OPTIONS".equals(line.getMethod())) {
            return false;
        }
        if (!"*".equals(line.getUri())) {
            return false;
        }
        return "0".equals(request.getFirstHeader("Max-Forwards").getValue());
    }

    Future<HttpResponse> callBackend(final HttpHost target, final HttpRequestWrapper request, HttpContext context, FutureCallback<HttpResponse> futureCallback) {
        final Date requestDate = this.getCurrentDate();
        this.log.trace((Object)"Calling the backend");
        FutureHttpResponse future = new FutureHttpResponse(futureCallback){

            public void completed(HttpResponse httpResponse) {
                httpResponse.addHeader("Via", CachingHttpAsyncClient.this.generateViaHeader((HttpMessage)httpResponse));
                try {
                    HttpResponse backendResponse = CachingHttpAsyncClient.this.handleBackendResponse(target, request, requestDate, CachingHttpAsyncClient.this.getCurrentDate(), httpResponse);
                    super.completed(backendResponse);
                }
                catch (IOException e) {
                    super.failed(e);
                }
            }
        };
        future.setDelegate(this.backend.execute(target, (HttpRequest)request, context, (FutureCallback)future));
        return future;
    }

    private boolean revalidationResponseIsTooOld(HttpResponse backendResponse, HttpCacheEntry cacheEntry) {
        Header entryDateHeader = cacheEntry.getFirstHeader("Date");
        Header responseDateHeader = backendResponse.getFirstHeader("Date");
        if (entryDateHeader != null && responseDateHeader != null) {
            Date entryDate = DateUtils.parseDate((String)entryDateHeader.getValue());
            Date respDate = DateUtils.parseDate((String)responseDateHeader.getValue());
            if (respDate != null && respDate.before(entryDate)) {
                return true;
            }
        }
        return false;
    }

    Future<HttpResponse> negotiateResponseFromVariants(final HttpHost target, final HttpRequestWrapper request, final HttpContext context, final Map<String, Variant> variants, FutureCallback<HttpResponse> futureCallback) {
        HttpRequestWrapper conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(request, variants);
        final Date requestDate = this.getCurrentDate();
        final FutureHttpResponse future = new FutureHttpResponse(futureCallback);
        Future backendFuture = this.backend.execute(target, (HttpRequest)conditionalRequest, context, (FutureCallback)new FutureCallback<HttpResponse>((HttpRequest)conditionalRequest){
            final /* synthetic */ HttpRequest val$conditionalRequest;
            {
                this.val$conditionalRequest = httpRequest;
            }

            public void cancelled() {
                future.cancelled();
            }

            public void completed(HttpResponse httpResponse) {
                HttpCacheEntry matchedEntry;
                Date responseDate = CachingHttpAsyncClient.this.getCurrentDate();
                httpResponse.addHeader("Via", CachingHttpAsyncClient.this.generateViaHeader((HttpMessage)httpResponse));
                if (httpResponse.getStatusLine().getStatusCode() != 304) {
                    try {
                        future.completed(CachingHttpAsyncClient.this.handleBackendResponse(target, request, requestDate, responseDate, httpResponse));
                        return;
                    }
                    catch (IOException e) {
                        future.failed(e);
                        return;
                    }
                }
                Header resultEtagHeader = httpResponse.getFirstHeader("ETag");
                if (resultEtagHeader == null) {
                    CachingHttpAsyncClient.this.log.warn((Object)"304 response did not contain ETag");
                    CachingHttpAsyncClient.this.callBackend(target, request, context, future);
                    return;
                }
                String resultEtag = resultEtagHeader.getValue();
                Variant matchingVariant = (Variant)variants.get(resultEtag);
                if (matchingVariant == null) {
                    CachingHttpAsyncClient.this.log.debug((Object)"304 response did not contain ETag matching one sent in If-None-Match");
                    CachingHttpAsyncClient.this.callBackend(target, request, context, future);
                }
                if (CachingHttpAsyncClient.this.revalidationResponseIsTooOld(httpResponse, matchedEntry = matchingVariant.getEntry())) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    CachingHttpAsyncClient.this.retryRequestUnconditionally(target, request, context, matchedEntry, (FutureCallback<HttpResponse>)future);
                    return;
                }
                CachingHttpAsyncClient.this.recordCacheUpdate(context);
                HttpCacheEntry responseEntry = CachingHttpAsyncClient.this.getUpdatedVariantEntry(target, this.val$conditionalRequest, requestDate, responseDate, httpResponse, matchingVariant, matchedEntry);
                HttpResponse resp = CachingHttpAsyncClient.this.responseGenerator.generateResponse(responseEntry);
                CachingHttpAsyncClient.this.tryToUpdateVariantMap(target, (HttpRequest)request, matchingVariant);
                if (CachingHttpAsyncClient.this.shouldSendNotModifiedResponse((HttpRequest)request, responseEntry)) {
                    future.completed(CachingHttpAsyncClient.this.responseGenerator.generateNotModifiedResponse(responseEntry));
                    return;
                }
                future.completed(resp);
            }

            public void failed(Exception ex) {
                future.failed(ex);
            }
        });
        future.setDelegate(backendFuture);
        return future;
    }

    private void retryRequestUnconditionally(HttpHost target, HttpRequestWrapper request, HttpContext context, HttpCacheEntry matchedEntry, FutureCallback<HttpResponse> futureCallback) {
        HttpRequestWrapper unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(request, matchedEntry);
        this.callBackend(target, unconditional, context, futureCallback);
    }

    private HttpCacheEntry getUpdatedVariantEntry(HttpHost target, HttpRequest conditionalRequest, Date requestDate, Date responseDate, HttpResponse backendResponse, Variant matchingVariant, HttpCacheEntry matchedEntry) {
        HttpCacheEntry responseEntry = matchedEntry;
        try {
            responseEntry = this.responseCache.updateVariantCacheEntry(target, conditionalRequest, matchedEntry, backendResponse, requestDate, responseDate, matchingVariant.getCacheKey());
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Could not update cache entry", (Throwable)ioe);
        }
        return responseEntry;
    }

    private void tryToUpdateVariantMap(HttpHost target, HttpRequest request, Variant matchingVariant) {
        try {
            this.responseCache.reuseVariantEntryFor(target, request, matchingVariant);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Could not update cache entry to reuse variant", (Throwable)ioe);
        }
    }

    private boolean shouldSendNotModifiedResponse(HttpRequest request, HttpCacheEntry responseEntry) {
        return this.suitabilityChecker.isConditional(request) && this.suitabilityChecker.allConditionalsMatch(request, responseEntry, new Date());
    }

    Future<HttpResponse> revalidateCacheEntry(final HttpHost target, final HttpRequestWrapper request, final HttpContext context, final HttpCacheEntry cacheEntry, FutureCallback<HttpResponse> futureCallback) throws ProtocolException {
        final HttpRequestWrapper conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequest(request, cacheEntry);
        final Date requestDate = this.getCurrentDate();
        final FutureHttpResponse future = new FutureHttpResponse(futureCallback);
        future.setDelegate(this.backend.execute(target, (HttpRequest)conditionalRequest, context, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void cancelled() {
                future.cancelled();
            }

            public void completed(HttpResponse httpResponse) {
                Date responseDate = CachingHttpAsyncClient.this.getCurrentDate();
                if (CachingHttpAsyncClient.this.revalidationResponseIsTooOld(httpResponse, cacheEntry)) {
                    HttpRequestWrapper unconditional = CachingHttpAsyncClient.this.conditionalRequestBuilder.buildUnconditionalRequest(request, cacheEntry);
                    final Date innerRequestDate = CachingHttpAsyncClient.this.getCurrentDate();
                    CachingHttpAsyncClient.this.backend.execute(target, (HttpRequest)unconditional, context, (FutureCallback)new FutureCallback<HttpResponse>(){

                        public void cancelled() {
                            future.cancelled();
                        }

                        public void completed(HttpResponse innerHttpResponse) {
                            Date innerResponseDate = CachingHttpAsyncClient.this.getCurrentDate();
                            CachingHttpAsyncClient.this.revalidateCacheEntryCompleted(target, request, context, cacheEntry, future, conditionalRequest, innerRequestDate, innerHttpResponse, innerResponseDate);
                        }

                        public void failed(Exception ex) {
                            future.failed(ex);
                        }
                    });
                    return;
                }
                CachingHttpAsyncClient.this.revalidateCacheEntryCompleted(target, request, context, cacheEntry, future, conditionalRequest, requestDate, httpResponse, responseDate);
            }

            public void failed(Exception ex) {
                future.failed(ex);
            }
        }));
        return future;
    }

    private void revalidateCacheEntryCompleted(HttpHost target, HttpRequestWrapper request, HttpContext context, HttpCacheEntry cacheEntry, FutureHttpResponse futureCallback, HttpRequestWrapper conditionalRequest, Date requestDate, HttpResponse httpResponse, Date responseDate) {
        httpResponse.addHeader("Via", this.generateViaHeader((HttpMessage)httpResponse));
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode == 304 || statusCode == 200) {
            this.recordCacheUpdate(context);
        }
        if (statusCode == 304) {
            HttpCacheEntry updatedEntry;
            try {
                updatedEntry = this.responseCache.updateCacheEntry(target, (HttpRequest)request, cacheEntry, httpResponse, requestDate, responseDate);
            }
            catch (IOException e) {
                futureCallback.failed(e);
                return;
            }
            if (this.suitabilityChecker.isConditional((HttpRequest)request) && this.suitabilityChecker.allConditionalsMatch((HttpRequest)request, updatedEntry, new Date())) {
                futureCallback.completed(this.responseGenerator.generateNotModifiedResponse(updatedEntry));
                return;
            }
            futureCallback.completed(this.responseGenerator.generateResponse(updatedEntry));
            return;
        }
        if (this.staleIfErrorAppliesTo(statusCode) && !this.staleResponseNotAllowed((HttpRequest)request, cacheEntry, this.getCurrentDate()) && this.validityPolicy.mayReturnStaleIfError((HttpRequest)request, cacheEntry, responseDate)) {
            HttpResponse cachedResponse = this.responseGenerator.generateResponse(cacheEntry);
            cachedResponse.addHeader("Warning", "110 localhost \"Response is stale\"");
            futureCallback.completed(cachedResponse);
            return;
        }
        try {
            HttpResponse backendResponse = this.handleBackendResponse(target, conditionalRequest, requestDate, responseDate, httpResponse);
            futureCallback.completed(backendResponse);
        }
        catch (IOException e) {
            futureCallback.failed(e);
        }
    }

    private boolean staleIfErrorAppliesTo(int statusCode) {
        return statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
    }

    HttpResponse handleBackendResponse(HttpHost target, HttpRequestWrapper request, Date requestDate, Date responseDate, HttpResponse backendResponse) throws IOException {
        this.log.debug((Object)"Handling Backend response");
        this.responseCompliance.ensureProtocolCompliance(request, backendResponse);
        boolean cacheable = this.responseCachingPolicy.isResponseCacheable((HttpRequest)request, backendResponse);
        this.responseCache.flushInvalidatedCacheEntriesFor(target, (HttpRequest)request, backendResponse);
        if (cacheable && !this.alreadyHaveNewerCacheEntry(target, (HttpRequest)request, backendResponse)) {
            this.storeRequestIfModifiedSinceFor304Response((HttpRequest)request, backendResponse);
            return this.responseCache.cacheAndReturnResponse(target, (HttpRequest)request, backendResponse, requestDate, responseDate);
        }
        if (!cacheable) {
            try {
                this.responseCache.flushCacheEntriesFor(target, (HttpRequest)request);
            }
            catch (IOException ioe) {
                this.log.warn((Object)"Unable to flush invalid cache entries", (Throwable)ioe);
            }
        }
        return backendResponse;
    }

    private void storeRequestIfModifiedSinceFor304Response(HttpRequest request, HttpResponse backendResponse) {
        Header h;
        if (backendResponse.getStatusLine().getStatusCode() == 304 && (h = request.getFirstHeader("If-Modified-Since")) != null) {
            backendResponse.addHeader("Last-Modified", h.getValue());
        }
    }

    private boolean alreadyHaveNewerCacheEntry(HttpHost target, HttpRequest request, HttpResponse backendResponse) {
        HttpCacheEntry existing = null;
        try {
            existing = this.responseCache.getCacheEntry(target, request);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (existing == null) {
            return false;
        }
        Header entryDateHeader = existing.getFirstHeader("Date");
        if (entryDateHeader == null) {
            return false;
        }
        Header responseDateHeader = backendResponse.getFirstHeader("Date");
        if (responseDateHeader == null) {
            return false;
        }
        Date entryDate = DateUtils.parseDate((String)entryDateHeader.getValue());
        Date responseDate = DateUtils.parseDate((String)responseDateHeader.getValue());
        return responseDate != null && responseDate.before(entryDate);
    }
}

