/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteTracker;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.TunnelRefusedException;
import org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.hc.client5.http.impl.auth.AuthCacheKeeper;
import org.apache.hc.client5.http.impl.auth.HttpAuthenticator;
import org.apache.hc.client5.http.impl.routing.BasicRouteDirector;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRouteDirector;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class AsyncConnectExec
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncConnectExec.class);
    private final HttpProcessor proxyHttpProcessor;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthCacheKeeper authCacheKeeper;
    private final HttpRouteDirector routeDirector;

    public AsyncConnectExec(HttpProcessor proxyHttpProcessor, AuthenticationStrategy proxyAuthStrategy, SchemePortResolver schemePortResolver, boolean authCachingDisabled) {
        Args.notNull((Object)proxyHttpProcessor, (String)"Proxy HTTP processor");
        Args.notNull((Object)proxyAuthStrategy, (String)"Proxy authentication strategy");
        this.proxyHttpProcessor = proxyHttpProcessor;
        this.proxyAuthStrategy = proxyAuthStrategy;
        this.authenticator = new HttpAuthenticator();
        this.authCacheKeeper = authCachingDisabled ? null : new AuthCacheKeeper(schemePortResolver);
        this.routeDirector = BasicRouteDirector.INSTANCE;
    }

    @Override
    public void execute(final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        CancellableDependency cancellableDependency = scope.cancellableDependency;
        HttpClientContext clientContext = scope.clientContext;
        AsyncExecRuntime execRuntime = scope.execRuntime;
        final State state = new State(route);
        if (!execRuntime.isEndpointAcquired()) {
            Object userToken = clientContext.getUserToken();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} acquiring connection with route {}", (Object)exchangeId, (Object)route);
            }
            cancellableDependency.setDependency(execRuntime.acquireEndpoint(exchangeId, route, userToken, clientContext, new FutureCallback<AsyncExecRuntime>(){

                public void completed(AsyncExecRuntime execRuntime) {
                    if (execRuntime.isEndpointConnected()) {
                        try {
                            chain.proceed(request, entityProducer, scope, asyncExecCallback);
                        }
                        catch (IOException | HttpException ex) {
                            asyncExecCallback.failed((Exception)ex);
                        }
                    } else {
                        AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                    }
                }

                public void failed(Exception ex) {
                    asyncExecCallback.failed(ex);
                }

                public void cancelled() {
                    asyncExecCallback.failed(new InterruptedIOException());
                }
            }));
        } else if (execRuntime.isEndpointConnected()) {
            try {
                chain.proceed(request, entityProducer, scope, asyncExecCallback);
            }
            catch (IOException | HttpException ex) {
                asyncExecCallback.failed((Exception)ex);
            }
        } else {
            this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
        }
    }

    private void proceedToNextHop(final State state, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) {
        final RouteTracker tracker = state.tracker;
        final String exchangeId = scope.exchangeId;
        final HttpRoute route = scope.route;
        final AsyncExecRuntime execRuntime = scope.execRuntime;
        CancellableDependency operation = scope.cancellableDependency;
        HttpClientContext clientContext = scope.clientContext;
        HttpRoute fact = tracker.toRoute();
        int step = this.routeDirector.nextStep(route, fact);
        switch (step) {
            case 1: {
                operation.setDependency(execRuntime.connectEndpoint(clientContext, new FutureCallback<AsyncExecRuntime>(){

                    public void completed(AsyncExecRuntime execRuntime) {
                        tracker.connectTarget(route.isSecure());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} connected to target", (Object)exchangeId);
                        }
                        AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                    }

                    public void failed(Exception ex) {
                        asyncExecCallback.failed(ex);
                    }

                    public void cancelled() {
                        asyncExecCallback.failed(new InterruptedIOException());
                    }
                }));
                break;
            }
            case 2: {
                operation.setDependency(execRuntime.connectEndpoint(clientContext, new FutureCallback<AsyncExecRuntime>(){

                    public void completed(AsyncExecRuntime execRuntime) {
                        HttpHost proxy = route.getProxyHost();
                        tracker.connectProxy(proxy, route.isSecure() && !route.isTunnelled());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} connected to proxy", (Object)exchangeId);
                        }
                        AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                    }

                    public void failed(Exception ex) {
                        asyncExecCallback.failed(ex);
                    }

                    public void cancelled() {
                        asyncExecCallback.failed(new InterruptedIOException());
                    }
                }));
                break;
            }
            case 3: {
                try {
                    HttpHost proxy = route.getProxyHost();
                    HttpHost target = route.getTargetHost();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} create tunnel", (Object)exchangeId);
                    }
                    this.createTunnel(state, proxy, target, scope, new AsyncExecCallback(){

                        @Override
                        public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                            return asyncExecCallback.handleResponse(response, entityDetails);
                        }

                        @Override
                        public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                            asyncExecCallback.handleInformationResponse(response);
                        }

                        @Override
                        public void completed() {
                            if (!execRuntime.isEndpointConnected()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} proxy disconnected", (Object)exchangeId);
                                }
                                state.tracker.reset();
                            }
                            if (state.challenged) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} proxy authentication required", (Object)exchangeId);
                                }
                                AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                            } else if (state.tunnelRefused) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} tunnel refused", (Object)exchangeId);
                                }
                                asyncExecCallback.failed((Exception)((Object)new TunnelRefusedException("CONNECT refused by proxy: " + new StatusLine(state.tunnelResponse), null)));
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} tunnel to target created", (Object)exchangeId);
                                }
                                tracker.tunnelTarget(false);
                                AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                            }
                        }

                        @Override
                        public void failed(Exception cause) {
                            execRuntime.markConnectionNonReusable();
                            asyncExecCallback.failed(cause);
                        }
                    });
                }
                catch (IOException | HttpException ex) {
                    asyncExecCallback.failed((Exception)ex);
                }
                break;
            }
            case 4: {
                asyncExecCallback.failed((Exception)((Object)new HttpException("Proxy chains are not supported")));
                break;
            }
            case 5: {
                execRuntime.upgradeTls(clientContext, new FutureCallback<AsyncExecRuntime>(){

                    public void completed(AsyncExecRuntime asyncExecRuntime) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} upgraded to TLS", (Object)exchangeId);
                        }
                        tracker.layerProtocol(route.isSecure());
                        AsyncConnectExec.this.proceedToNextHop(state, request, entityProducer, scope, chain, asyncExecCallback);
                    }

                    public void failed(Exception ex) {
                        asyncExecCallback.failed(ex);
                    }

                    public void cancelled() {
                        asyncExecCallback.failed(new InterruptedIOException());
                    }
                });
                break;
            }
            case -1: {
                asyncExecCallback.failed((Exception)((Object)new HttpException("Unable to establish route: planned = " + route + "; current = " + fact)));
                break;
            }
            case 0: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} route fully established", (Object)exchangeId);
                }
                try {
                    chain.proceed(request, entityProducer, scope, asyncExecCallback);
                }
                catch (IOException | HttpException ex) {
                    asyncExecCallback.failed((Exception)ex);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
            }
        }
    }

    private void createTunnel(final State state, final HttpHost proxy, final HttpHost nextHop, AsyncExecChain.Scope scope, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        AuthExchange proxyAuthExchange;
        CancellableDependency operation = scope.cancellableDependency;
        final HttpClientContext clientContext = scope.clientContext;
        AsyncExecRuntime execRuntime = scope.execRuntime;
        String exchangeId = scope.exchangeId;
        AuthExchange authExchange = proxyAuthExchange = proxy != null ? clientContext.getAuthExchange(proxy) : new AuthExchange();
        if (this.authCacheKeeper != null) {
            this.authCacheKeeper.loadPreemptively(proxy, null, proxyAuthExchange, (HttpContext)clientContext);
        }
        AsyncClientExchangeHandler internalExchangeHandler = new AsyncClientExchangeHandler(){
            private final AtomicReference<AsyncDataConsumer> entityConsumerRef = new AtomicReference();

            public void releaseResources() {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
            }

            public void failed(Exception cause) {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
                asyncExecCallback.failed(cause);
            }

            public void cancel() {
                this.failed(new InterruptedIOException());
            }

            public void produceRequest(RequestChannel requestChannel, HttpContext httpContext) throws HttpException, IOException {
                BasicHttpRequest connect = new BasicHttpRequest(Method.CONNECT, nextHop, nextHop.toHostString());
                connect.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
                AsyncConnectExec.this.proxyHttpProcessor.process((HttpRequest)connect, null, (HttpContext)clientContext);
                AsyncConnectExec.this.authenticator.addAuthResponse(proxy, ChallengeType.PROXY, (HttpRequest)connect, proxyAuthExchange, (HttpContext)clientContext);
                requestChannel.sendRequest((HttpRequest)connect, null, (HttpContext)clientContext);
            }

            public void produce(DataStreamChannel dataStreamChannel) throws IOException {
            }

            public int available() {
                return 0;
            }

            public void consumeInformation(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            }

            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
                clientContext.setAttribute("http.response", response);
                AsyncConnectExec.this.proxyHttpProcessor.process(response, entityDetails, (HttpContext)clientContext);
                int status = response.getCode();
                if (status < 200) {
                    throw new HttpException("Unexpected response to CONNECT request: " + new StatusLine(response));
                }
                if (AsyncConnectExec.this.needAuthentication(proxyAuthExchange, proxy, response, clientContext)) {
                    state.challenged = true;
                } else {
                    state.challenged = false;
                    if (status >= 300) {
                        state.tunnelRefused = true;
                        state.tunnelResponse = response;
                        this.entityConsumerRef.set(null);
                    } else if (status == 200) {
                        asyncExecCallback.completed();
                    } else {
                        throw new HttpException("Unexpected response to CONNECT request: " + new StatusLine(response));
                    }
                }
            }

            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.updateCapacity(capacityChannel);
                } else {
                    capacityChannel.update(Integer.MAX_VALUE);
                }
            }

            public void consume(ByteBuffer src) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.consume(src);
                }
            }

            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.streamEnd(trailers);
                }
                asyncExecCallback.completed();
            }
        };
        if (LOG.isDebugEnabled()) {
            operation.setDependency(execRuntime.execute(exchangeId, new LoggingAsyncClientExchangeHandler(LOG, exchangeId, internalExchangeHandler), clientContext));
        } else {
            operation.setDependency(execRuntime.execute(exchangeId, internalExchangeHandler, clientContext));
        }
    }

    private boolean needAuthentication(AuthExchange proxyAuthExchange, HttpHost proxy, HttpResponse response, HttpClientContext context) {
        RequestConfig config = context.getRequestConfig();
        if (config.isAuthenticationEnabled()) {
            boolean proxyAuthRequested = this.authenticator.isChallenged(proxy, ChallengeType.PROXY, response, proxyAuthExchange, (HttpContext)context);
            if (this.authCacheKeeper != null) {
                if (proxyAuthRequested) {
                    this.authCacheKeeper.updateOnChallenge(proxy, null, proxyAuthExchange, (HttpContext)context);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(proxy, null, proxyAuthExchange, (HttpContext)context);
                }
            }
            if (proxyAuthRequested) {
                boolean updated = this.authenticator.updateAuthState(proxy, ChallengeType.PROXY, response, this.proxyAuthStrategy, proxyAuthExchange, (HttpContext)context);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(proxy, null, proxyAuthExchange, (HttpContext)context);
                }
                return updated;
            }
        }
        return false;
    }

    static class State {
        final RouteTracker tracker;
        volatile boolean challenged;
        volatile boolean tunnelRefused;
        volatile HttpResponse tunnelResponse;

        State(HttpRoute route) {
            this.tracker = new RouteTracker(route);
        }
    }
}

